/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import noppes.npcs.CustomNpcs;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.gui.util.GuiMenuTopButton;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.IGuiInterface;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.server.SPacketMenuClose;
import noppes.npcs.packets.server.SPacketNpcDelete;

public class GuiNpcMenu {
    private IGuiInterface parent;
    private GuiMenuTopButton[] topButtons = new GuiMenuTopButton[0];
    private int activeMenu;
    private EntityNPCInterface npc;

    public GuiNpcMenu(IGuiInterface parent, int activeMenu, EntityNPCInterface npc) {
        this.parent = parent;
        this.activeMenu = activeMenu;
        this.npc = npc;
    }

    public void initGui(int guiLeft, int guiTop, int width) {
        final Minecraft mc = Minecraft.func_71410_x();
        mc.field_195559_v.func_197967_a(true);
        GuiMenuTopButton display = new GuiMenuTopButton(this.parent, 1, guiLeft + 4, guiTop - 17, "menu.display"){

            @Override
            public void func_230982_a_(double x, double y) {
                GuiNpcMenu.this.save();
                GuiNpcMenu.this.activeMenu = 1;
                CustomNpcs.proxy.openGui(GuiNpcMenu.this.npc, EnumGuiType.MainMenuDisplay);
            }
        };
        GuiMenuTopButton stats = new GuiMenuTopButton(this.parent, 2, display.field_230690_l_ + display.func_230998_h_(), guiTop - 17, "menu.stats"){

            @Override
            public void func_230982_a_(double x, double y) {
                GuiNpcMenu.this.save();
                GuiNpcMenu.this.activeMenu = 2;
                CustomNpcs.proxy.openGui(GuiNpcMenu.this.npc, EnumGuiType.MainMenuStats);
            }
        };
        GuiMenuTopButton ai = new GuiMenuTopButton(this.parent, 3, stats.field_230690_l_ + stats.func_230998_h_(), guiTop - 17, "menu.ai"){

            @Override
            public void func_230982_a_(double x, double y) {
                GuiNpcMenu.this.save();
                GuiNpcMenu.this.activeMenu = 3;
                CustomNpcs.proxy.openGui(GuiNpcMenu.this.npc, EnumGuiType.MainMenuAI);
            }
        };
        GuiMenuTopButton inv = new GuiMenuTopButton(this.parent, 4, ai.field_230690_l_ + ai.func_230998_h_(), guiTop - 17, "menu.inventory"){

            @Override
            public void func_230982_a_(double x, double y) {
                GuiNpcMenu.this.save();
                GuiNpcMenu.this.activeMenu = 4;
                NoppesUtil.requestOpenGUI(EnumGuiType.MainMenuInv);
            }
        };
        GuiMenuTopButton advanced = new GuiMenuTopButton(this.parent, 5, inv.field_230690_l_ + inv.func_230998_h_(), guiTop - 17, "menu.advanced"){

            @Override
            public void func_230982_a_(double x, double y) {
                GuiNpcMenu.this.save();
                GuiNpcMenu.this.activeMenu = 5;
                CustomNpcs.proxy.openGui(GuiNpcMenu.this.npc, EnumGuiType.MainMenuAdvanced);
            }
        };
        GuiMenuTopButton global = new GuiMenuTopButton(this.parent, 6, advanced.field_230690_l_ + advanced.func_230998_h_(), guiTop - 17, "menu.global"){

            @Override
            public void func_230982_a_(double x, double y) {
                GuiNpcMenu.this.save();
                GuiNpcMenu.this.activeMenu = 6;
                CustomNpcs.proxy.openGui(GuiNpcMenu.this.npc, EnumGuiType.MainMenuGlobal);
            }
        };
        GuiMenuTopButton close = new GuiMenuTopButton(this.parent, 0, guiLeft + width - 22, guiTop - 17, "X"){

            @Override
            public void func_230982_a_(double x, double y) {
                GuiNpcMenu.this.close();
            }
        };
        GuiMenuTopButton delete = new GuiMenuTopButton(this.parent, 66, guiLeft + width - 72, guiTop - 17, "selectWorld.deleteButton"){

            @Override
            public void func_230982_a_(double x, double y) {
                ConfirmScreen guiyesno = new ConfirmScreen(GuiNpcMenu.this::accept, (ITextComponent)new TranslationTextComponent(""), (ITextComponent)new TranslationTextComponent("gui.deleteMessage"));
                mc.func_147108_a((Screen)guiyesno);
            }
        };
        delete.field_230690_l_ = close.field_230690_l_ - delete.func_230998_h_();
        for (GuiMenuTopButton button : this.topButtons = new GuiMenuTopButton[]{display, stats, ai, inv, advanced, global, close, delete}) {
            button.field_230693_o_ = button.id == this.activeMenu;
        }
    }

    private void save() {
        GuiNpcTextField.unfocus();
        this.parent.save();
    }

    private void close() {
        ((Screen)this.parent).func_231175_as__();
        if (this.npc != null) {
            this.npc.reset();
            Packets.sendServer(new SPacketMenuClose());
        }
    }

    public boolean mouseClicked(double i, double j, int k) {
        if (k == 0) {
            Minecraft mc = Minecraft.func_71410_x();
            for (GuiMenuTopButton button : this.topButtons) {
                if (!button.func_231044_a_(i, j, k)) continue;
                return true;
            }
        }
        return false;
    }

    public void drawElements(MatrixStack matrixStack, FontRenderer font, int i, int j, Minecraft mc, float f) {
        for (GuiMenuTopButton button : this.topButtons) {
            button.func_230430_a_(matrixStack, i, j, f);
        }
    }

    public void accept(boolean flag) {
        Minecraft mc = Minecraft.func_71410_x();
        if (flag) {
            Packets.sendServer(new SPacketNpcDelete());
            mc.func_147108_a(null);
            mc.field_71417_B.func_198034_i();
        } else {
            NoppesUtil.openGUI((PlayerEntity)mc.field_71439_g, this.parent);
        }
    }
}

