/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.data.Faction;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerFactionData;

public class CmdFaction {
    public static LiteralArgumentBuilder<CommandSource> register() {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"faction").requires(source -> source.func_197034_c(2))).then(Commands.func_197056_a((String)"players", (ArgumentType)EntityArgument.func_197094_d()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"faction", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.func_197057_a((String)"add").then(Commands.func_197056_a((String)"points", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            Collection players = EntityArgument.func_197090_e((CommandContext)context, (String)"players");
            if (players.isEmpty()) {
                return 1;
            }
            Faction faction = FactionController.instance.factions.get(IntegerArgumentType.getInteger((CommandContext)context, (String)"faction"));
            if (faction == null) {
                throw new CommandException((ITextComponent)new StringTextComponent("Unknown FactionID"));
            }
            int points = IntegerArgumentType.getInteger((CommandContext)context, (String)"points");
            for (ServerPlayerEntity player : players) {
                PlayerData data = PlayerData.get((PlayerEntity)player);
                PlayerFactionData playerfactiondata = data.factionData;
                playerfactiondata.increasePoints((PlayerEntity)player, faction.id, points);
                data.save(true);
            }
            return 1;
        })))).then(Commands.func_197057_a((String)"set").then(Commands.func_197056_a((String)"points", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            Collection players = EntityArgument.func_197090_e((CommandContext)context, (String)"players");
            if (players.isEmpty()) {
                return 1;
            }
            Faction faction = FactionController.instance.factions.get(IntegerArgumentType.getInteger((CommandContext)context, (String)"faction"));
            if (faction == null) {
                throw new CommandException((ITextComponent)new StringTextComponent("Unknown FactionID"));
            }
            int points = IntegerArgumentType.getInteger((CommandContext)context, (String)"points");
            for (ServerPlayerEntity player : players) {
                PlayerData data = PlayerData.get((PlayerEntity)player);
                PlayerFactionData playerfactiondata = data.factionData;
                playerfactiondata.factionData.put(faction.id, points);
                data.save(true);
            }
            return 1;
        })))).then(Commands.func_197057_a((String)"reset").executes(context -> {
            Collection players = EntityArgument.func_197090_e((CommandContext)context, (String)"players");
            if (players.isEmpty()) {
                return 1;
            }
            Faction faction = FactionController.instance.factions.get(IntegerArgumentType.getInteger((CommandContext)context, (String)"faction"));
            if (faction == null) {
                throw new CommandException((ITextComponent)new StringTextComponent("Unknown FactionID"));
            }
            for (ServerPlayerEntity player : players) {
                PlayerData data = PlayerData.get((PlayerEntity)player);
                data.factionData.factionData.put(faction.id, faction.defaultPoints);
                data.save(true);
            }
            return 1;
        }))).then(Commands.func_197057_a((String)"drop").executes(context -> {
            Collection players = EntityArgument.func_197090_e((CommandContext)context, (String)"players");
            if (players.isEmpty()) {
                return 1;
            }
            Faction faction = FactionController.instance.factions.get(IntegerArgumentType.getInteger((CommandContext)context, (String)"faction"));
            if (faction == null) {
                throw new CommandException((ITextComponent)new StringTextComponent("Unknown FactionID"));
            }
            for (ServerPlayerEntity player : players) {
                PlayerData data = PlayerData.get((PlayerEntity)player);
                data.factionData.factionData.remove(faction.id);
                data.save(true);
            }
            return 1;
        }))));
        return command;
    }
}

