/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.entity.player.ServerPlayerEntity;
import noppes.npcs.CustomItems;
import noppes.npcs.entity.EntityNPCInterface;

public class VisibilityController {
    public static VisibilityController instance = new VisibilityController();
    private Map<Integer, EntityNPCInterface> trackedEntityHashTable = new TreeMap<Integer, EntityNPCInterface>();

    public void trackNpc(EntityNPCInterface npc) {
        boolean hasOptions = npc.display.availability.hasOptions();
        if ((hasOptions || npc.display.getVisible() != 0) && !this.trackedEntityHashTable.containsKey(npc.func_145782_y())) {
            this.trackedEntityHashTable.put(npc.func_145782_y(), npc);
        }
        if (!hasOptions && npc.display.getVisible() == 0 && this.trackedEntityHashTable.containsKey(npc.func_145782_y())) {
            this.trackedEntityHashTable.remove(npc.func_145782_y());
        }
    }

    public void onUpdate(ServerPlayerEntity player) {
        for (Map.Entry<Integer, EntityNPCInterface> entry : this.trackedEntityHashTable.entrySet()) {
            VisibilityController.checkIsVisible(entry.getValue(), player);
        }
    }

    public static void checkIsVisible(EntityNPCInterface npc, ServerPlayerEntity playerMP) {
        if (npc.display.isVisibleTo(playerMP) || playerMP.func_175149_v() || playerMP.func_184614_ca().func_77973_b() == CustomItems.wand) {
            npc.setVisible(playerMP);
        } else {
            npc.setInvisible(playerMP);
        }
    }

    public static void addValue(HashMap<Integer, ArrayList<EntityNPCInterface>> map, int id, EntityNPCInterface npc) {
        ArrayList<EntityNPCInterface> npcs;
        if (!map.containsKey(id)) {
            map.put(id, new ArrayList());
        }
        if (!(npcs = map.get(id)).contains((Object)npc)) {
            npcs.add(npc);
            map.replace(id, npcs);
        }
    }
}

