/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import noppes.npcs.EventHooks;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.event.PlayerEvent;
import noppes.npcs.api.wrapper.PlayerWrapper;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.data.Faction;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerScriptData;

public class PlayerFactionData {
    public HashMap<Integer, Integer> factionData = new HashMap();

    public void loadNBTData(CompoundNBT compound) {
        HashMap<Integer, Integer> factionData = new HashMap<Integer, Integer>();
        if (compound == null) {
            return;
        }
        ListNBT list = compound.func_150295_c("FactionData", 10);
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT nbttagcompound = list.func_150305_b(i);
            factionData.put(nbttagcompound.func_74762_e("Faction"), nbttagcompound.func_74762_e("Points"));
        }
        this.factionData = factionData;
    }

    public void saveNBTData(CompoundNBT compound) {
        ListNBT list = new ListNBT();
        for (int faction : this.factionData.keySet()) {
            CompoundNBT nbttagcompound = new CompoundNBT();
            nbttagcompound.func_74768_a("Faction", faction);
            nbttagcompound.func_74768_a("Points", this.factionData.get(faction).intValue());
            list.add((Object)nbttagcompound);
        }
        compound.func_218657_a("FactionData", (INBT)list);
    }

    public int getFactionPoints(PlayerEntity player, int factionId) {
        Faction faction = FactionController.instance.getFaction(factionId);
        if (faction == null) {
            return 0;
        }
        if (!this.factionData.containsKey(factionId)) {
            if (player.field_70170_p.field_72995_K) {
                this.factionData.put(factionId, faction.defaultPoints);
                return faction.defaultPoints;
            }
            PlayerScriptData handler = PlayerData.get((PlayerEntity)player).scriptData;
            PlayerWrapper wrapper = (PlayerWrapper)NpcAPI.Instance().getIEntity((Entity)player);
            PlayerEvent.FactionUpdateEvent event = new PlayerEvent.FactionUpdateEvent(wrapper, faction, faction.defaultPoints, true);
            EventHooks.OnPlayerFactionChange(handler, event);
            this.factionData.put(factionId, event.points);
            PlayerData data = PlayerData.get(player);
            data.updateClient = true;
        }
        return this.factionData.get(factionId);
    }

    public void increasePoints(PlayerEntity player, int factionId, int points) {
        PlayerEvent.FactionUpdateEvent event;
        Faction faction = FactionController.instance.getFaction(factionId);
        if (faction == null || player == null || player.field_70170_p.field_72995_K) {
            return;
        }
        PlayerScriptData handler = PlayerData.get((PlayerEntity)player).scriptData;
        PlayerWrapper wrapper = (PlayerWrapper)NpcAPI.Instance().getIEntity((Entity)player);
        if (!this.factionData.containsKey(factionId)) {
            event = new PlayerEvent.FactionUpdateEvent(wrapper, faction, faction.defaultPoints, true);
            EventHooks.OnPlayerFactionChange(handler, event);
            this.factionData.put(factionId, event.points);
        }
        event = new PlayerEvent.FactionUpdateEvent(wrapper, faction, points, false);
        EventHooks.OnPlayerFactionChange(handler, event);
        this.factionData.put(factionId, this.factionData.get(factionId) + points);
    }

    public CompoundNBT getPlayerGuiData() {
        CompoundNBT compound = new CompoundNBT();
        this.saveNBTData(compound);
        ListNBT list = new ListNBT();
        for (int id : this.factionData.keySet()) {
            Faction faction = FactionController.instance.getFaction(id);
            if (faction == null || faction.hideFaction) continue;
            CompoundNBT com = new CompoundNBT();
            faction.writeNBT(com);
            list.add((Object)com);
        }
        compound.func_218657_a("FactionList", (INBT)list);
        return compound;
    }
}

