/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.OpenDoorGoal;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.ai.goal.RestrictSunGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcs;
import noppes.npcs.EventHooks;
import noppes.npcs.IChatMessages;
import noppes.npcs.NBTTags;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.NpcDamageSource;
import noppes.npcs.VersionCompatibility;
import noppes.npcs.ai.CombatHandler;
import noppes.npcs.ai.EntityAIAnimation;
import noppes.npcs.ai.EntityAIAttackTarget;
import noppes.npcs.ai.EntityAIAvoidTarget;
import noppes.npcs.ai.EntityAIBustDoor;
import noppes.npcs.ai.EntityAIFindShade;
import noppes.npcs.ai.EntityAIFollow;
import noppes.npcs.ai.EntityAIJob;
import noppes.npcs.ai.EntityAILook;
import noppes.npcs.ai.EntityAIMoveIndoors;
import noppes.npcs.ai.EntityAIMovingPath;
import noppes.npcs.ai.EntityAIPanic;
import noppes.npcs.ai.EntityAIPounceTarget;
import noppes.npcs.ai.EntityAIRangedAttack;
import noppes.npcs.ai.EntityAIReturn;
import noppes.npcs.ai.EntityAIRole;
import noppes.npcs.ai.EntityAISprintToTarget;
import noppes.npcs.ai.EntityAITransform;
import noppes.npcs.ai.EntityAIWander;
import noppes.npcs.ai.EntityAIWatchClosest;
import noppes.npcs.ai.EntityAIWaterNav;
import noppes.npcs.ai.EntityAIWorldLines;
import noppes.npcs.ai.FlyingMoveHelper;
import noppes.npcs.ai.selector.NPCAttackSelector;
import noppes.npcs.ai.target.EntityAIClearTarget;
import noppes.npcs.ai.target.EntityAIOwnerHurtByTarget;
import noppes.npcs.ai.target.EntityAIOwnerHurtTarget;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.constants.PotionEffectType;
import noppes.npcs.api.entity.ICustomNpc;
import noppes.npcs.api.entity.IProjectile;
import noppes.npcs.api.event.NpcEvent;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.wrapper.ItemStackWrapper;
import noppes.npcs.api.wrapper.NPCWrapper;
import noppes.npcs.client.EntityUtil;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.LinkedNpcController;
import noppes.npcs.controllers.data.DataTransform;
import noppes.npcs.controllers.data.Dialog;
import noppes.npcs.controllers.data.DialogOption;
import noppes.npcs.controllers.data.Faction;
import noppes.npcs.controllers.data.Line;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.QuestData;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityProjectile;
import noppes.npcs.entity.data.DataAI;
import noppes.npcs.entity.data.DataAbilities;
import noppes.npcs.entity.data.DataAdvanced;
import noppes.npcs.entity.data.DataDisplay;
import noppes.npcs.entity.data.DataInventory;
import noppes.npcs.entity.data.DataScript;
import noppes.npcs.entity.data.DataStats;
import noppes.npcs.entity.data.DataTimers;
import noppes.npcs.items.ItemSoulstoneFilled;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.client.PacketChatBubble;
import noppes.npcs.packets.client.PacketNpcUpdate;
import noppes.npcs.packets.client.PacketNpcVisibleFalse;
import noppes.npcs.packets.client.PacketNpcVisibleTrue;
import noppes.npcs.packets.client.PacketPlaySound;
import noppes.npcs.packets.client.PacketQuestCompletion;
import noppes.npcs.roles.JobBard;
import noppes.npcs.roles.JobFollower;
import noppes.npcs.roles.JobInterface;
import noppes.npcs.roles.RoleCompanion;
import noppes.npcs.roles.RoleFollower;
import noppes.npcs.roles.RoleInterface;
import noppes.npcs.util.GameProfileAlt;

public abstract class EntityNPCInterface
extends CreatureEntity
implements IEntityAdditionalSpawnData,
IRangedAttackMob {
    public static final DataParameter<Boolean> Attacking = EntityDataManager.func_187226_a(EntityNPCInterface.class, (IDataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Integer> Animation = EntityDataManager.func_187226_a(EntityNPCInterface.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<String> RoleData = EntityDataManager.func_187226_a(EntityNPCInterface.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> JobData = EntityDataManager.func_187226_a(EntityNPCInterface.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Integer> FactionData = EntityDataManager.func_187226_a(EntityNPCInterface.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> Walking = EntityDataManager.func_187226_a(EntityNPCInterface.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> Interacting = EntityDataManager.func_187226_a(EntityNPCInterface.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IsDead = EntityDataManager.func_187226_a(EntityNPCInterface.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final GameProfileAlt CommandProfile = new GameProfileAlt();
    public static final GameProfileAlt ChatEventProfile = new GameProfileAlt();
    public static final GameProfileAlt GenericProfile = new GameProfileAlt();
    public static FakePlayer ChatEventPlayer;
    public static FakePlayer CommandPlayer;
    public static FakePlayer GenericPlayer;
    public ICustomNpc wrappedNPC;
    public final DataAbilities abilities = new DataAbilities(this);
    public DataDisplay display = new DataDisplay(this);
    public DataStats stats = new DataStats(this);
    public DataInventory inventory = new DataInventory(this);
    public final DataAI ais = new DataAI(this);
    public final DataAdvanced advanced = new DataAdvanced(this);
    public final DataScript script = new DataScript(this);
    public final DataTransform transform = new DataTransform(this);
    public final DataTimers timers = new DataTimers((Object)this);
    public CombatHandler combatHandler = new CombatHandler(this);
    public String linkedName = "";
    public long linkedLast = 0L;
    public LinkedNpcController.LinkedData linkedData;
    public EntitySize baseSize = new EntitySize(0.6f, 1.8f, false);
    private static final EntitySize sizeSleep;
    public float scaleX;
    public float scaleY;
    public float scaleZ;
    private boolean wasKilled = false;
    public RoleInterface role = RoleInterface.NONE;
    public JobInterface job = JobInterface.NONE;
    public HashMap<Integer, DialogOption> dialogs;
    public boolean hasDied = false;
    public long killedtime = 0L;
    public long totalTicksAlive = 0L;
    private int taskCount = 1;
    public int lastInteract = 0;
    public Faction faction;
    private EntityAIRangedAttack aiRange;
    private Goal aiAttackTarget;
    public EntityAILook lookAi;
    public EntityAIAnimation animateAi;
    public List<LivingEntity> interactingEntities = new ArrayList<LivingEntity>();
    public ResourceLocation textureLocation = null;
    public ResourceLocation textureGlowLocation = null;
    public ResourceLocation textureCloakLocation = null;
    public int currentAnimation = 0;
    public int animationStart = 0;
    public int npcVersion = VersionCompatibility.ModRev;
    public IChatMessages messages;
    public boolean updateClient = false;
    public boolean updateAI = false;
    public final ServerBossInfo bossInfo;
    public final HashSet<Integer> tracking = new HashSet();
    public double prevChasingPosX;
    public double prevChasingPosY;
    public double prevChasingPosZ;
    public double chasingPosX;
    public double chasingPosY;
    public double chasingPosZ;
    private double startYPos = -1.0;

    public EntityNPCInterface(EntityType<? extends CreatureEntity> type, World world) {
        super(type, world);
        if (!this.isClientSide()) {
            this.wrappedNPC = new NPCWrapper<EntityNPCInterface>(this);
        }
        this.registerBaseAttributes();
        this.dialogs = new HashMap();
        if (!CustomNpcs.DefaultInteractLine.isEmpty()) {
            this.advanced.interactLines.lines.put(0, new Line(CustomNpcs.DefaultInteractLine));
        }
        this.field_70728_aV = 0;
        this.scaleZ = 0.9375f;
        this.scaleY = 0.9375f;
        this.scaleX = 0.9375f;
        this.faction = this.getFaction();
        this.setFaction(this.faction.id);
        this.updateAI = true;
        this.bossInfo = new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.PURPLE, BossInfo.Overlay.PROGRESS);
        this.bossInfo.func_186758_d(false);
    }

    public boolean func_70648_aU() {
        return this.ais.movementType == 2;
    }

    public boolean func_96092_aw() {
        return this.ais.movementType != 2;
    }

    private void registerBaseAttributes() {
        this.func_110148_a(Attributes.field_233818_a_).func_111128_a((double)this.stats.maxHealth);
        this.func_110148_a(Attributes.field_233819_b_).func_111128_a((double)CustomNpcs.NpcNavRange);
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a((double)this.func_70689_ay());
        this.func_110148_a(Attributes.field_233823_f_).func_111128_a((double)this.stats.melee.getStrength());
        this.func_110148_a(Attributes.field_233822_e_).func_111128_a((double)(this.func_70689_ay() * 2.0f));
    }

    public static AttributeModifierMap.MutableAttribute createMobAttributes() {
        return LivingEntity.func_233639_cI_().func_233814_a_(Attributes.field_233823_f_).func_233814_a_(Attributes.field_233822_e_).func_233814_a_(Attributes.field_233819_b_);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(RoleData, (Object)String.valueOf(""));
        this.field_70180_af.func_187214_a(JobData, (Object)String.valueOf(""));
        this.field_70180_af.func_187214_a(FactionData, (Object)0);
        this.field_70180_af.func_187214_a(Animation, (Object)0);
        this.field_70180_af.func_187214_a(Walking, (Object)false);
        this.field_70180_af.func_187214_a(Interacting, (Object)false);
        this.field_70180_af.func_187214_a(IsDead, (Object)false);
        this.field_70180_af.func_187214_a(Attacking, (Object)false);
    }

    public boolean func_70089_S() {
        return super.func_70089_S() && !this.isKilled();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa % 10 == 0) {
            this.startYPos = this.calculateStartYPos(this.ais.startPos()) + 1.0;
            if (this.startYPos < 0.0 && !this.isClientSide()) {
                this.func_70106_y();
            }
            EventHooks.onNPCTick(this);
        }
        this.timers.update();
        if (this.field_70170_p.field_72995_K && this.wasKilled != this.isKilled() && this.wasKilled) {
            this.field_70725_aQ = 0;
            this.func_213323_x_();
        }
        this.wasKilled = this.isKilled();
        if (this.currentAnimation == 14) {
            this.field_70725_aQ = 19;
        }
    }

    public boolean func_70652_k(Entity par1Entity) {
        boolean var4;
        float f = this.stats.melee.getStrength();
        if (this.stats.melee.getDelay() < 10) {
            par1Entity.field_70172_ad = 0;
        }
        if (par1Entity instanceof LivingEntity) {
            NpcEvent.MeleeAttackEvent event = new NpcEvent.MeleeAttackEvent(this.wrappedNPC, (LivingEntity)par1Entity, f);
            if (EventHooks.onNPCAttacksMelee(this, event)) {
                return false;
            }
            f = event.damage;
        }
        if (var4 = par1Entity.func_70097_a((DamageSource)new NpcDamageSource("mob", (Entity)this), f)) {
            if (this.getOwner() instanceof PlayerEntity) {
                EntityUtil.setRecentlyHit((LivingEntity)par1Entity);
            }
            if (this.stats.melee.getKnockback() > 0) {
                par1Entity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)this.stats.melee.getKnockback() * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)this.stats.melee.getKnockback() * 0.5f));
                Vector3d motion = this.func_213322_ci();
                this.func_213317_d(this.func_213322_ci().func_216372_d(0.6, 1.0, 0.6));
            }
            if (this.role.getType() == 6) {
                ((RoleCompanion)this.role).attackedEntity(par1Entity);
            }
        }
        if (this.stats.melee.getEffectType() != 0) {
            if (this.stats.melee.getEffectType() != 666) {
                ((LivingEntity)par1Entity).func_195064_c(new EffectInstance(PotionEffectType.getMCType(this.stats.melee.getEffectType()), this.stats.melee.getEffectTime() * 20, this.stats.melee.getEffectStrength()));
            } else {
                par1Entity.func_241209_g_(this.stats.melee.getEffectTime());
            }
        }
        return var4;
    }

    public void func_70636_d() {
        float f;
        if (CustomNpcs.FreezeNPCs) {
            return;
        }
        if (this.func_175446_cd()) {
            super.func_70636_d();
            return;
        }
        ++this.totalTicksAlive;
        this.func_82168_bl();
        if (this.field_70173_aa % 20 == 0) {
            this.faction = this.getFaction();
        }
        if (!this.field_70170_p.field_72995_K) {
            if (!this.isKilled() && this.field_70173_aa % 20 == 0) {
                this.advanced.scenes.update();
                if (this.func_110143_aJ() < this.func_110138_aP()) {
                    if (this.stats.healthRegen > 0 && !this.isAttacking()) {
                        this.func_70691_i(this.stats.healthRegen);
                    }
                    if (this.stats.combatRegen > 0 && this.isAttacking()) {
                        this.func_70691_i(this.stats.combatRegen);
                    }
                }
                if (this.faction.getsAttacked && !this.isAttacking()) {
                    List list = this.field_70170_p.func_217357_a(MonsterEntity.class, this.func_174813_aQ().func_72314_b(16.0, 16.0, 16.0));
                    for (MonsterEntity mob : list) {
                        if (mob.func_70638_az() != null || !this.canNpcSee((Entity)mob)) continue;
                        mob.func_70624_b((LivingEntity)this);
                    }
                }
                if (this.linkedData != null && this.linkedData.time > this.linkedLast) {
                    LinkedNpcController.Instance.loadNpcData(this);
                }
                if (this.updateClient) {
                    this.updateClient();
                }
                if (this.updateAI) {
                    this.updateTasks();
                    this.updateAI = false;
                }
            }
            if (this.func_110143_aJ() <= 0.0f && !this.isKilled()) {
                this.func_195061_cb();
                this.field_70180_af.func_187227_b(IsDead, (Object)true);
                this.updateTasks();
                this.func_213323_x_();
            }
            if (this.display.getBossbar() == 2) {
                this.bossInfo.func_186758_d(this.func_70638_az() != null);
            }
            this.field_70180_af.func_187227_b(Walking, (Object)(!this.func_70661_as().func_75500_f() ? 1 : 0));
            this.field_70180_af.func_187227_b(Interacting, (Object)this.isInteracting());
            this.combatHandler.update();
            this.onCollide();
        }
        if (this.wasKilled != this.isKilled() && this.wasKilled) {
            this.reset();
        }
        if (this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K && this.stats.burnInSun && (f = this.func_70013_c()) > 0.5f && this.field_70146_Z.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && this.field_70170_p.func_226660_f_(this.func_233580_cy_())) {
            this.func_241209_g_(8);
        }
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            this.role.clientUpdate();
            if (this.textureCloakLocation != null) {
                this.cloakUpdate();
            }
            if (this.currentAnimation != (Integer)this.field_70180_af.func_187225_a(Animation)) {
                this.currentAnimation = (Integer)this.field_70180_af.func_187225_a(Animation);
                this.animationStart = this.field_70173_aa;
                this.func_213323_x_();
            }
            if (this.job.getType() == 1) {
                ((JobBard)this.job).aiStep();
            }
        }
        if (this.display.getBossbar() > 0) {
            this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        }
    }

    public void updateClient() {
        Packets.sendNearby((Entity)this, new PacketNpcUpdate(this.func_145782_y(), this.writeSpawnData()));
        this.updateClient = false;
    }

    protected ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        if (this.field_70170_p.field_72995_K) {
            return this.isAttacking() ? ActionResultType.SUCCESS : ActionResultType.FAIL;
        }
        if (hand != Hand.MAIN_HAND) {
            return ActionResultType.PASS;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (stack != null) {
            Item item = stack.func_77973_b();
            if (item == CustomItems.cloner || item == CustomItems.wand || item == CustomItems.mount || item == CustomItems.scripter) {
                this.func_70624_b(null);
                this.func_70604_c(null);
                return ActionResultType.SUCCESS;
            }
            if (item == CustomItems.moving) {
                this.func_70624_b(null);
                stack.func_77983_a("NPCID", (INBT)IntNBT.func_229692_a_((int)this.func_145782_y()));
                player.func_145747_a((ITextComponent)new TranslationTextComponent("message.pather.register", new Object[]{this.func_200200_C_()}), this.func_110124_au());
                return ActionResultType.SUCCESS;
            }
        }
        if (EventHooks.onNPCInteract(this, player)) {
            return ActionResultType.FAIL;
        }
        if (this.getFaction().isAggressiveToPlayer(player)) {
            return ActionResultType.FAIL;
        }
        this.addInteract((LivingEntity)player);
        Dialog dialog = this.getDialog(player);
        QuestData data = PlayerData.get((PlayerEntity)player).questData.getQuestCompletion(player, this);
        if (data != null) {
            Packets.send((ServerPlayerEntity)player, new PacketQuestCompletion(data.quest.id));
        } else if (dialog != null) {
            NoppesUtilServer.openDialog(player, this, dialog);
        } else if (this.role.getType() != 0) {
            this.role.interact(player);
        } else {
            this.say(player, this.advanced.getInteractLine());
        }
        return ActionResultType.PASS;
    }

    public void addInteract(LivingEntity entity) {
        if (!this.ais.stopAndInteract || this.isAttacking() || !entity.func_70089_S() || this.func_175446_cd()) {
            return;
        }
        if (this.field_70173_aa - this.lastInteract < 180) {
            this.interactingEntities.clear();
        }
        this.func_70661_as().func_75499_g();
        this.lastInteract = this.field_70173_aa;
        if (!this.interactingEntities.contains(entity)) {
            this.interactingEntities.add(entity);
        }
    }

    public boolean isInteracting() {
        if (this.field_70173_aa - this.lastInteract < 40 || this.isClientSide() && ((Boolean)this.field_70180_af.func_187225_a(Interacting)).booleanValue()) {
            return true;
        }
        return this.ais.stopAndInteract && !this.interactingEntities.isEmpty() && this.field_70173_aa - this.lastInteract < 180;
    }

    private Dialog getDialog(PlayerEntity player) {
        for (DialogOption option : this.dialogs.values()) {
            if (option == null || !option.hasDialog()) continue;
            Dialog dialog = option.getDialog();
            if (!dialog.availability.isAvailable(player)) continue;
            return dialog;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean func_70097_a(DamageSource damagesource, float i) {
        if (this.field_70170_p.field_72995_K || CustomNpcs.FreezeNPCs || damagesource.field_76373_n.equals("inWall")) {
            return false;
        }
        if (damagesource.field_76373_n.equals("outOfWorld") && this.isKilled()) {
            this.reset();
        }
        i = this.stats.resistances.applyResistance(damagesource, i);
        float f = this.field_70172_ad;
        ((Object)((Object)this)).getClass();
        if (f > 20.0f / 2.0f && i <= this.field_110153_bc) {
            return false;
        }
        Entity entity = NoppesUtilServer.GetDamageSourcee(damagesource);
        LivingEntity attackingEntity = null;
        if (entity instanceof LivingEntity) {
            attackingEntity = (LivingEntity)entity;
        }
        if (attackingEntity != null && attackingEntity == this.getOwner()) {
            return false;
        }
        if (attackingEntity instanceof EntityNPCInterface) {
            EntityNPCInterface npc = (EntityNPCInterface)attackingEntity;
            if (npc.faction.id == this.faction.id) {
                return false;
            }
            if (npc.getOwner() instanceof PlayerEntity) {
                this.field_70737_aN = 100;
            }
        } else if (attackingEntity instanceof PlayerEntity && this.faction.isFriendlyToPlayer((PlayerEntity)attackingEntity)) {
            ForgeHooks.onLivingAttack((LivingEntity)this, (DamageSource)damagesource, (float)i);
            return false;
        }
        NpcEvent.DamagedEvent event = new NpcEvent.DamagedEvent(this.wrappedNPC, entity, i, damagesource);
        if (EventHooks.onNPCDamaged(this, event)) {
            ForgeHooks.onLivingAttack((LivingEntity)this, (DamageSource)damagesource, (float)i);
            return false;
        }
        i = event.damage;
        if (this.isKilled()) {
            return false;
        }
        if (attackingEntity == null) {
            return super.func_70097_a(damagesource, i);
        }
        try {
            if (this.isAttacking()) {
                if (this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) > this.func_70068_e((Entity)attackingEntity)) {
                    this.func_70624_b(attackingEntity);
                }
                boolean bl = super.func_70097_a(damagesource, i);
                return bl;
            }
            if (i > 0.0f) {
                List inRange = this.field_70170_p.func_217357_a(EntityNPCInterface.class, this.func_174813_aQ().func_72314_b(32.0, 16.0, 32.0));
                for (EntityNPCInterface npc : inRange) {
                    if (npc.isKilled() || !npc.advanced.defendFaction || npc.faction.id != this.faction.id || !npc.canNpcSee((Entity)this) && !npc.ais.directLOS && !npc.canNpcSee((Entity)attackingEntity)) continue;
                    npc.onAttack(attackingEntity);
                }
                this.func_70624_b(attackingEntity);
            }
            boolean bl = super.func_70097_a(damagesource, i);
            return bl;
        }
        finally {
            if (event.clearTarget) {
                this.func_70624_b(null);
                this.func_70604_c(null);
            }
        }
    }

    protected void func_70665_d(DamageSource damageSrc, float damageAmount) {
        super.func_70665_d(damageSrc, damageAmount);
        this.combatHandler.damage(damageSrc, damageAmount);
    }

    public void onAttack(LivingEntity entity) {
        if (entity == null || entity == this || this.isAttacking() || this.ais.onAttack == 3 || entity == this.getOwner()) {
            return;
        }
        super.func_70624_b(entity);
    }

    public void func_70624_b(LivingEntity entity) {
        Line line;
        if (entity instanceof PlayerEntity && ((PlayerEntity)entity).field_71075_bZ.field_75102_a || entity != null && entity == this.getOwner() || this.func_70638_az() == entity) {
            return;
        }
        if (entity != null) {
            Object event = new NpcEvent.TargetEvent(this.wrappedNPC, (LivingEntity)entity);
            if (EventHooks.onNPCTarget(this, event)) {
                return;
            }
            entity = ((NpcEvent.TargetEvent)((Object)event)).entity == null ? null : ((NpcEvent.TargetEvent)((Object)event)).entity.getMCEntity();
        } else {
            for (PrioritizedGoal en : this.field_70715_bh.field_220892_d) {
                en.func_75251_c();
            }
            if (EventHooks.onNPCTargetLost(this, this.func_70638_az())) {
                return;
            }
        }
        if (entity != null && entity != this && this.ais.onAttack != 3 && !this.isAttacking() && !this.isClientSide() && (line = this.advanced.getAttackLine()) != null) {
            this.saySurrounding(Line.formatTarget(line, entity));
        }
        super.func_70624_b(entity);
    }

    public void func_82196_d(LivingEntity entity, float f) {
        ItemStack proj = ItemStackWrapper.MCItem(this.inventory.getProjectile());
        if (proj == null) {
            this.updateAI = true;
            return;
        }
        NpcEvent.RangedLaunchedEvent event = new NpcEvent.RangedLaunchedEvent(this.wrappedNPC, entity, this.stats.ranged.getStrength());
        for (int i = 0; i < this.stats.ranged.getShotCount(); ++i) {
            EntityProjectile projectile = this.shoot(entity, this.stats.ranged.getAccuracy(), proj, f == 1.0f);
            projectile.damage = event.damage;
            projectile.callback = (projectile1, pos, entity1) -> {
                Entity e;
                if (proj.func_77973_b() == CustomItems.soulstoneFull && (e = ItemSoulstoneFilled.Spawn(null, proj, this.field_70170_p, pos)) instanceof LivingEntity && entity1 instanceof LivingEntity) {
                    if (e instanceof MobEntity) {
                        ((MobEntity)e).func_70624_b((LivingEntity)entity1);
                    } else {
                        ((LivingEntity)e).func_70604_c((LivingEntity)entity1);
                    }
                }
                projectile1.func_184185_a(this.stats.ranged.getSoundEvent(entity1 != null ? 1 : 2), 1.0f, 1.2f / (this.func_70681_au().nextFloat() * 0.2f + 0.9f));
                return false;
            };
            this.func_184185_a(this.stats.ranged.getSoundEvent(0), 2.0f, 1.0f);
            event.projectiles.add((IProjectile)NpcAPI.Instance().getIEntity((Entity)projectile));
        }
        EventHooks.onNPCRangedLaunched(this, event);
    }

    public EntityProjectile shoot(LivingEntity entity, int accuracy, ItemStack proj, boolean indirect) {
        return this.shoot(entity.func_226277_ct_(), entity.func_174813_aQ().field_72338_b + (double)(entity.func_213302_cg() / 2.0f), entity.func_226281_cx_(), accuracy, proj, indirect);
    }

    public EntityProjectile shoot(double x, double y, double z, int accuracy, ItemStack proj, boolean indirect) {
        EntityProjectile projectile = new EntityProjectile(this.field_70170_p, (LivingEntity)this, proj.func_77946_l(), true);
        double varX = x - this.func_226277_ct_();
        double varY = y - (this.func_226278_cu_() + (double)this.func_70047_e());
        double varZ = z - this.func_226281_cx_();
        float varF = projectile.hasGravity() ? MathHelper.func_76133_a((double)(varX * varX + varZ * varZ)) : 0.0f;
        float angle = projectile.getAngleForXYZ(varX, varY, varZ, varF, indirect);
        float acc = 20.0f - (float)MathHelper.func_76141_d((float)((float)accuracy / 5.0f));
        projectile.func_70186_c(varX, varY, varZ, angle, acc);
        this.field_70170_p.func_217376_c((Entity)projectile);
        return projectile;
    }

    private void clearTasks(GoalSelector tasks) {
        ArrayList list = new ArrayList(tasks.field_220892_d);
        for (PrioritizedGoal entityaitaskentry : list) {
            tasks.func_85156_a((Goal)entityaitaskentry);
        }
        tasks.field_220892_d.clear();
        tasks.field_220891_c.clear();
        tasks.field_220893_f.clear();
    }

    private void updateTasks() {
        if (this.field_70170_p == null || this.field_70170_p.field_72995_K || !(this.field_70170_p instanceof ServerWorld)) {
            return;
        }
        ServerWorld sWorld = (ServerWorld)this.field_70170_p;
        this.clearTasks(this.field_70714_bg);
        this.clearTasks(this.field_70715_bh);
        if (this.isKilled()) {
            return;
        }
        NPCAttackSelector attackEntitySelector = new NPCAttackSelector(this);
        this.field_70715_bh.func_75776_a(0, (Goal)new EntityAIClearTarget(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, LivingEntity.class, 4, this.ais.directLOS, false, (Predicate)((Object)attackEntitySelector)));
        this.field_70715_bh.func_75776_a(3, (Goal)new EntityAIOwnerHurtByTarget(this));
        this.field_70715_bh.func_75776_a(4, (Goal)new EntityAIOwnerHurtTarget(this));
        sWorld.field_217495_I.remove(this.func_70661_as());
        if (this.ais.movementType == 1) {
            this.field_70765_h = new FlyingMoveHelper(this);
            this.field_70699_by = new FlyingPathNavigator((MobEntity)this, this.field_70170_p);
        } else if (this.ais.movementType == 2) {
            this.field_70765_h = new FlyingMoveHelper(this);
            this.field_70699_by = new SwimmerPathNavigator((MobEntity)this, this.field_70170_p);
        } else {
            this.field_70765_h = new MovementController((MobEntity)this);
            this.field_70699_by = new GroundPathNavigator((MobEntity)this, this.field_70170_p);
            this.field_70714_bg.func_75776_a(0, (Goal)new EntityAIWaterNav(this));
        }
        sWorld.field_217495_I.add(this.func_70661_as());
        this.taskCount = 1;
        this.addRegularEntries();
        this.doorInteractType();
        this.seekShelter();
        this.setResponse();
        this.setMoveType();
    }

    private void setResponse() {
        this.aiRange = null;
        this.aiAttackTarget = null;
        if (this.ais.canSprint) {
            this.field_70714_bg.func_75776_a(this.taskCount++, (Goal)new EntityAISprintToTarget(this));
        }
        if (this.ais.onAttack == 1) {
            this.field_70714_bg.func_75776_a(this.taskCount++, (Goal)new EntityAIPanic(this, 1.2f));
        } else if (this.ais.onAttack == 2) {
            this.field_70714_bg.func_75776_a(this.taskCount++, (Goal)new EntityAIAvoidTarget(this));
        } else if (this.ais.onAttack == 0) {
            if (this.ais.canLeap) {
                this.field_70714_bg.func_75776_a(this.taskCount++, (Goal)new EntityAIPounceTarget(this));
            }
            this.aiAttackTarget = new EntityAIAttackTarget(this);
            this.field_70714_bg.func_75776_a(this.taskCount, this.aiAttackTarget);
            if (this.inventory.getProjectile() != null) {
                this.aiRange = new EntityAIRangedAttack(this);
                this.field_70714_bg.func_75776_a(this.taskCount++, (Goal)this.aiRange);
            }
        } else if (this.ais.onAttack == 3) {
            // empty if block
        }
    }

    public boolean canFly() {
        return false;
    }

    public void setMoveType() {
        if (this.ais.getMovingType() == 1) {
            this.field_70714_bg.func_75776_a(this.taskCount++, (Goal)new EntityAIWander(this));
        }
        if (this.ais.getMovingType() == 2) {
            this.field_70714_bg.func_75776_a(this.taskCount++, (Goal)new EntityAIMovingPath(this));
        }
    }

    public void doorInteractType() {
        if (this.canFly()) {
            return;
        }
        Object aiDoor = null;
        if (this.ais.doorInteract == 1) {
            aiDoor = new OpenDoorGoal((MobEntity)this, true);
            this.field_70714_bg.func_75776_a(this.taskCount++, (Goal)aiDoor);
        } else if (this.ais.doorInteract == 0) {
            aiDoor = new EntityAIBustDoor((MobEntity)this);
            this.field_70714_bg.func_75776_a(this.taskCount++, (Goal)aiDoor);
        }
        if (this.field_70699_by instanceof GroundPathNavigator) {
            ((GroundPathNavigator)this.field_70699_by).func_179688_b(aiDoor != null);
        }
    }

    public void seekShelter() {
        if (this.ais.findShelter == 0) {
            this.field_70714_bg.func_75776_a(this.taskCount++, (Goal)new EntityAIMoveIndoors(this));
        } else if (this.ais.findShelter == 1) {
            if (!this.canFly()) {
                this.field_70714_bg.func_75776_a(this.taskCount++, (Goal)new RestrictSunGoal((CreatureEntity)this));
            }
            this.field_70714_bg.func_75776_a(this.taskCount++, (Goal)new EntityAIFindShade(this));
        }
    }

    public void addRegularEntries() {
        this.field_70714_bg.func_75776_a(this.taskCount++, (Goal)new EntityAIReturn(this));
        this.field_70714_bg.func_75776_a(this.taskCount++, (Goal)new EntityAIFollow(this));
        if (this.ais.getStandingType() != 1 && this.ais.getStandingType() != 3) {
            this.field_70714_bg.func_75776_a(this.taskCount++, (Goal)new EntityAIWatchClosest(this, LivingEntity.class, 5.0f));
        }
        this.lookAi = new EntityAILook(this);
        this.field_70714_bg.func_75776_a(this.taskCount++, (Goal)this.lookAi);
        this.field_70714_bg.func_75776_a(this.taskCount++, (Goal)new EntityAIWorldLines(this));
        this.field_70714_bg.func_75776_a(this.taskCount++, (Goal)new EntityAIJob(this));
        this.field_70714_bg.func_75776_a(this.taskCount++, (Goal)new EntityAIRole(this));
        this.animateAi = new EntityAIAnimation(this);
        this.field_70714_bg.func_75776_a(this.taskCount++, (Goal)this.animateAi);
        if (this.transform.isValid()) {
            this.field_70714_bg.func_75776_a(this.taskCount++, (Goal)new EntityAITransform(this));
        }
    }

    public float func_70689_ay() {
        return (float)this.ais.getWalkingSpeed() / 20.0f;
    }

    public float func_180484_a(BlockPos pos) {
        if (this.ais.movementType == 2) {
            return this.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151586_h ? 10.0f : 0.0f;
        }
        float weight = (float)this.field_70170_p.func_217298_h(pos) - 0.5f;
        if (this.field_70170_p.func_180495_p(pos).func_200015_d((IBlockReader)this.field_70170_p, pos)) {
            weight += 10.0f;
        }
        return weight;
    }

    protected int func_70682_h(int par1) {
        if (!this.stats.canDrown) {
            return par1;
        }
        return super.func_70682_h(par1);
    }

    public CreatureAttribute func_70668_bt() {
        return this.stats == null ? null : this.stats.creatureType;
    }

    public int func_70627_aG() {
        return 160;
    }

    public void func_70642_aH() {
        if (!this.func_70089_S()) {
            return;
        }
        this.advanced.playSound(this.func_70638_az() != null ? 1 : 0, this.func_70599_aP(), this.func_70647_i());
    }

    protected void func_184581_c(DamageSource source) {
        this.advanced.playSound(2, this.func_70599_aP(), this.func_70647_i());
    }

    public SoundEvent func_184615_bR() {
        return null;
    }

    protected float func_70647_i() {
        if (this.advanced.disablePitch) {
            return 1.0f;
        }
        return super.func_70647_i();
    }

    protected void func_180429_a(BlockPos pos, BlockState state) {
        if (this.advanced.getSound(4) != null) {
            this.advanced.playSound(4, 0.15f, 1.0f);
        } else {
            super.func_180429_a(pos, state);
        }
    }

    public ServerPlayerEntity getFakeChatPlayer() {
        if (this.field_70170_p.field_72995_K) {
            return null;
        }
        EntityUtil.Copy((LivingEntity)this, (LivingEntity)ChatEventPlayer);
        EntityNPCInterface.ChatEventProfile.npc = this;
        ChatEventPlayer.func_70029_a(this.field_70170_p);
        ChatEventPlayer.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        return ChatEventPlayer;
    }

    public void saySurrounding(Line line) {
        if (line == null) {
            return;
        }
        if (line.getShowText() && !line.getText().isEmpty()) {
            ServerChatEvent event = new ServerChatEvent(this.getFakeChatPlayer(), line.getText(), (ITextComponent)new TranslationTextComponent(line.getText().replace("%", "%%")));
            if (CustomNpcs.NpcSpeachTriggersChatEvent && (MinecraftForge.EVENT_BUS.post((Event)event) || event.getComponent() == null)) {
                return;
            }
            line.setText(event.getComponent().getString().replace("%%", "%"));
        }
        List inRange = this.field_70170_p.func_217357_a(PlayerEntity.class, this.func_174813_aQ().func_72314_b(20.0, 20.0, 20.0));
        for (PlayerEntity player : inRange) {
            this.say(player, line);
        }
    }

    public void say(PlayerEntity player, Line line) {
        if (line == null || !this.canNpcSee((Entity)player)) {
            return;
        }
        if (!line.getSound().isEmpty()) {
            BlockPos pos = this.func_233580_cy_();
            Packets.send((ServerPlayerEntity)player, new PacketPlaySound(line.getSound(), pos, this.func_70599_aP(), this.func_70647_i()));
        }
        if (!line.getText().isEmpty()) {
            Packets.send((ServerPlayerEntity)player, new PacketChatBubble(this.func_145782_y(), line.getText(), line.getShowText()));
        }
    }

    public boolean func_94059_bO() {
        return true;
    }

    public void func_70024_g(double d, double d1, double d2) {
        if (this.isWalking() && !this.isKilled()) {
            super.func_70024_g(d, d1, d2);
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.npcVersion = compound.func_74762_e("ModRev");
        VersionCompatibility.CheckNpcCompatibility(this, compound);
        this.display.readToNBT(compound);
        this.stats.readToNBT(compound);
        this.ais.readToNBT(compound);
        this.script.load(compound);
        this.timers.load(compound);
        this.advanced.readToNBT(compound);
        this.role.load(compound);
        this.job.load(compound);
        this.inventory.load(compound);
        this.transform.readToNBT(compound);
        this.killedtime = compound.func_74763_f("KilledTime");
        this.totalTicksAlive = compound.func_74763_f("TotalTicksAlive");
        this.linkedName = compound.func_74779_i("LinkedNpcName");
        if (!this.isClientSide()) {
            LinkedNpcController.Instance.loadNpcData(this);
        }
        this.func_110148_a(Attributes.field_233819_b_).func_111128_a((double)CustomNpcs.NpcNavRange);
        this.updateAI = true;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        this.display.save(compound);
        this.stats.save(compound);
        this.ais.save(compound);
        this.script.save(compound);
        this.timers.save(compound);
        this.advanced.save(compound);
        this.role.save(compound);
        this.job.save(compound);
        this.inventory.save(compound);
        this.transform.save(compound);
        compound.func_74772_a("KilledTime", this.killedtime);
        compound.func_74772_a("TotalTicksAlive", this.totalTicksAlive);
        compound.func_74768_a("ModRev", this.npcVersion);
        compound.func_74778_a("LinkedNpcName", this.linkedName);
    }

    public EntitySize func_213305_a(Pose poseIn) {
        EntitySize size = this.baseSize;
        if (this.currentAnimation == 2 || this.currentAnimation == 7 || this.field_70725_aQ > 0) {
            size = sizeSleep;
        } else if (this.func_184218_aH() || this.currentAnimation == 1) {
            size = this.baseSize.func_220312_a(1.0f, 0.77f);
        }
        size = size.func_220313_a((float)this.display.getSize() * 0.2f);
        if (this.display.getHitboxState() == 1 || this.isKilled() && this.stats.hideKilledBody) {
            size = EntitySize.func_220314_b((float)1.0E-5f, (float)size.field_220316_b);
        }
        if ((double)(size.field_220315_a / 2.0f) > this.field_70170_p.getMaxEntityRadius()) {
            this.field_70170_p.increaseMaxEntityRadius((double)(size.field_220315_a / 2.0f));
        }
        return size;
    }

    public void func_70609_aI() {
        if (this.stats.spawnCycle == 3 || this.stats.spawnCycle == 4) {
            super.func_70609_aI();
            return;
        }
        ++this.field_70725_aQ;
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (!this.hasDied) {
            this.func_70106_y();
        }
        if (this.killedtime < System.currentTimeMillis() && (this.stats.spawnCycle == 0 || this.field_70170_p.func_72935_r() && this.stats.spawnCycle == 1 || !this.field_70170_p.func_72935_r() && this.stats.spawnCycle == 2)) {
            this.reset();
        }
    }

    public void reset() {
        this.hasDied = false;
        this.field_70128_L = false;
        this.field_70729_aU = false;
        this.revive();
        this.wasKilled = false;
        this.func_70031_b(false);
        this.func_70606_j(this.func_110138_aP());
        this.field_70180_af.func_187227_b(Animation, (Object)0);
        this.field_70180_af.func_187227_b(Walking, (Object)false);
        this.field_70180_af.func_187227_b(IsDead, (Object)false);
        this.field_70180_af.func_187227_b(Interacting, (Object)false);
        this.interactingEntities.clear();
        this.combatHandler.reset();
        this.func_70624_b(null);
        this.func_70604_c(null);
        this.field_70725_aQ = 0;
        if (this.ais.returnToStart && !this.hasOwner() && !this.isClientSide() && !this.func_184218_aH()) {
            this.func_70012_b(this.getStartXPos(), this.getStartYPos(), this.getStartZPos(), this.field_70177_z, this.field_70125_A);
        }
        this.killedtime = 0L;
        this.func_70066_B();
        this.func_195061_cb();
        this.func_213352_e(Vector3d.field_186680_a);
        this.field_70140_Q = 0.0f;
        this.field_70141_P = 0.0f;
        this.func_70661_as().func_75499_g();
        this.currentAnimation = 0;
        this.func_213323_x_();
        this.updateAI = true;
        this.ais.movingPos = 0;
        if (this.getOwner() != null) {
            this.getOwner().func_130011_c(null);
        }
        this.bossInfo.func_186758_d(this.display.getBossbar() == 1);
        this.job.reset();
        EventHooks.onNPCInit(this);
    }

    public void onCollide() {
        if (!this.func_70089_S() || this.field_70173_aa % 4 != 0 || this.field_70170_p.field_72995_K) {
            return;
        }
        AxisAlignedBB axisalignedbb = null;
        axisalignedbb = this.func_184187_bx() != null && this.func_184187_bx().func_70089_S() ? this.func_174813_aQ().func_111270_a(this.func_184187_bx().func_174813_aQ()).func_72314_b(1.0, 0.0, 1.0) : this.func_174813_aQ().func_72314_b(1.0, 0.5, 1.0);
        List list = this.field_70170_p.func_217357_a(LivingEntity.class, axisalignedbb);
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (entity == this || !entity.func_70089_S()) continue;
            EventHooks.onNPCCollide(this, entity);
        }
    }

    public void func_181015_d(BlockPos pos) {
    }

    public void cloakUpdate() {
        this.prevChasingPosX = this.chasingPosX;
        this.prevChasingPosY = this.chasingPosY;
        this.prevChasingPosZ = this.chasingPosZ;
        double d0 = this.func_226277_ct_() - this.chasingPosX;
        double d1 = this.func_226278_cu_() - this.chasingPosY;
        double d2 = this.func_226281_cx_() - this.chasingPosZ;
        double d3 = 10.0;
        if (d0 > 10.0) {
            this.prevChasingPosX = this.chasingPosX = this.func_226277_ct_();
        }
        if (d2 > 10.0) {
            this.prevChasingPosZ = this.chasingPosZ = this.func_226281_cx_();
        }
        if (d1 > 10.0) {
            this.prevChasingPosY = this.chasingPosY = this.func_226278_cu_();
        }
        if (d0 < -10.0) {
            this.prevChasingPosX = this.chasingPosX = this.func_226277_ct_();
        }
        if (d2 < -10.0) {
            this.prevChasingPosZ = this.chasingPosZ = this.func_226281_cx_();
        }
        if (d1 < -10.0) {
            this.prevChasingPosY = this.chasingPosY = this.func_226278_cu_();
        }
        this.chasingPosX += d0 * 0.25;
        this.chasingPosZ += d2 * 0.25;
        this.chasingPosY += d1 * 0.25;
    }

    public boolean func_213397_c(double distanceToPlayer) {
        return this.stats != null && this.stats.spawnCycle == 4;
    }

    public ItemStack func_184614_ca() {
        IItemStack item = null;
        item = this.isAttacking() ? this.inventory.getRightHand() : (this.role.getType() == 6 ? ((RoleCompanion)this.role).getItemInHand() : (this.job.overrideMainHand ? this.job.getMainhand() : this.inventory.getRightHand()));
        return ItemStackWrapper.MCItem(item);
    }

    public ItemStack func_184592_cb() {
        IItemStack item = null;
        item = this.isAttacking() ? this.inventory.getLeftHand() : (this.job.overrideOffHand ? this.job.getOffhand() : this.inventory.getLeftHand());
        return ItemStackWrapper.MCItem(item);
    }

    public ItemStack func_184582_a(EquipmentSlotType slot) {
        if (slot == EquipmentSlotType.MAINHAND) {
            return this.func_184614_ca();
        }
        if (slot == EquipmentSlotType.OFFHAND) {
            return this.func_184592_cb();
        }
        return ItemStackWrapper.MCItem(this.inventory.getArmor(3 - slot.func_188454_b()));
    }

    public void func_184201_a(EquipmentSlotType slot, ItemStack item) {
        if (slot == EquipmentSlotType.MAINHAND) {
            this.inventory.weapons.put(0, NpcAPI.Instance().getIItemStack(item));
        } else if (slot == EquipmentSlotType.OFFHAND) {
            this.inventory.weapons.put(2, NpcAPI.Instance().getIItemStack(item));
        } else {
            this.inventory.armor.put(3 - slot.func_188454_b(), NpcAPI.Instance().getIItemStack(item));
        }
    }

    public Iterable<ItemStack> func_184193_aE() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < 4; ++i) {
            list.add(ItemStackWrapper.MCItem(this.inventory.armor.get(3 - i)));
        }
        return list;
    }

    public Iterable<ItemStack> func_184209_aF() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(ItemStackWrapper.MCItem(this.inventory.weapons.get(0)));
        list.add(ItemStackWrapper.MCItem(this.inventory.weapons.get(2)));
        return list;
    }

    protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
    }

    protected void func_213354_a(DamageSource damageSourceIn, boolean attackedRecently) {
    }

    public void func_70645_a(DamageSource damagesource) {
        this.func_70031_b(false);
        this.func_70661_as().func_75499_g();
        this.func_70066_B();
        this.func_195061_cb();
        if (!this.isClientSide()) {
            this.advanced.playSound(3, this.func_70599_aP(), this.func_70647_i());
            Entity attackingEntity = NoppesUtilServer.GetDamageSourcee(damagesource);
            NpcEvent.DiedEvent event = new NpcEvent.DiedEvent(this.wrappedNPC, damagesource, attackingEntity);
            event.droppedItems = this.inventory.getItemsRNG();
            event.expDropped = this.inventory.getExpRNG();
            event.line = this.advanced.getKilledLine();
            EventHooks.onNPCDied(this, event);
            this.bossInfo.func_186758_d(false);
            this.inventory.dropStuff(event, attackingEntity, damagesource);
            if (event.line != null) {
                this.saySurrounding(Line.formatTarget((Line)event.line, attackingEntity instanceof LivingEntity ? (LivingEntity)attackingEntity : null));
            }
        }
        super.func_70645_a(damagesource);
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public void func_70106_y() {
        this.hasDied = true;
        this.func_184226_ay();
        this.func_184210_p();
        if (this.field_70170_p.field_72995_K || this.stats.spawnCycle == 3 || this.stats.spawnCycle == 4) {
            this.delete();
        } else {
            this.func_70606_j(-1.0f);
            this.func_70031_b(false);
            this.func_70661_as().func_75499_g();
            this.setCurrentAnimation(2);
            this.func_213323_x_();
            if (this.killedtime <= 0L) {
                this.killedtime = (long)(this.stats.respawnTime * 1000) + System.currentTimeMillis();
            }
            this.role.killed();
            this.job.killed();
        }
    }

    public void delete() {
        this.role.delete();
        this.job.delete();
        super.func_70106_y();
    }

    public float getStartXPos() {
        return (float)this.ais.startPos().func_177958_n() + this.ais.bodyOffsetX / 10.0f;
    }

    public float getStartZPos() {
        return (float)this.ais.startPos().func_177952_p() + this.ais.bodyOffsetZ / 10.0f;
    }

    public boolean isVeryNearAssignedPlace() {
        double xx = this.func_226277_ct_() - (double)this.getStartXPos();
        double zz = this.func_226281_cx_() - (double)this.getStartZPos();
        if (xx < -0.2 || xx > 0.2) {
            return false;
        }
        return !(zz < -0.2) && !(zz > 0.2);
    }

    public double getStartYPos() {
        if (this.startYPos < 0.0) {
            return this.calculateStartYPos(this.ais.startPos());
        }
        return this.startYPos;
    }

    private double calculateStartYPos(BlockPos pos) {
        BlockPos startPos = this.ais.startPos();
        while (pos.func_177956_o() > 0) {
            BlockState state = this.field_70170_p.func_180495_p(pos);
            VoxelShape shape = state.func_196954_c((IBlockReader)this.field_70170_p, pos);
            if (shape.func_197766_b()) {
                pos = pos.func_177977_b();
                continue;
            }
            AxisAlignedBB bb = shape.func_197752_a().func_186670_a(pos);
            if (this.ais.movementType == 2 && startPos.func_177956_o() <= pos.func_177956_o() && state.func_185904_a() == Material.field_151586_h) {
                pos = pos.func_177977_b();
                continue;
            }
            return bb.field_72337_e;
        }
        return 0.0;
    }

    private BlockPos calculateTopPos(BlockPos pos) {
        BlockPos check = pos;
        while (check.func_177956_o() > 0) {
            AxisAlignedBB bb;
            BlockState state = this.field_70170_p.func_180495_p(pos);
            VoxelShape shape = state.func_196954_c((IBlockReader)this.field_70170_p, pos);
            if (!shape.func_197766_b() && (bb = shape.func_197752_a().func_186670_a(pos)) != null) {
                return check;
            }
            check = check.func_177977_b();
        }
        return pos;
    }

    public boolean isInRange(Entity entity, double range) {
        return this.isInRange(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), range);
    }

    public boolean isInRange(double posX, double posY, double posZ, double range) {
        double y = Math.abs(this.func_226278_cu_() - posY);
        if (posY >= 0.0 && y > range) {
            return false;
        }
        double x = Math.abs(this.func_226277_ct_() - posX);
        double z = Math.abs(this.func_226281_cx_() - posZ);
        return x <= range && z <= range;
    }

    public void givePlayerItem(PlayerEntity player, ItemStack item) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        item = item.func_77946_l();
        float f = 0.7f;
        double d = (double)(this.field_70170_p.field_73012_v.nextFloat() * f) + (double)(1.0f - f);
        double d1 = (double)(this.field_70170_p.field_73012_v.nextFloat() * f) + (double)(1.0f - f);
        double d2 = (double)(this.field_70170_p.field_73012_v.nextFloat() * f) + (double)(1.0f - f);
        ItemEntity entityitem = new ItemEntity(this.field_70170_p, this.func_226277_ct_() + d, this.func_226278_cu_() + d1, this.func_226281_cx_() + d2, item);
        entityitem.func_174867_a(2);
        this.field_70170_p.func_217376_c((Entity)entityitem);
        int i = item.func_190916_E();
        if (player.field_71071_by.func_70441_a(item)) {
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            player.func_71001_a((Entity)entityitem, i);
            if (item.func_190916_E() <= 0) {
                entityitem.func_70106_y();
            }
        }
    }

    public boolean func_70608_bn() {
        return this.currentAnimation == 2 && !this.isAttacking();
    }

    public boolean isWalking() {
        return this.ais.getMovingType() != 0 || this.isAttacking() || this.isFollower() || (Boolean)this.field_70180_af.func_187225_a(Walking) != false;
    }

    public boolean func_213453_ef() {
        return this.currentAnimation == 4;
    }

    public void func_233627_a_(float strength, double ratioX, double ratioZ) {
        super.func_233627_a_(strength * (2.0f - this.stats.resistances.knockback), ratioX, ratioZ);
    }

    public Faction getFaction() {
        Faction fac = FactionController.instance.getFaction((Integer)this.field_70180_af.func_187225_a(FactionData));
        if (fac == null) {
            return FactionController.instance.getFaction(FactionController.instance.getFirstFactionId());
        }
        return fac;
    }

    public boolean isClientSide() {
        return this.field_70170_p == null || this.field_70170_p.field_72995_K;
    }

    public void setFaction(int id) {
        if (id < 0 || this.isClientSide()) {
            return;
        }
        this.field_70180_af.func_187227_b(FactionData, (Object)id);
    }

    public boolean func_70687_e(EffectInstance effect) {
        if (this.stats.potionImmune) {
            return false;
        }
        if (this.func_70668_bt() == CreatureAttribute.field_223224_c_ && effect.func_188419_a() == Effects.field_76436_u) {
            return false;
        }
        return super.func_70687_e(effect);
    }

    public boolean isAttacking() {
        return (Boolean)this.field_70180_af.func_187225_a(Attacking);
    }

    public boolean isKilled() {
        return this.field_70128_L || (Boolean)this.field_70180_af.func_187225_a(IsDead) != false;
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.func_150786_a(this.writeSpawnData());
    }

    public CompoundNBT writeSpawnData() {
        CompoundNBT bard;
        CompoundNBT compound = new CompoundNBT();
        this.display.save(compound);
        compound.func_74768_a("MaxHealth", this.stats.maxHealth);
        compound.func_218657_a("Armor", (INBT)NBTTags.nbtIItemStackMap(this.inventory.armor));
        compound.func_218657_a("Weapons", (INBT)NBTTags.nbtIItemStackMap(this.inventory.weapons));
        compound.func_74768_a("Speed", this.ais.getWalkingSpeed());
        compound.func_74757_a("DeadBody", this.stats.hideKilledBody);
        compound.func_74768_a("StandingState", this.ais.getStandingType());
        compound.func_74768_a("MovingState", this.ais.getMovingType());
        compound.func_74768_a("Orientation", this.ais.orientation);
        compound.func_74776_a("PositionXOffset", this.ais.bodyOffsetX);
        compound.func_74776_a("PositionYOffset", this.ais.bodyOffsetY);
        compound.func_74776_a("PositionZOffset", this.ais.bodyOffsetZ);
        compound.func_74768_a("Role", this.role.getType());
        compound.func_74768_a("Job", this.job.getType());
        if (this.job.getType() == 1) {
            bard = new CompoundNBT();
            this.job.save(bard);
            compound.func_218657_a("Bard", (INBT)bard);
        }
        if (this.job.getType() == 9) {
            bard = new CompoundNBT();
            this.job.save(bard);
            compound.func_218657_a("Puppet", (INBT)bard);
        }
        if (this.role.getType() == 6) {
            bard = new CompoundNBT();
            this.role.save(bard);
            compound.func_218657_a("Companion", (INBT)bard);
        }
        if (this instanceof EntityCustomNpc) {
            compound.func_218657_a("ModelData", (INBT)((EntityCustomNpc)this).modelData.save());
        }
        return compound;
    }

    public void readSpawnData(PacketBuffer buf) {
        this.readSpawnData(buf.func_150793_b());
    }

    public void readSpawnData(CompoundNBT compound) {
        CompoundNBT puppet;
        this.stats.setMaxHealth(compound.func_74762_e("MaxHealth"));
        this.ais.setWalkingSpeed(compound.func_74762_e("Speed"));
        this.stats.hideKilledBody = compound.func_74767_n("DeadBody");
        this.ais.setStandingType(compound.func_74762_e("StandingState"));
        this.ais.setMovingType(compound.func_74762_e("MovingState"));
        this.ais.orientation = compound.func_74762_e("Orientation");
        this.ais.bodyOffsetX = compound.func_74760_g("PositionXOffset");
        this.ais.bodyOffsetY = compound.func_74760_g("PositionYOffset");
        this.ais.bodyOffsetZ = compound.func_74760_g("PositionZOffset");
        this.inventory.armor = NBTTags.getIItemStackMap(compound.func_150295_c("Armor", 10));
        this.inventory.weapons = NBTTags.getIItemStackMap(compound.func_150295_c("Weapons", 10));
        this.advanced.setRole(compound.func_74762_e("Role"));
        this.advanced.setJob(compound.func_74762_e("Job"));
        if (this.job.getType() == 1) {
            CompoundNBT bard = compound.func_74775_l("Bard");
            this.job.load(bard);
        }
        if (this.job.getType() == 9) {
            puppet = compound.func_74775_l("Puppet");
            this.job.load(puppet);
        }
        if (this.role.getType() == 6) {
            puppet = compound.func_74775_l("Companion");
            this.role.load(puppet);
        }
        if (this instanceof EntityCustomNpc) {
            ((EntityCustomNpc)this).modelData.load(compound.func_74775_l("ModelData"));
        }
        this.display.readToNBT(compound);
        this.func_213323_x_();
    }

    public CommandSource func_195051_bN() {
        if (this.field_70170_p.field_72995_K) {
            return super.func_195051_bN();
        }
        EntityUtil.Copy((LivingEntity)this, (LivingEntity)CommandPlayer);
        CommandPlayer.func_70029_a(this.field_70170_p);
        CommandPlayer.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        return new CommandSource((ICommandSource)this, this.func_213303_ch(), this.func_189653_aC(), this.field_70170_p instanceof ServerWorld ? (ServerWorld)this.field_70170_p : null, this.func_184840_I(), this.func_200200_C_().getString(), this.func_145748_c_(), this.field_70170_p.func_73046_m(), (Entity)this);
    }

    public ITextComponent func_200200_C_() {
        return new TranslationTextComponent(this.display.getName());
    }

    public void setImmuneToFire(boolean immuneToFire) {
        this.stats.immuneToFire = immuneToFire;
    }

    public boolean func_230279_az_() {
        return this.stats.immuneToFire;
    }

    public boolean func_225503_b_(float distance, float modifier) {
        if (!this.stats.noFallDamage) {
            return super.func_225503_b_(distance, modifier);
        }
        return false;
    }

    public void func_213295_a(BlockState state, Vector3d motionMultiplierIn) {
        if (state != null && !state.func_203425_a(Blocks.field_196553_aF) || !this.stats.ignoreCobweb) {
            super.func_213295_a(state, motionMultiplierIn);
        }
    }

    public boolean func_241845_aY() {
        return !this.isKilled() && this.display.getHitboxState() == 2;
    }

    protected void func_85033_bc() {
        if (this.display.getHitboxState() != 0) {
            return;
        }
        super.func_85033_bc();
    }

    public boolean func_70104_M() {
        return this.isWalking() && !this.isKilled();
    }

    public PushReaction func_184192_z() {
        return this.display.getHitboxState() == 0 ? super.func_184192_z() : PushReaction.IGNORE;
    }

    public EntityAIRangedAttack getRangedTask() {
        return this.aiRange;
    }

    public String getRoleData() {
        return (String)this.field_70180_af.func_187225_a(RoleData);
    }

    public void setRoleData(String s) {
        this.field_70180_af.func_187227_b(RoleData, (Object)s);
    }

    public String getJobData() {
        return (String)this.field_70180_af.func_187225_a(RoleData);
    }

    public void setJobData(String s) {
        this.field_70180_af.func_187227_b(RoleData, (Object)s);
    }

    public World func_130014_f_() {
        return this.field_70170_p;
    }

    public boolean func_98034_c(PlayerEntity player) {
        return this.display.getVisible() == 1 && player.func_184614_ca().func_77973_b() != CustomItems.wand && !this.display.availability.hasOptions();
    }

    public boolean func_82150_aj() {
        return this.display.getVisible() != 0 && !this.display.availability.hasOptions();
    }

    public void setInvisible(ServerPlayerEntity playerMP) {
        if (this.tracking.contains(playerMP.func_145782_y())) {
            this.tracking.remove(playerMP.func_145782_y());
            Packets.send(playerMP, new PacketNpcVisibleFalse(this.func_145782_y()));
        }
    }

    public void setVisible(ServerPlayerEntity playerMP) {
        if (!this.tracking.contains(playerMP.func_145782_y())) {
            this.tracking.add(playerMP.func_145782_y());
            Packets.send(playerMP, new PacketNpcVisibleTrue((Entity)this));
        }
        Packets.send(playerMP, new PacketNpcUpdate(this.func_145782_y(), this.writeSpawnData()));
    }

    public void func_145747_a(ITextComponent var1, UUID sender) {
    }

    public void setCurrentAnimation(int animation) {
        this.currentAnimation = animation;
        this.field_70180_af.func_187227_b(Animation, (Object)animation);
    }

    public boolean canNpcSee(Entity entity) {
        return this.func_70635_at().func_75522_a(entity);
    }

    public boolean isFollower() {
        if (this.advanced.scenes.getOwner() != null) {
            return true;
        }
        return this.role.isFollowing() || this.job.isFollowing();
    }

    public LivingEntity getOwner() {
        if (this.advanced.scenes.getOwner() != null) {
            return this.advanced.scenes.getOwner();
        }
        if (this.role.getType() == 2 && this.role instanceof RoleFollower) {
            return ((RoleFollower)this.role).owner;
        }
        if (this.role.getType() == 6 && this.role instanceof RoleCompanion) {
            return ((RoleCompanion)this.role).owner;
        }
        if (this.job.getType() == 5 && this.job instanceof JobFollower) {
            return ((JobFollower)this.job).following;
        }
        return null;
    }

    public boolean hasOwner() {
        if (this.advanced.scenes.getOwner() != null) {
            return true;
        }
        return this.role.getType() == 2 && ((RoleFollower)this.role).hasOwner() || this.role.getType() == 6 && ((RoleCompanion)this.role).hasOwner() || this.job.getType() == 5 && ((JobFollower)this.job).hasOwner();
    }

    public int followRange() {
        if (this.advanced.scenes.getOwner() != null) {
            return 4;
        }
        if (this.role.getType() == 2 && this.role.isFollowing()) {
            return 6;
        }
        if (this.role.getType() == 6 && this.role.isFollowing()) {
            return 4;
        }
        if (this.job.getType() == 5 && this.job.isFollowing()) {
            return 4;
        }
        return 15;
    }

    public void func_213390_a(BlockPos pos, int range) {
        super.func_213390_a(pos, range);
        this.ais.setStartPos(pos);
    }

    protected float func_70655_b(DamageSource source, float damage) {
        if (this.role.getType() == 6) {
            damage = ((RoleCompanion)this.role).getDamageAfterArmorAbsorb(source, damage);
        }
        return damage;
    }

    public boolean func_184191_r(Entity entity) {
        if (!this.isClientSide()) {
            if (entity instanceof PlayerEntity && this.getFaction().isFriendlyToPlayer((PlayerEntity)entity)) {
                return true;
            }
            if (entity == this.getOwner()) {
                return true;
            }
            if (entity instanceof EntityNPCInterface && ((EntityNPCInterface)entity).faction.id == this.faction.id) {
                return true;
            }
        }
        return super.func_184191_r(entity);
    }

    public void setDataWatcher(EntityDataManager entityData) {
        this.field_70180_af.func_187218_a(entityData.func_187231_c());
    }

    public void func_213352_e(Vector3d travelVector) {
        BlockPos pos = this.func_233580_cy_();
        super.func_213352_e(travelVector);
        if (this.role.getType() == 6 && !this.isClientSide()) {
            BlockPos delta = this.func_233580_cy_().func_177973_b((Vector3i)pos);
            ((RoleCompanion)this.role).addMovementStat(delta.func_177958_n(), delta.func_177956_o(), delta.func_177952_p());
        }
    }

    public boolean func_184652_a(PlayerEntity player) {
        return false;
    }

    public boolean func_110167_bD() {
        return false;
    }

    public boolean nearPosition(BlockPos pos) {
        BlockPos npcpos = this.func_233580_cy_();
        float x = npcpos.func_177958_n() - pos.func_177958_n();
        float z = npcpos.func_177952_p() - pos.func_177952_p();
        float y = npcpos.func_177956_o() - pos.func_177956_o();
        float height = MathHelper.func_76123_f((float)(this.func_213302_cg() + 1.0f)) * MathHelper.func_76123_f((float)(this.func_213302_cg() + 1.0f));
        return (double)(x * x + z * z) < 2.5 && (double)(y * y) < (double)height + 2.5;
    }

    public void tpTo(LivingEntity owner) {
        if (owner == null) {
            return;
        }
        Direction facing = owner.func_174811_aO().func_176734_d();
        BlockPos pos = new BlockPos(owner.func_226277_ct_(), owner.func_174813_aQ().field_72338_b, owner.func_226281_cx_());
        pos = pos.func_177982_a(facing.func_82601_c(), 0, facing.func_82599_e());
        pos = this.calculateTopPos(pos);
        block0: for (int i = -1; i < 2; ++i) {
            for (int j = 0; j < 3; ++j) {
                BlockPos check = facing.func_82601_c() == 0 ? pos.func_177982_a(i, 0, j * facing.func_82599_e()) : pos.func_177982_a(j * facing.func_82601_c(), 0, i);
                if (this.field_70170_p.func_180495_p(check = this.calculateTopPos(check)).func_200015_d((IBlockReader)this.field_70170_p, check) || this.field_70170_p.func_180495_p(check.func_177984_a()).func_200015_d((IBlockReader)this.field_70170_p, check.func_177984_a())) continue;
                this.func_70012_b((float)check.func_177958_n() + 0.5f, check.func_177956_o(), (float)check.func_177952_p() + 0.5f, this.field_70177_z, this.field_70125_A);
                this.func_70661_as().func_75499_g();
                continue block0;
            }
        }
    }

    public boolean canBeRiddenInWater(Entity rider) {
        return false;
    }

    public void func_184206_a(DataParameter<?> para) {
        super.func_184206_a(para);
        if (Animation.equals(para)) {
            this.func_213323_x_();
        }
    }

    static {
        sizeSleep = new EntitySize(0.8f, 0.4f, false);
    }
}

