/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.packets.server;

import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.ITeleporter;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomTeleporter;
import noppes.npcs.packets.PacketServerBasic;

public class SPacketDimensionTeleport
extends PacketServerBasic {
    private ResourceLocation id;

    public SPacketDimensionTeleport(ResourceLocation id) {
        this.id = id;
    }

    @Override
    public boolean toolAllowed(ItemStack item) {
        return item.func_77973_b() == CustomItems.teleporter;
    }

    public static void encode(SPacketDimensionTeleport msg, PacketBuffer buf) {
        buf.func_192572_a(msg.id);
    }

    public static SPacketDimensionTeleport decode(PacketBuffer buf) {
        return new SPacketDimensionTeleport(buf.func_192575_l());
    }

    @Override
    protected void handle() {
        RegistryKey dimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)this.id);
        ServerWorld level = this.player.func_184102_h().func_71218_a(dimension);
        BlockPos coords = level.func_241135_u_();
        if (coords == null) {
            coords = level.func_241135_u_();
            if (!level.func_175623_d(coords)) {
                coords = level.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, coords);
            } else {
                while (level.func_175623_d(coords) && coords.func_177956_o() > 0) {
                    coords = coords.func_177977_b();
                }
                if (coords.func_177956_o() == 0) {
                    coords = level.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, coords);
                }
            }
        }
        SPacketDimensionTeleport.teleportPlayer(this.player, coords.func_177958_n(), coords.func_177956_o(), coords.func_177952_p(), (RegistryKey<World>)dimension);
    }

    public static void teleportPlayer(ServerPlayerEntity player, double x, double y, double z, RegistryKey<World> dimension) {
        if (player.field_70170_p.field_73011_w != dimension) {
            MinecraftServer server = player.func_184102_h();
            ServerWorld wor = server.func_71218_a(dimension);
            if (wor == null) {
                player.func_145747_a((ITextComponent)new StringTextComponent("Broken transporter. Dimenion does not exist"), Util.field_240973_b_);
                return;
            }
            player.func_70012_b(x, y, z, player.field_70177_z, player.field_70125_A);
            player.changeDimension(wor, (ITeleporter)new CustomTeleporter(wor, new Vector3d(x, y, z), player.field_70177_z, player.field_70125_A));
        } else {
            player.field_71135_a.func_147364_a(x, y, z, player.field_70177_z, player.field_70125_A);
        }
    }
}

