/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.schematics;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.Property;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import noppes.npcs.schematics.ISchematic;

public class Schematic
implements ISchematic {
    private static final HashMap<String, BlockState> staticBlockIds = new HashMap();
    public String name;
    public short width;
    public short height;
    public short length;
    private ListNBT entityList;
    public ListNBT tileList;
    public short[] blockArray;
    public byte[] blockDataArray;
    public HashMap<String, BlockState> blockIds = staticBlockIds;

    private static <T extends Comparable<T>> BlockState setValue(BlockState state, Property<T> prop, String val) {
        Optional optional = prop.func_185929_b(val);
        if (optional.isPresent()) {
            return (BlockState)state.func_206870_a(prop, (Comparable)optional.get());
        }
        return state;
    }

    public Schematic(String name) {
        this.name = name;
    }

    public void load(CompoundNBT compound) {
        this.width = compound.func_74765_d("Width");
        this.height = compound.func_74765_d("Height");
        this.length = compound.func_74765_d("Length");
        byte[] addId = compound.func_74764_b("AddBlocks") ? compound.func_74770_j("AddBlocks") : new byte[]{};
        this.setBlockBytes(compound.func_74770_j("Blocks"), addId);
        this.blockDataArray = compound.func_74770_j("Data");
        this.entityList = compound.func_150295_c("Entities", 10);
        this.tileList = compound.func_150295_c("TileEntities", 10);
        if (compound.func_150297_b("BlockIDs", 10)) {
            CompoundNBT comp = compound.func_74775_l("BlockIDs");
            this.blockIds = new HashMap();
            for (String idStr : comp.func_150296_c()) {
                String key = comp.func_74779_i(idStr);
                try {
                    int id = Integer.parseInt(idStr);
                    Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(key));
                    if (block == null) continue;
                    this.blockIds.put(id + ":0", block.func_176223_P());
                }
                catch (NumberFormatException e) {}
            }
        }
    }

    @Override
    public CompoundNBT getNBT() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74777_a("Width", this.width);
        compound.func_74777_a("Height", this.height);
        compound.func_74777_a("Length", this.length);
        byte[][] arr = this.getBlockBytes();
        compound.func_74773_a("Blocks", arr[0]);
        if (arr.length > 1) {
            compound.func_74773_a("AddBlocks", arr[1]);
        }
        compound.func_74773_a("Data", this.blockDataArray);
        compound.func_218657_a("TileEntities", (INBT)this.tileList);
        CompoundNBT comp = new CompoundNBT();
        for (Map.Entry<String, BlockState> entry : this.blockIds.entrySet()) {
            comp.func_74778_a(Block.func_196246_j((BlockState)entry.getValue()) + "", entry.getValue().func_177230_c().getRegistryName().toString());
        }
        compound.func_218657_a("BlockIDs", (INBT)comp);
        return compound;
    }

    public void setBlockBytes(byte[] blockId, byte[] addId) {
        this.blockArray = new short[blockId.length];
        for (int index = 0; index < blockId.length; ++index) {
            short id = (short)(blockId[index] & 0xFF);
            if (index >> 1 < addId.length) {
                id = (index & 1) == 0 ? (short)(id + (short)((addId[index >> 1] & 0xF) << 8)) : (short)(id + (short)((addId[index >> 1] & 0xF0) << 4));
            }
            this.blockArray[index] = id;
        }
    }

    public byte[][] getBlockBytes() {
        byte[] blocks = new byte[this.blockArray.length];
        byte[] addBlocks = null;
        for (int i = 0; i < blocks.length; ++i) {
            short id = this.blockArray[i];
            if (id > 255) {
                if (addBlocks == null) {
                    addBlocks = new byte[(blocks.length >> 1) + 1];
                }
                addBlocks[i >> 1] = (i & 1) == 0 ? (byte)(addBlocks[i >> 1] & 0xF0 | id >> 8 & 0xF) : (byte)(addBlocks[i >> 1] & 0xF | (id >> 8 & 0xF) << 4);
            }
            blocks[i] = (byte)id;
        }
        if (addBlocks == null) {
            return new byte[][]{blocks};
        }
        return new byte[][]{blocks, addBlocks};
    }

    public int xyzToIndex(int x, int y, int z) {
        return (y * this.length + z) * this.width + x;
    }

    @Override
    public BlockState getBlockState(int x, int y, int z) {
        return this.getBlockState(this.xyzToIndex(x, y, z));
    }

    @Override
    public BlockState getBlockState(int i) {
        BlockState b = this.blockIds.get(this.blockArray[i] + ":" + this.blockDataArray[i]);
        if (b == null) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return b;
    }

    @Override
    public short getWidth() {
        return this.width;
    }

    @Override
    public short getHeight() {
        return this.height;
    }

    @Override
    public short getLength() {
        return this.length;
    }

    @Override
    public int getBlockEntitySize() {
        if (this.tileList == null) {
            return 0;
        }
        return this.tileList.size();
    }

    @Override
    public CompoundNBT getBlockEntity(int i) {
        return this.tileList.func_150305_b(i);
    }

    @Override
    public String getName() {
        return this.name;
    }

    static {
        InputStream stream = MinecraftServer.class.getResourceAsStream("/data/customnpcs/legacy_blockids.json");
        try {
            InputStreamReader reader = new InputStreamReader(stream, "UTF-8");
            JsonObject result = ((JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class)).getAsJsonObject("blocks");
            for (Map.Entry entry : result.entrySet()) {
                Block block;
                String val = ((JsonElement)entry.getValue()).getAsString();
                String[] properties = null;
                if (val.indexOf(91) > 0) {
                    properties = val.substring(val.indexOf(91) + 1, val.length() - 1).split(",");
                    val = val.substring(0, val.indexOf(91));
                }
                if ((block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(val))) == null) continue;
                BlockState state = block.func_176223_P();
                if (properties != null) {
                    for (Property prop : state.func_235904_r_()) {
                        for (String r : properties) {
                            if (!r.startsWith(prop.func_177701_a() + "=")) continue;
                            state = Schematic.setValue(state, prop, r.split("=")[1]);
                        }
                    }
                }
                staticBlockIds.put((String)entry.getKey(), state);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }
}

