/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.schematics;

import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.command.arguments.BlockStateParser;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.datafix.DataFixesManager;
import net.minecraft.util.datafix.TypeReferences;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import noppes.npcs.CustomBlocks;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.schematics.ISchematic;

public class SpongeSchem
implements ISchematic {
    public static final int latestDataVersion = 2586;
    public String name;
    public short width;
    public short height;
    public short length;
    public long timestamp = System.currentTimeMillis();
    public int[] data;
    public Map<Integer, BlockState> palette = new HashMap<Integer, BlockState>();
    public List<CompoundNBT> tileData = new ArrayList<CompoundNBT>();

    public SpongeSchem(String name) {
        this.name = name;
    }

    @Override
    public short getWidth() {
        return this.width;
    }

    @Override
    public short getHeight() {
        return this.height;
    }

    @Override
    public short getLength() {
        return this.length;
    }

    @Override
    public int getBlockEntitySize() {
        return this.tileData.size();
    }

    @Override
    public CompoundNBT getBlockEntity(int i) {
        return this.tileData.get(i);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public BlockState getBlockState(int x, int y, int z) {
        return this.getBlockState(this.xyzToIndex(x, y, z));
    }

    public int xyzToIndex(int x, int y, int z) {
        return (y * this.length + z) * this.width + x;
    }

    @Override
    public BlockState getBlockState(int i) {
        return this.palette.get(this.data[i]);
    }

    @Override
    public CompoundNBT getNBT() {
        CompoundNBT root = new CompoundNBT();
        CompoundNBT compound = new CompoundNBT();
        root.func_218657_a("", (INBT)compound);
        CompoundNBT data = new CompoundNBT();
        compound.func_218657_a("Schematic", (INBT)data);
        data.func_74768_a("Width", (int)this.width);
        data.func_74768_a("Height", (int)this.height);
        data.func_74768_a("Length", (int)this.length);
        data.func_74768_a("Version", 3);
        data.func_74768_a("DataVersion", 2586);
        CompoundNBT metadata = new CompoundNBT();
        metadata.func_74772_a("Date", this.timestamp);
        data.func_218657_a("Metadata", (INBT)metadata);
        CompoundNBT blockData = new CompoundNBT();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(this.data.length);
        for (int i = 0; i < this.data.length; ++i) {
            int blockId = this.data[i];
            while ((blockId & 0xFFFFFF80) != 0) {
                buffer.write(blockId & 0x7F | 0x80);
                blockId >>>= 7;
            }
            buffer.write(blockId);
        }
        blockData.func_74773_a("Data", buffer.toByteArray());
        CompoundNBT palletteNBT = new CompoundNBT();
        for (Map.Entry<Integer, BlockState> en : this.palette.entrySet()) {
            palletteNBT.func_74768_a(BlockStateParser.func_197247_a((BlockState)en.getValue()), en.getKey().intValue());
        }
        blockData.func_218657_a("Palette", (INBT)palletteNBT);
        ListNBT tileNBT = new ListNBT();
        for (CompoundNBT tile : this.tileData) {
            tile = tile.func_74737_b();
            tile.func_74783_a("Pos", new int[]{tile.func_74762_e("x"), tile.func_74762_e("y"), tile.func_74762_e("z")});
            tile.func_74778_a("Id", tile.func_74779_i("id"));
            tile.func_82580_o("x");
            tile.func_82580_o("y");
            tile.func_82580_o("z");
            tile.func_82580_o("id");
            tileNBT.add((Object)tile);
        }
        blockData.func_218657_a("BlockEntities", (INBT)tileNBT);
        data.func_218657_a("Blocks", (INBT)blockData);
        return root;
    }

    public void load(CompoundNBT compound) {
        int version;
        if (compound.func_186856_d() == 1) {
            compound = compound.func_74775_l("").func_74775_l("Schematic");
        }
        this.width = compound.func_74765_d("Width");
        this.height = compound.func_74765_d("Height");
        this.length = compound.func_74765_d("Length");
        CompoundNBT metadata = compound.func_74775_l("Metadata");
        this.timestamp = 0L;
        if (!metadata.isEmpty()) {
            this.timestamp = metadata.func_74763_f("Date");
        }
        int dataVersion = 1631;
        if (compound.func_74764_b("DataVersion")) {
            dataVersion = compound.func_74762_e("DataVersion");
            if (dataVersion > 2586) {
                // empty if block
            }
            if (dataVersion < 2586) {
                // empty if block
            }
        }
        if ((version = compound.func_74762_e("Version")) < 3) {
            this.palette = this.readPalette(compound.func_74775_l("Palette"), dataVersion);
            ListNBT tileEntities = compound.func_150295_c("BlockEntities", 10);
            if (tileEntities.isEmpty()) {
                tileEntities = compound.func_150295_c("TileEntities", 10);
            }
            this.tileData = this.readTileData(tileEntities, dataVersion);
            this.data = this.readBlockData(compound.func_74770_j("BlockData"));
        } else {
            CompoundNBT blocks = compound.func_74775_l("Blocks");
            this.palette = this.readPalette(blocks.func_74775_l("Palette"), dataVersion);
            this.tileData = this.readTileData(blocks.func_150295_c("BlockEntities", 10), dataVersion);
            this.data = this.readBlockData(blocks.func_74770_j("Data"));
        }
    }

    private int[] readBlockData(byte[] bytes) {
        int[] data = new int[this.width * this.length * this.height];
        int index = 0;
        int i = 0;
        while (i < bytes.length) {
            int value = 0;
            int varintLength = 0;
            while (true) {
                value |= (bytes[i] & 0x7F) << varintLength++ * 7;
                if (varintLength > 5) {
                    throw new CustomNPCsException("VarInt too big (probably corrupted data)", new Object[0]);
                }
                if ((bytes[i] & 0x80) != 128) {
                    ++i;
                    break;
                }
                ++i;
            }
            data[index] = value;
            ++index;
        }
        return data;
    }

    private Map<Integer, BlockState> readPalette(CompoundNBT comp, int dataVersion) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        HashMap<Integer, BlockState> palette = new HashMap<Integer, BlockState>();
        for (String blockState : comp.func_150296_c()) {
            int id = comp.func_74762_e(blockState);
            if (dataVersion < 2586) {
                CompoundNBT stateNBT = SpongeSchem.stateToNBT(blockState);
                Dynamic dynamic = new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)stateNBT);
                stateNBT = (CompoundNBT)DataFixesManager.func_210901_a().update(TypeReferences.field_211296_l, dynamic, dataVersion, 2586).getValue();
                blockState = this.nbtToState(stateNBT);
            }
            map.put(blockState, id);
        }
        for (Block block : ForgeRegistries.BLOCKS) {
            block.func_176194_O().func_177619_a().forEach(state -> {
                String name = BlockStateParser.func_197247_a((BlockState)state);
                if (map.containsKey(name)) {
                    int id = (Integer)map.remove(name);
                    palette.put(id, (BlockState)state);
                }
            });
        }
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            int id = (Integer)iterator.next();
            palette.put(id, Blocks.field_150350_a.func_176223_P());
        }
        return palette;
    }

    private List<CompoundNBT> readTileData(ListNBT list, int dataVersion) {
        ArrayList<CompoundNBT> tileData = new ArrayList<CompoundNBT>();
        if (list.isEmpty()) {
            return tileData;
        }
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT data = list.func_150305_b(i);
            int[] posArr = data.func_74759_k("Pos");
            BlockPos pos = new BlockPos(posArr[0], posArr[1], posArr[2]);
            data.func_74768_a("x", pos.func_177958_n());
            data.func_74768_a("y", pos.func_177956_o());
            data.func_74768_a("z", pos.func_177952_p());
            data.func_218657_a("id", data.func_74781_a("Id"));
            data.func_82580_o("Id");
            data.func_82580_o("Pos");
            if (dataVersion < 2586) {
                Dynamic dynamic = new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)data);
                data = (CompoundNBT)DataFixesManager.func_210901_a().update(TypeReferences.field_211294_j, dynamic, dataVersion, 2586).getValue();
            } else {
                data = data.func_74737_b();
            }
            tileData.add(data);
        }
        return tileData;
    }

    private String nbtToState(CompoundNBT tagCompound) {
        StringBuilder sb = new StringBuilder();
        sb.append(tagCompound.func_74779_i("Name"));
        if (tagCompound.func_150297_b("Properties", 10)) {
            sb.append('[');
            CompoundNBT props = tagCompound.func_74775_l("Properties");
            sb.append(props.func_150296_c().stream().map(k -> k + "=" + props.func_74779_i(k).replace("\"", "")).collect(Collectors.joining(",")));
            sb.append(']');
        }
        return sb.toString();
    }

    private static CompoundNBT stateToNBT(String blockState) {
        int propIdx = blockState.indexOf(91);
        CompoundNBT tag = new CompoundNBT();
        if (propIdx < 0) {
            tag.func_74778_a("Name", blockState);
        } else {
            String[] propArr;
            tag.func_74778_a("Name", blockState.substring(0, propIdx));
            CompoundNBT propTag = new CompoundNBT();
            String props = blockState.substring(propIdx + 1, blockState.length() - 1);
            for (String pair : propArr = props.split(",")) {
                String[] split = pair.split("=");
                propTag.func_74778_a(split[0], split[1]);
            }
            tag.func_218657_a("Properties", (INBT)propTag);
        }
        return tag;
    }

    public static SpongeSchem Create(World level, String name, BlockPos pos, short height, short width, short length) {
        SpongeSchem schema = new SpongeSchem(name);
        schema.height = height;
        schema.width = width;
        schema.length = length;
        int size = height * width * length;
        NoppesUtilServer.NotifyOPs("Creating schematic at: " + pos + " might lag slightly", new Object[0]);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        schema.data = new int[size];
        int uniqueBlockId = 0;
        for (int i = 0; i < size; ++i) {
            int x = i % width;
            int z = (i - x) / width % length;
            int y = ((i - x) / width - z) / length;
            BlockState state = level.func_180495_p(pos.func_177982_a(x, y, z));
            if (state.func_177230_c() == CustomBlocks.copy) continue;
            String stateName = BlockStateParser.func_197247_a((BlockState)state);
            Integer blockId = (Integer)map.get(stateName);
            if (!map.containsKey(stateName)) {
                blockId = uniqueBlockId++;
                map.put(stateName, blockId);
            }
            schema.palette.put(blockId, state);
            schema.data[i] = blockId;
            if (!(state.func_177230_c() instanceof ITileEntityProvider)) continue;
            TileEntity tile = level.func_175625_s(pos.func_177982_a(x, y, z));
            CompoundNBT compound = new CompoundNBT();
            tile.func_189515_b(compound);
            compound.func_74768_a("x", x);
            compound.func_74768_a("y", y);
            compound.func_74768_a("z", z);
            schema.tileData.add(compound);
        }
        return schema;
    }
}

