/*
 * Decompiled with CFR 0.152.
 */
package net.isaiah.zazaaddon.abilities.imu;

import java.awt.Color;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.isaiah.zazaaddon.entities.TrackingLightningEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.SwingTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.math.VectorHelper;
import xyz.pixelatedw.mineminenomi.config.ClientConfig;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goro.LightningEntity;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class RedArrow
extends Ability {
    private static final ResourceLocation DEFAULT_ICON = new ResourceLocation("zazaaddon", "textures/abilities/alts/redarrow.png");
    private static final ResourceLocation ALT_ICON = new ResourceLocation("zazaaddon", "textures/abilities/alts/redarrow.png");
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"zazaaddon", (String)"red_arrow", (Pair[])new Pair[]{ImmutablePair.of((Object)"Shoots out a barrage of red arrow projectiles at enemies that can paralyze targets.", null)});
    private static final int HOLD_TIME = 100;
    private static final int COOLDOWN = 800;
    private static final Color BRIGHT_RED_COLOR = new Color(70, 0, 0, 255);
    private TrackingLightningEntity primaryArrow = null;
    private LivingEntity currentTarget = null;
    private int redirectCooldown = 0;
    private int redirectCount = 0;
    private boolean needsRedirection = false;
    private final Map<UUID, LightningEntity> arrowSegments = new HashMap<UUID, LightningEntity>();
    public static final AbilityCore INSTANCE = new AbilityCore.Builder("Red Arrow", AbilityCategory.DEVIL_FRUITS, RedArrow::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)800.0f), ContinuousComponent.getTooltip((float)100.0f)}).setSourceHakiNature(SourceHakiNature.SPECIAL).setSourceType(new SourceType[]{SourceType.PROJECTILE}).setSourceElement(SourceElement.NONE).setIcon(DEFAULT_ICON).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::startContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final SwingTriggerComponent swingTriggerComponent = new SwingTriggerComponent((IAbility)this).addSwingEvent(this::swingEvent);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);

    public RedArrow(AbilityCore<RedArrow> core) {
        super(core);
        this.isNew = true;
        super.addComponents(new AbilityComponent[]{this.continuousComponent, this.swingTriggerComponent, this.rangeComponent, this.dealDamageComponent});
        super.addUseEvent(this::onUseEvent);
        super.setDisplayIcon(DEFAULT_ICON);
        if (ClientConfig.INSTANCE.isGoroBlue()) {
            super.setDisplayIcon(ALT_ICON);
        }
        super.addEquipEvent(this::equipEvent);
        super.addTickEvent(this::onTickEvent);
    }

    public void equipEvent(LivingEntity entity, Ability ability) {
        super.setDisplayIcon(DEFAULT_ICON);
        if (ClientConfig.INSTANCE.isGoroBlue()) {
            super.setDisplayIcon(ALT_ICON);
        }
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 100.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.primaryArrow = null;
        this.currentTarget = null;
        this.redirectCount = 0;
        this.redirectCooldown = 0;
        this.needsRedirection = false;
        for (LightningEntity segment : this.arrowSegments.values()) {
            if (segment == null || segment.field_70128_L) continue;
            segment.func_70106_y();
        }
        this.arrowSegments.clear();
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 800.0f);
        if (this.primaryArrow != null && !this.primaryArrow.field_70128_L) {
            this.primaryArrow.func_70106_y();
            this.primaryArrow = null;
        }
        for (LightningEntity segment : this.arrowSegments.values()) {
            if (segment == null || segment.field_70128_L) continue;
            segment.func_70106_y();
        }
        this.arrowSegments.clear();
    }

    private void swingEvent(LivingEntity entity, IAbility ability) {
        if (this.continuousComponent.isContinuous()) {
            if (this.primaryArrow == null || this.primaryArrow.field_70128_L) {
                this.createPrimaryArrow(entity);
            }
            entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.DASH_ABILITY_SWOOSH_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
        }
    }

    private void onTickEvent(LivingEntity entity, IAbility ability) {
        LivingEntity newTarget;
        if (!(entity instanceof PlayerEntity) || this.primaryArrow == null || this.primaryArrow.field_70128_L) {
            return;
        }
        if (this.redirectCooldown > 0) {
            --this.redirectCooldown;
        }
        if (!((newTarget = this.findTargetInCrosshairs(entity)) == null || this.currentTarget != null && this.currentTarget.equals((Object)newTarget) || this.redirectCooldown > 0 || this.redirectCount >= 5)) {
            this.currentTarget = newTarget;
            this.needsRedirection = true;
            this.redirectCooldown = 10;
        }
        if (this.needsRedirection) {
            this.createLShapedSegment(entity, this.primaryArrow.func_213303_ch(), this.currentTarget);
            ++this.redirectCount;
            this.needsRedirection = false;
        }
    }

    private void createLShapedSegment(LivingEntity shooter, Vector3d startPos, LivingEntity target) {
        if (target == null) {
            return;
        }
        float damage = 80.0f;
        float size = 0.03f;
        float length = 100.0f;
        float travelSpeed = 7.0f;
        shooter.field_70170_p.func_184148_a(null, startPos.field_72450_a, startPos.field_72448_b, startPos.field_72449_c, (SoundEvent)ModSounds.DASH_ABILITY_SWOOSH_SFX.get(), SoundCategory.PLAYERS, 1.5f, 1.2f);
        Vector3d targetPos = target.func_213303_ch().func_72441_c(0.0, (double)(target.func_213302_cg() / 2.0f), 0.0);
        Vector3d direction = targetPos.func_178788_d(startPos).func_72432_b();
        LightningEntity connectionNode = new LightningEntity((Entity)shooter, startPos.field_72450_a, startPos.field_72448_b, startPos.field_72449_c, 0.0f, 0.0f, 0.5f, 0.0f, this.getCore());
        this.configureRedArrowSegment(connectionNode, 0.08f, 5.0f);
        shooter.field_70170_p.func_217376_c((Entity)connectionNode);
        this.arrowSegments.put(connectionNode.func_110124_au(), connectionNode);
        LightningEntity segment = new LightningEntity((Entity)shooter, startPos.field_72450_a, startPos.field_72448_b, startPos.field_72449_c, 0.0f, 0.0f, length, travelSpeed, this.getCore());
        try {
            Field motionXField = LightningEntity.class.getDeclaredField("motionX");
            motionXField.setAccessible(true);
            motionXField.setDouble(segment, direction.field_72450_a * (double)travelSpeed);
            Field motionYField = LightningEntity.class.getDeclaredField("motionY");
            motionYField.setAccessible(true);
            motionYField.setDouble(segment, direction.field_72448_b * (double)travelSpeed);
            Field motionZField = LightningEntity.class.getDeclaredField("motionZ");
            motionZField.setAccessible(true);
            motionZField.setDouble(segment, direction.field_72449_c * (double)travelSpeed);
        }
        catch (Exception e) {
            segment.func_213317_d(direction.func_186678_a((double)travelSpeed));
        }
        this.configureRedArrowSegment(segment, size, damage);
        shooter.field_70170_p.func_217376_c((Entity)segment);
        this.arrowSegments.put(segment.func_110124_au(), segment);
    }

    private void configureRedArrowSegment(LightningEntity segment, float size, float damage) {
        segment.setBlocksAffectedLimit(1508);
        segment.setMaxLife(7);
        segment.setDamage(damage);
        segment.setExplosion(0, false);
        segment.setSize(size);
        segment.setBoxSizeDivision(1.0);
        segment.setAngle(100);
        segment.setTargetTimeToReset(6000);
        segment.disableExplosionKnockback();
        segment.setBranches(1);
        segment.setSegments(1);
        segment.setLightningMimic(false);
        segment.setEnergyEffect(true);
        segment.setColor(BRIGHT_RED_COLOR);
        try {
            Field colorField = LightningEntity.class.getDeclaredField("color");
            colorField.setAccessible(true);
            colorField.setInt(segment, BRIGHT_RED_COLOR.getRGB());
            Field alphaField = LightningEntity.class.getDeclaredField("alpha");
            alphaField.setAccessible(true);
            alphaField.setInt(segment, 255);
        }
        catch (Exception e) {
            System.err.println("Failed to force color: " + e.getMessage());
        }
    }

    private void createPrimaryArrow(LivingEntity entity) {
        LivingEntity target;
        this.currentTarget = target = this.findTargetInCrosshairs(entity);
        this.redirectCount = 0;
        this.redirectCooldown = 0;
        this.needsRedirection = false;
        float damage = 80.0f;
        float size = 0.03f;
        float length = 100.0f;
        float travelSpeed = 7.0f;
        Vector3d pos = VectorHelper.calculateRotationBasedOffsetPosition((Vector3d)entity.func_213303_ch(), (double)entity.field_70761_aq, (double)0.0, (double)1.15, (double)0.0);
        if (target != null) {
            this.primaryArrow = new TrackingLightningEntity(entity, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, target, length, travelSpeed, (AbilityCore<? extends IAbility>)this.getCore());
            this.primaryArrow.setTrackingSpeed(0.6f);
            this.primaryArrow.setTrackingDuration(150);
            this.primaryArrow.setMaxTrackingRange(65.0);
            this.primaryArrow.setBlocksAffectedLimit(1508);
            this.primaryArrow.setMaxLife(7);
            this.primaryArrow.setDamage(damage);
            this.primaryArrow.setExplosion(0, false);
            this.primaryArrow.setSize(size);
            this.primaryArrow.setBoxSizeDivision(1.0);
            this.primaryArrow.setAngle(100);
            this.primaryArrow.setTargetTimeToReset(6000);
            this.primaryArrow.disableExplosionKnockback();
            this.primaryArrow.setBranches(1);
            this.primaryArrow.setSegments(1);
            this.primaryArrow.setLightningMimic(false);
            this.primaryArrow.setEnergyEffect(true);
            this.primaryArrow.setColor(BRIGHT_RED_COLOR);
            try {
                Field colorField = LightningEntity.class.getDeclaredField("color");
                colorField.setAccessible(true);
                colorField.setInt((Object)this.primaryArrow, BRIGHT_RED_COLOR.getRGB());
                Field alphaField = LightningEntity.class.getDeclaredField("alpha");
                alphaField.setAccessible(true);
                alphaField.setInt((Object)this.primaryArrow, 255);
            }
            catch (Exception e) {
                System.err.println("Failed to force color: " + e.getMessage());
            }
            entity.field_70170_p.func_217376_c((Entity)this.primaryArrow);
        } else {
            BlockRayTraceResult mop = WyHelper.rayTraceBlocks((Entity)entity, (double)64.0);
            double beamDistance = Math.sqrt(entity.func_70092_e(mop.func_216347_e().field_72450_a, mop.func_216347_e().field_72448_b, mop.func_216347_e().field_72449_c));
            LightningEntity redArrow = new LightningEntity((Entity)entity, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, entity.field_70177_z, entity.field_70125_A, length + (float)beamDistance, travelSpeed, this.getCore());
            redArrow.setBlocksAffectedLimit(1508);
            redArrow.setMaxLife(7);
            redArrow.setDamage(damage);
            redArrow.setExplosion(0, false);
            redArrow.setSize(size);
            redArrow.setBoxSizeDivision(1.0);
            redArrow.setAngle(100);
            redArrow.setTargetTimeToReset(6000);
            redArrow.disableExplosionKnockback();
            redArrow.setBranches(1);
            redArrow.setSegments(1);
            redArrow.setLightningMimic(false);
            redArrow.setEnergyEffect(true);
            redArrow.setColor(BRIGHT_RED_COLOR);
            try {
                Field colorField = LightningEntity.class.getDeclaredField("color");
                colorField.setAccessible(true);
                colorField.setInt(redArrow, BRIGHT_RED_COLOR.getRGB());
                Field alphaField = LightningEntity.class.getDeclaredField("alpha");
                alphaField.setAccessible(true);
                alphaField.setInt(redArrow, 255);
            }
            catch (Exception e) {
                System.err.println("Failed to force color: " + e.getMessage());
            }
            entity.field_70170_p.func_217376_c((Entity)redArrow);
            this.primaryArrow = null;
        }
    }

    private LivingEntity findTargetInCrosshairs(LivingEntity shooter) {
        Vector3d startPos = shooter.func_174824_e(1.0f);
        Vector3d lookDirection = shooter.func_70676_i(1.0f);
        List entities = shooter.field_70170_p.func_217357_a(LivingEntity.class, shooter.func_174813_aQ().func_186662_g(50.0));
        LivingEntity closestToCursor = null;
        double smallestAngle = Double.MAX_VALUE;
        double maxRange = 50.0;
        double maxAngle = 15.0;
        for (LivingEntity entity : entities) {
            Vector3d entityPos;
            Vector3d directionToEntity;
            double dotProduct;
            double angleInRadians;
            double angleInDegrees;
            double distance;
            if (entity == shooter || !entity.func_70089_S() || (distance = (double)shooter.func_70032_d((Entity)entity)) > maxRange || !((angleInDegrees = Math.toDegrees(angleInRadians = Math.acos(Math.max(-1.0, Math.min(1.0, dotProduct = lookDirection.func_72430_b(directionToEntity = (entityPos = entity.func_213303_ch().func_72441_c(0.0, (double)(entity.func_213302_cg() / 2.0f), 0.0)).func_178788_d(startPos).func_72432_b())))))) <= maxAngle) || !(angleInDegrees < smallestAngle)) continue;
            smallestAngle = angleInDegrees;
            closestToCursor = entity;
        }
        return closestToCursor;
    }
}

