/*
 * Decompiled with CFR 0.152.
 */
package net.isaiah.zazaaddon.abilities.imu;

import java.util.function.Predicate;
import net.isaiah.zazaaddon.init.ModResources;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityOverlay;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.PunchAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.SkinOverlayComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.StackComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.config.ClientConfig;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ZaZaImbuing
extends PunchAbility2 {
    private static final ResourceLocation DEFAULT_ICON = new ResourceLocation("zazaaddon", "textures/abilities/alts/imuimbue.png");
    private static final ResourceLocation ALT_ICON = new ResourceLocation("zazaaddon", "textures/abilities/alts/imuimbue.png");
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"zazaaddon", (String)"zaza_imbuing", (Pair[])new Pair[]{ImmutablePair.of((Object)"Imbue your fists with the Flame Mother", null)});
    private static final int MAX_STACKS = 5;
    private static final int COOLDOWN = 550;
    public static final AbilityCore<ZaZaImbuing> INSTANCE = new AbilityCore.Builder("Mother Of Flame Imbuing", AbilityCategory.DEVIL_FRUITS, ZaZaImbuing::new).addDescriptionLine(DESCRIPTION).addDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, DealDamageComponent.getTooltip((float)8.0f, (float)25.0f), CooldownComponent.getTooltip((float)550.0f), StackComponent.getTooltip((int)5)}).setSourceHakiNature(SourceHakiNature.SPECIAL).setSourceType(new SourceType[]{SourceType.FIST}).setSourceElement(SourceElement.MAGMA).setIcon(DEFAULT_ICON).build();
    private static final AbilityOverlay OVERLAY = new AbilityOverlay.Builder().setOverlayPart(AbilityOverlay.OverlayPart.LIMB).setTexture(ModResources.MOTHEROFFLAME).build();
    private final StackComponent stackComponent = new StackComponent((IAbility)this, 5);
    private final SkinOverlayComponent skinOverlayComponent;

    public ZaZaImbuing(AbilityCore<ZaZaImbuing> core) {
        super(core);
        super.setDisplayIcon(DEFAULT_ICON);
        if (ClientConfig.INSTANCE.isGoroBlue()) {
            super.setDisplayIcon(ALT_ICON);
        }
        this.skinOverlayComponent = new SkinOverlayComponent((IAbility)this, OVERLAY, new AbilityOverlay[0]);
        this.addComponents(new AbilityComponent[]{this.stackComponent, this.skinOverlayComponent});
        this.continuousComponent.addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent).addStartEvent(this::onContinuityStart);
        super.addEquipEvent(this::equipEvent);
    }

    public void equipEvent(LivingEntity entity, Ability ability) {
        super.setDisplayIcon(DEFAULT_ICON);
        if (ClientConfig.INSTANCE.isGoroBlue()) {
            super.setDisplayIcon(ALT_ICON);
        }
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        this.skinOverlayComponent.showAll(entity);
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K && this.stackComponent.getStacks() == 0) {
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.skinOverlayComponent.hideAll(entity);
        this.stackComponent.revertStacksToDefault(entity, (IAbility)this);
    }

    public float getPunchDamage() {
        int stacks = this.stackComponent.getStacks();
        if (stacks == 5) {
            return 25.0f;
        }
        if (stacks == 4) {
            return 22.0f;
        }
        if (stacks == 3) {
            return 18.0f;
        }
        if (stacks == 2) {
            return 15.0f;
        }
        if (stacks == 1) {
            return 12.0f;
        }
        return 8.0f;
    }

    public boolean onHitEffect(LivingEntity entity, LivingEntity target, ModDamageSource source) {
        if (this.continuousComponent.isContinuous()) {
            AbilityHelper.setSecondsOnFireBy((Entity)target, (int)5, (LivingEntity)entity);
            if (entity.func_70681_au().nextInt(10) < 3) {
                WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)ModParticleEffects.VENOM_DEMON.get()), (Entity)entity, (double)(target.func_226277_ct_() + (entity.func_70681_au().nextDouble() - 0.5) * 2.0), (double)(target.func_226278_cu_() + entity.func_70681_au().nextDouble()), (double)(target.func_226281_cx_() + (entity.func_70681_au().nextDouble() - 0.5) * 2.0));
            }
            if (this.stackComponent.getStacks() > 0) {
                int stacksLeft = this.stackComponent.getStacks();
                float damageDealt = this.getPunchDamage();
                float healAmount = damageDealt * (0.15f + (float)stacksLeft * 0.05f);
                if (entity.func_110143_aJ() < entity.func_110138_aP()) {
                    entity.func_70691_i(healAmount);
                }
                target.func_195064_c(new EffectInstance((Effect)ModEffects.PARALYSIS.get(), 40 + stacksLeft * 20, 0));
                target.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 20 + stacksLeft * 15, 0));
                int poisonDuration = 100 + stacksLeft * 20;
                int poisonAmplifier = Math.min(stacksLeft - 1, 4);
                target.func_195064_c(new EffectInstance((Effect)ModEffects.DOKU_POISON.get(), poisonDuration, poisonAmplifier));
            }
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)ModParticleEffects.VENOM_DEMON.get()), (Entity)entity, (double)target.func_226277_ct_(), (double)(target.func_226278_cu_() + (double)(target.func_213302_cg() / 2.0f)), (double)target.func_226281_cx_());
            this.stackComponent.addStacks(entity, (IAbility)this, -1);
            if (this.stackComponent.getStacks() == 0) {
                float finalHeal = this.getPunchDamage() * 0.8f;
                if (entity.func_110143_aJ() < entity.func_110138_aP()) {
                    entity.func_70691_i(finalHeal);
                }
                AbilityHelper.setSecondsOnFireBy((Entity)target, (int)10, (LivingEntity)entity);
                target.func_195064_c(new EffectInstance((Effect)ModEffects.DOKU_POISON.get(), 200, 4));
                for (int i = 0; i < 6; ++i) {
                    double angle = (double)i * Math.PI * 2.0 / 6.0;
                    double radius = 1.5;
                    double x = target.func_226277_ct_() + Math.cos(angle) * radius;
                    double z = target.func_226281_cx_() + Math.sin(angle) * radius;
                    WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)ModParticleEffects.VENOM_DEMON.get()), (Entity)entity, (double)x, (double)(target.func_226278_cu_() + 0.5), (double)z);
                }
            }
        }
        return true;
    }

    public Predicate<LivingEntity> canActivate() {
        return entity -> this.continuousComponent.isContinuous();
    }

    public int getUseLimit() {
        return -1;
    }

    public float getPunchCooldown() {
        return 550.0f;
    }

    public boolean isParallel() {
        return true;
    }
}

