/*
 * Decompiled with CFR 0.152.
 */
package net.isaiah.zazaaddon.api;

import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryManager;
import xyz.pixelatedw.mineminenomi.api.ModRegistries;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.particles.data.SimpleParticleData;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

@Mod.EventBusSubscriber(modid="zazaaddon")
public class IsaiahRegistry {
    private static HashMap<String, String> langMap = new HashMap();
    public static final IForgeRegistry<MorphInfo> MORPHS = RegistryManager.ACTIVE.getRegistry(MorphInfo.class);
    public static final DeferredRegister<ParticleType<?>> PARTICLE_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"zazaaddon");
    public static final DeferredRegister<ParticleEffect<?>> PARTICLE_EFFECTS = DeferredRegister.create((IForgeRegistry)ModRegistries.PARTICLE_EFFECTS, (String)"zazaaddon");

    public static HashMap<String, String> getLangMap() {
        return langMap;
    }

    public static String registerName(String key, String localizedName) {
        IsaiahRegistry.getLangMap().put(key, localizedName);
        return key;
    }

    public static TranslationTextComponent registerTextComponent(String key, String localizedName) {
        return new TranslationTextComponent(IsaiahRegistry.registerName(key, localizedName));
    }

    public static <T extends IForgeRegistryEntry<T>> void make(ResourceLocation name, Class<T> type) {
        new RegistryBuilder().setName(name).setType(type).setMaxID(0x7FFFFFFE).create();
    }

    public static RegistryObject<ParticleType<SimpleParticleData>> registerParticleType(String name, final Supplier<SimpleParticleData> factory) {
        String resourceName = WyHelper.getResourceName((String)name);
        return PARTICLE_TYPES.register(resourceName, () -> new ParticleType<SimpleParticleData>(false, SimpleParticleData.DESERIALIZER){

            public Codec<SimpleParticleData> func_230522_e_() {
                return Codec.unit(factory.get());
            }
        });
    }

    public static <T extends ParticleEffect<?>> RegistryObject<T> registerParticleEffect(String localizedName, Supplier<T> effect) {
        String resourceName = WyHelper.getResourceName((String)localizedName);
        RegistryObject reg = PARTICLE_EFFECTS.register(resourceName, effect);
        return reg;
    }

    public static void registerAll(IEventBus eventBus) {
        PARTICLE_TYPES.register(eventBus);
        PARTICLE_EFFECTS.register(eventBus);
    }
}

