/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.entity.player;

import com.google.common.hash.Hashing;
import com.mojang.authlib.GameProfile;
import java.io.File;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.client.renderer.texture.DownloadingTexture;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.passive.ShoulderRidingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BowItem;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.optifine.Config;
import net.optifine.player.CapeUtils;
import net.optifine.player.PlayerConfigurations;
import net.optifine.reflect.Reflector;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class AbstractClientPlayerEntity
extends PlayerEntity {
    private NetworkPlayerInfo field_175157_a;
    public float field_184835_a;
    public float field_184836_b;
    public float field_184837_c;
    public final ClientWorld field_213837_d;
    private ResourceLocation locationOfCape = null;
    private long reloadCapeTimeMs = 0L;
    private boolean elytraOfCape = false;
    private String nameClear = null;
    public ShoulderRidingEntity entityShoulderLeft;
    public ShoulderRidingEntity entityShoulderRight;
    public float capeRotateX;
    public float capeRotateY;
    public float capeRotateZ;
    private static final ResourceLocation TEXTURE_ELYTRA = new ResourceLocation("textures/entity/elytra.png");

    public AbstractClientPlayerEntity(ClientWorld worldIn, GameProfile profileIn) {
        super((World)worldIn, worldIn.func_239140_u_(), worldIn.func_243489_v(), profileIn);
        this.field_213837_d = worldIn;
        this.nameClear = profileIn.getName();
        if (this.nameClear != null && !this.nameClear.isEmpty()) {
            this.nameClear = StringUtils.func_76338_a((String)this.nameClear);
        }
        CapeUtils.downloadCape((AbstractClientPlayerEntity)this);
        PlayerConfigurations.getPlayerConfiguration((AbstractClientPlayerEntity)this);
    }

    public boolean func_175149_v() {
        NetworkPlayerInfo networkplayerinfo = Minecraft.func_71410_x().func_147114_u().func_175102_a(this.func_146103_bH().getId());
        return networkplayerinfo != null && networkplayerinfo.func_178848_b() == GameType.SPECTATOR;
    }

    public boolean func_184812_l_() {
        NetworkPlayerInfo networkplayerinfo = Minecraft.func_71410_x().func_147114_u().func_175102_a(this.func_146103_bH().getId());
        return networkplayerinfo != null && networkplayerinfo.func_178848_b() == GameType.CREATIVE;
    }

    public boolean func_152122_n() {
        return this.func_175155_b() != null;
    }

    @Nullable
    protected NetworkPlayerInfo func_175155_b() {
        if (this.field_175157_a == null) {
            this.field_175157_a = Minecraft.func_71410_x().func_147114_u().func_175102_a(this.func_110124_au());
        }
        return this.field_175157_a;
    }

    public boolean func_152123_o() {
        NetworkPlayerInfo networkplayerinfo = this.func_175155_b();
        return networkplayerinfo != null && networkplayerinfo.func_178856_e();
    }

    public ResourceLocation func_110306_p() {
        NetworkPlayerInfo networkplayerinfo = this.func_175155_b();
        return networkplayerinfo == null ? DefaultPlayerSkin.func_177334_a((UUID)this.func_110124_au()) : networkplayerinfo.func_178837_g();
    }

    @Nullable
    public ResourceLocation func_110303_q() {
        if (!Config.isShowCapes()) {
            return null;
        }
        if (this.reloadCapeTimeMs != 0L && System.currentTimeMillis() > this.reloadCapeTimeMs) {
            CapeUtils.reloadCape((AbstractClientPlayerEntity)this);
            this.reloadCapeTimeMs = 0L;
        }
        if (this.locationOfCape != null) {
            return this.locationOfCape;
        }
        NetworkPlayerInfo networkplayerinfo = this.func_175155_b();
        return networkplayerinfo == null ? null : networkplayerinfo.func_178861_h();
    }

    public boolean func_184833_s() {
        return this.func_175155_b() != null;
    }

    @Nullable
    public ResourceLocation func_184834_t() {
        NetworkPlayerInfo networkplayerinfo = this.func_175155_b();
        return networkplayerinfo == null ? null : networkplayerinfo.func_187106_i();
    }

    public static DownloadingTexture func_110304_a(ResourceLocation resourceLocationIn, String username) {
        TextureManager texturemanager = Minecraft.func_71410_x().func_110434_K();
        Texture texture = texturemanager.func_229267_b_(resourceLocationIn);
        if (texture == null) {
            texture = new DownloadingTexture((File)null, String.format("http://skins.minecraft.net/MinecraftSkins/%s.png", StringUtils.func_76338_a((String)username)), DefaultPlayerSkin.func_177334_a((UUID)AbstractClientPlayerEntity.func_175147_b((String)username)), true, (Runnable)null);
            texturemanager.func_229263_a_(resourceLocationIn, texture);
        }
        return (DownloadingTexture)texture;
    }

    public static ResourceLocation func_110311_f(String username) {
        return new ResourceLocation("skins/" + Hashing.sha1().hashUnencodedChars((CharSequence)StringUtils.func_76338_a((String)username)));
    }

    public String func_175154_l() {
        NetworkPlayerInfo networkplayerinfo = this.func_175155_b();
        return networkplayerinfo == null ? DefaultPlayerSkin.func_177332_b((UUID)this.func_110124_au()) : networkplayerinfo.func_178851_f();
    }

    public float func_175156_o() {
        float f2 = 1.0f;
        if (this.field_71075_bZ.field_75100_b) {
            f2 *= 1.1f;
        }
        f2 = (float)((double)f2 * ((this.func_233637_b_(Attributes.field_233821_d_) / (double)this.field_71075_bZ.func_75094_b() + 1.0) / 2.0));
        if (this.field_71075_bZ.func_75094_b() == 0.0f || Float.isNaN(f2) || Float.isInfinite(f2)) {
            f2 = 1.0f;
        }
        if (this.func_184587_cr() && this.func_184607_cu().func_77973_b() instanceof BowItem) {
            int i2 = this.func_184612_cw();
            float f1 = (float)i2 / 20.0f;
            f1 = f1 > 1.0f ? 1.0f : (f1 *= f1);
            f2 *= 1.0f - f1 * 0.15f;
        }
        if (Reflector.ForgeHooksClient_getOffsetFOV.exists()) {
            return Reflector.callFloat(Reflector.ForgeHooksClient_getOffsetFOV, this, Float.valueOf(f2));
        }
        return MathHelper.func_219799_g((float)Minecraft.func_71410_x().field_71474_y.field_243227_aN, (float)1.0f, (float)f2);
    }

    public String getNameClear() {
        return this.nameClear;
    }

    public ResourceLocation getLocationOfCape() {
        return this.locationOfCape;
    }

    public void setLocationOfCape(ResourceLocation locationOfCape) {
        this.locationOfCape = locationOfCape;
    }

    public boolean hasElytraCape() {
        ResourceLocation loc = this.func_110303_q();
        if (loc == null) {
            return false;
        }
        if (loc == this.locationOfCape) {
            return this.elytraOfCape;
        }
        return true;
    }

    public void setElytraOfCape(boolean elytraOfCape) {
        this.elytraOfCape = elytraOfCape;
    }

    public boolean isElytraOfCape() {
        return this.elytraOfCape;
    }

    public long getReloadCapeTimeMs() {
        return this.reloadCapeTimeMs;
    }

    public void setReloadCapeTimeMs(long reloadCapeTimeMs) {
        this.reloadCapeTimeMs = reloadCapeTimeMs;
    }
}

