/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.chunk;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RegionRenderCacheBuilder;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.crash.CrashReport;
import net.minecraft.util.concurrent.DelegatedTaskExecutor;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.optifine.reflect.Reflector;
import net.optifine.render.RenderTypes;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkRenderDispatcher {
    private static final Logger field_178523_a = LogManager.getLogger();
    private final PriorityQueue<ChunkRender.ChunkRenderTask> field_228885_b_ = Queues.newPriorityQueue();
    private final Queue<RegionRenderCacheBuilder> field_228886_c_;
    private final Queue<Runnable> field_228887_d_ = Queues.newConcurrentLinkedQueue();
    private volatile int field_228888_e_;
    private volatile int field_228889_f_;
    private final RegionRenderCacheBuilder field_228890_g_;
    private final DelegatedTaskExecutor<Runnable> field_228891_h_;
    private final Executor field_228892_i_;
    private World field_228893_j_;
    private final WorldRenderer field_228894_k_;
    private Vector3d field_217672_l = Vector3d.field_186680_a;
    private int countRenderBuilders;
    private List<RegionRenderCacheBuilder> listPausedBuilders = new ArrayList();
    public static final RenderType[] BLOCK_RENDER_LAYERS = RenderType.func_228661_n_().toArray(new RenderType[0]);
    private static final boolean FORGE = Reflector.ForgeHooksClient.exists();
    private static final boolean FORGE_CAN_RENDER_IN_LAYER_BS = Reflector.ForgeRenderTypeLookup_canRenderInLayerBs.exists();
    private static final boolean FORGE_CAN_RENDER_IN_LAYER_FS = Reflector.ForgeRenderTypeLookup_canRenderInLayerBs.exists();
    private static final boolean FORGE_SET_RENDER_LAYER = Reflector.ForgeHooksClient_setRenderLayer.exists();
    public static int renderChunksUpdated;

    public ChunkRenderDispatcher(World worldIn, WorldRenderer worldRendererIn, Executor executorIn, boolean java64bit, RegionRenderCacheBuilder fixedBuilderIn) {
        this(worldIn, worldRendererIn, executorIn, java64bit, fixedBuilderIn, -1);
    }

    public ChunkRenderDispatcher(World worldIn, WorldRenderer worldRendererIn, Executor executorIn, boolean java64bit, RegionRenderCacheBuilder fixedBuilderIn, int countRenderBuildersIn) {
        this.field_228893_j_ = worldIn;
        this.field_228894_k_ = worldRendererIn;
        int i2 = Math.max(1, (int)((double)Runtime.getRuntime().maxMemory() * 0.3) / (RenderType.func_228661_n_().stream().mapToInt(RenderType::func_228662_o_).sum() * 4) - 1);
        int j2 = Runtime.getRuntime().availableProcessors();
        int k2 = java64bit ? j2 : Math.min(j2, 4);
        int l2 = Math.max(1, Math.min(k2, i2));
        if (countRenderBuildersIn > 0) {
            l2 = countRenderBuildersIn;
        }
        this.field_228890_g_ = fixedBuilderIn;
        ArrayList list = Lists.newArrayListWithExpectedSize((int)l2);
        try {
            for (int i1 = 0; i1 < l2; ++i1) {
                list.add(new RegionRenderCacheBuilder());
            }
        }
        catch (OutOfMemoryError outofmemoryerror) {
            field_178523_a.warn("Allocated only {}/{} buffers", (Object)list.size(), (Object)l2);
            int j1 = Math.min(list.size() * 2 / 3, list.size() - 1);
            for (int k1 = 0; k1 < j1; ++k1) {
                list.remove(list.size() - 1);
            }
            System.gc();
        }
        this.field_228886_c_ = Queues.newConcurrentLinkedQueue((Iterable)list);
        this.countRenderBuilders = this.field_228889_f_ = this.field_228886_c_.size();
        this.field_228892_i_ = executorIn;
        this.field_228891_h_ = DelegatedTaskExecutor.func_213144_a((Executor)executorIn, (String)"Chunk Renderer");
        this.field_228891_h_.func_212871_a_(() -> this.func_228909_h_());
    }

    public void func_228895_a_(World worldIn) {
        this.field_228893_j_ = worldIn;
    }

    private void func_228909_h_() {
        ChunkRender.ChunkRenderTask chunkrenderdispatcher$chunkrender$chunkrendertask;
        if (!this.field_228886_c_.isEmpty() && (chunkrenderdispatcher$chunkrender$chunkrendertask = (ChunkRender.ChunkRenderTask)this.field_228885_b_.poll()) != null) {
            RegionRenderCacheBuilder regionrendercachebuilder = (RegionRenderCacheBuilder)this.field_228886_c_.poll();
            if (regionrendercachebuilder == null) {
                this.field_228885_b_.add(chunkrenderdispatcher$chunkrender$chunkrendertask);
                return;
            }
            this.field_228888_e_ = this.field_228885_b_.size();
            this.field_228889_f_ = this.field_228886_c_.size();
            ((CompletableFuture)CompletableFuture.runAsync(() -> {}, this.field_228892_i_).thenCompose(p_228901_2_ -> chunkrenderdispatcher$chunkrender$chunkrendertask.func_225618_a_(regionrendercachebuilder))).whenComplete((p_228898_2_, p_228898_3_) -> {
                if (p_228898_3_ != null) {
                    CrashReport crashreport = CrashReport.func_85055_a((Throwable)p_228898_3_, (String)"Batching chunks");
                    Minecraft.func_71410_x().func_71404_a(Minecraft.func_71410_x().func_71396_d(crashreport));
                } else {
                    this.field_228891_h_.func_212871_a_(() -> {
                        if (p_228898_2_ == ChunkTaskResult.SUCCESSFUL) {
                            regionrendercachebuilder.func_228365_a_();
                        } else {
                            regionrendercachebuilder.func_228367_b_();
                        }
                        this.field_228886_c_.add(regionrendercachebuilder);
                        this.field_228889_f_ = this.field_228886_c_.size();
                        this.func_228909_h_();
                    });
                }
            });
        }
    }

    public String func_178504_a() {
        return String.format("pC: %03d, pU: %02d, aB: %02d", this.field_228888_e_, this.field_228887_d_.size(), this.field_228889_f_);
    }

    public void func_217669_a(Vector3d posIn) {
        this.field_217672_l = posIn;
    }

    public Vector3d func_217671_b() {
        return this.field_217672_l;
    }

    public boolean func_228908_d_() {
        Runnable runnable;
        boolean flag = false;
        while ((runnable = (Runnable)this.field_228887_d_.poll()) != null) {
            runnable.run();
            flag = true;
        }
        return flag;
    }

    public void func_228902_a_(ChunkRender chunkRenderIn) {
        chunkRenderIn.func_228936_k_();
    }

    public void func_178514_b() {
        this.func_178513_e();
    }

    public void func_228900_a_(ChunkRender.ChunkRenderTask renderTaskIn) {
        this.field_228891_h_.func_212871_a_(() -> {
            this.field_228885_b_.offer(renderTaskIn);
            this.field_228888_e_ = this.field_228885_b_.size();
            this.func_228909_h_();
        });
    }

    public CompletableFuture<Void> func_228896_a_(BufferBuilder bufferBuilderIn, VertexBuffer vertexBufferIn) {
        return CompletableFuture.runAsync(() -> {}, this.field_228887_d_::add).thenCompose(p_228897_3_ -> this.func_228904_b_(bufferBuilderIn, vertexBufferIn));
    }

    private CompletableFuture<Void> func_228904_b_(BufferBuilder bufferBuilderIn, VertexBuffer vertexBufferIn) {
        return vertexBufferIn.func_227878_b_(bufferBuilderIn);
    }

    private void func_178513_e() {
        while (!this.field_228885_b_.isEmpty()) {
            ChunkRender.ChunkRenderTask chunkrenderdispatcher$chunkrender$chunkrendertask = (ChunkRender.ChunkRenderTask)this.field_228885_b_.poll();
            if (chunkrenderdispatcher$chunkrender$chunkrendertask == null) continue;
            chunkrenderdispatcher$chunkrender$chunkrendertask.func_225617_a_();
        }
        this.field_228888_e_ = 0;
    }

    public boolean func_188247_f() {
        return this.field_228888_e_ == 0 && this.field_228887_d_.isEmpty();
    }

    public void func_188244_g() {
        this.func_178513_e();
        this.field_228891_h_.close();
        this.field_228886_c_.clear();
    }

    public void pauseChunkUpdates() {
        long timeStartMs = System.currentTimeMillis();
        if (this.listPausedBuilders.size() > 0) {
            return;
        }
        while (this.listPausedBuilders.size() != this.countRenderBuilders) {
            this.func_228908_d_();
            RegionRenderCacheBuilder builder = (RegionRenderCacheBuilder)this.field_228886_c_.poll();
            if (builder != null) {
                this.listPausedBuilders.add(builder);
            }
            if (System.currentTimeMillis() <= timeStartMs + 1000L) continue;
            break;
        }
    }

    public void resumeChunkUpdates() {
        this.field_228886_c_.addAll(this.listPausedBuilders);
        this.listPausedBuilders.clear();
    }

    public boolean updateChunkNow(ChunkRender renderChunk) {
        this.func_228902_a_(renderChunk);
        return true;
    }

    public boolean updateChunkLater(ChunkRender renderChunk) {
        if (this.field_228886_c_.isEmpty()) {
            return false;
        }
        renderChunk.func_228929_a_(this);
        return true;
    }

    public boolean updateTransparencyLater(ChunkRender renderChunk) {
        if (this.field_228886_c_.isEmpty()) {
            return false;
        }
        return renderChunk.func_228925_a_((RenderType)RenderTypes.TRANSLUCENT, this);
    }

    static /* synthetic */ World access$000(ChunkRenderDispatcher x0) {
        return x0.field_228893_j_;
    }

    static /* synthetic */ boolean access$200() {
        return FORGE;
    }

    static /* synthetic */ WorldRenderer access$300(ChunkRenderDispatcher x0) {
        return x0.field_228894_k_;
    }

    static /* synthetic */ RegionRenderCacheBuilder access$400(ChunkRenderDispatcher x0) {
        return x0.field_228890_g_;
    }

    static /* synthetic */ boolean access$1000() {
        return FORGE_CAN_RENDER_IN_LAYER_FS;
    }

    static /* synthetic */ boolean access$1100() {
        return FORGE_SET_RENDER_LAYER;
    }

    static /* synthetic */ boolean access$1600() {
        return FORGE_CAN_RENDER_IN_LAYER_BS;
    }
}

