/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelManager;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.optifine.Config;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorForge;
import net.optifine.shaders.Shaders;

public class ItemFrameRenderer
extends EntityRenderer<ItemFrameEntity> {
    private static final ModelResourceLocation field_209585_f = new ModelResourceLocation("item_frame", "map=false");
    private static final ModelResourceLocation field_209586_g = new ModelResourceLocation("item_frame", "map=true");
    private final Minecraft field_147917_g = Minecraft.func_71410_x();
    private final ItemRenderer field_177074_h;
    private static double itemRenderDistanceSq = 4096.0;

    public ItemFrameRenderer(EntityRendererManager renderManagerIn, ItemRenderer itemRendererIn) {
        super(renderManagerIn);
        this.field_177074_h = itemRendererIn;
    }

    public void func_225623_a_(ItemFrameEntity entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        ItemStack itemstack;
        super.func_225623_a_((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        matrixStackIn.func_227860_a_();
        Direction direction = entityIn.func_174811_aO();
        Vector3d vector3d = this.func_225627_b_(entityIn, partialTicks);
        matrixStackIn.func_227861_a_(-vector3d.func_82615_a(), -vector3d.func_82617_b(), -vector3d.func_82616_c());
        double d0 = 0.46875;
        matrixStackIn.func_227861_a_((double)direction.func_82601_c() * 0.46875, (double)direction.func_96559_d() * 0.46875, (double)direction.func_82599_e() * 0.46875);
        matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(entityIn.field_70125_A));
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - entityIn.field_70177_z));
        boolean flag = entityIn.func_82150_aj();
        if (!flag) {
            BlockRendererDispatcher blockrendererdispatcher = this.field_147917_g.func_175602_ab();
            ModelManager modelmanager = blockrendererdispatcher.func_175023_a().func_178126_b();
            ModelResourceLocation modelresourcelocation = entityIn.func_82335_i().func_77973_b() instanceof FilledMapItem ? field_209586_g : field_209585_f;
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(-0.5, -0.5, -0.5);
            blockrendererdispatcher.func_175019_b().func_228804_a_(matrixStackIn.func_227866_c_(), bufferIn.getBuffer(Atlases.func_228782_g_()), (BlockState)null, modelmanager.func_174953_a(modelresourcelocation), 1.0f, 1.0f, 1.0f, packedLightIn, OverlayTexture.field_229196_a_);
            matrixStackIn.func_227865_b_();
        }
        if (!(itemstack = entityIn.func_82335_i()).func_190926_b()) {
            boolean flag1 = itemstack.func_77973_b() instanceof FilledMapItem;
            if (flag) {
                matrixStackIn.func_227861_a_(0.0, 0.0, 0.5);
            } else {
                matrixStackIn.func_227861_a_(0.0, 0.0, 0.4375);
            }
            int i2 = flag1 ? entityIn.func_82333_j() % 4 * 2 : entityIn.func_82333_j();
            matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)i2 * 360.0f / 8.0f));
            if (!Reflector.postForgeBusEvent(Reflector.RenderItemInFrameEvent_Constructor, entityIn, this, matrixStackIn, bufferIn, packedLightIn)) {
                if (flag1) {
                    matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
                    float f2 = 0.0078125f;
                    matrixStackIn.func_227862_a_(0.0078125f, 0.0078125f, 0.0078125f);
                    matrixStackIn.func_227861_a_(-64.0, -64.0, 0.0);
                    MapData mapdata = ReflectorForge.getMapData((ItemStack)itemstack, (World)entityIn.field_70170_p);
                    matrixStackIn.func_227861_a_(0.0, 0.0, -1.0);
                    if (mapdata != null) {
                        this.field_147917_g.field_71460_t.func_147701_i().func_228086_a_(matrixStackIn, bufferIn, mapdata, true, packedLightIn);
                    }
                } else {
                    matrixStackIn.func_227862_a_(0.5f, 0.5f, 0.5f);
                    if (this.isRenderItem(entityIn)) {
                        this.field_177074_h.func_229110_a_(itemstack, ItemCameraTransforms.TransformType.FIXED, packedLightIn, OverlayTexture.field_229196_a_, matrixStackIn, bufferIn);
                    }
                }
            }
        }
        matrixStackIn.func_227865_b_();
    }

    public Vector3d func_225627_b_(ItemFrameEntity entityIn, float partialTicks) {
        return new Vector3d((double)((float)entityIn.func_174811_aO().func_82601_c() * 0.3f), -0.25, (double)((float)entityIn.func_174811_aO().func_82599_e() * 0.3f));
    }

    public ResourceLocation func_110775_a(ItemFrameEntity entity) {
        return AtlasTexture.field_110575_b;
    }

    protected boolean func_177070_b(ItemFrameEntity entity) {
        if (Minecraft.func_71382_s() && !entity.func_82335_i().func_190926_b() && entity.func_82335_i().func_82837_s() && this.field_76990_c.field_147941_i == entity) {
            double d0 = this.field_76990_c.func_229099_b_((Entity)entity);
            float f2 = entity.func_226273_bm_() ? 32.0f : 64.0f;
            return d0 < (double)(f2 * f2);
        }
        return false;
    }

    protected void func_225629_a_(ItemFrameEntity entityIn, ITextComponent displayNameIn, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        super.func_225629_a_((Entity)entityIn, entityIn.func_82335_i().func_200301_q(), matrixStackIn, bufferIn, packedLightIn);
    }

    private boolean isRenderItem(ItemFrameEntity itemFrame) {
        Entity viewEntity;
        double distSq;
        if (Shaders.isShadowPass) {
            return false;
        }
        return Config.zoomMode || !((distSq = itemFrame.func_70092_e((viewEntity = this.field_147917_g.func_175606_aa()).func_226277_ct_(), viewEntity.func_226278_cu_(), viewEntity.func_226281_cx_())) > itemRenderDistanceSq);
    }

    public static void updateItemRenderDistance() {
        Minecraft mc = Minecraft.func_71410_x();
        double fov = Config.limit(mc.field_71474_y.field_74334_X, 1.0, 120.0);
        double itemRenderDistance = Math.max(6.0 * (double)mc.func_228018_at_().func_198083_n() / fov, 16.0);
        itemRenderDistanceSq = itemRenderDistance * itemRenderDistance;
    }
}

