/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity.layers;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.optifine.Config;
import net.optifine.CustomItems;
import net.optifine.reflect.Reflector;

public class BipedArmorLayer<T extends LivingEntity, M extends BipedModel<T>, A extends BipedModel<T>>
extends LayerRenderer<T, M> {
    private static final Map<String, ResourceLocation> field_177191_j = Maps.newHashMap();
    private final A field_177189_c;
    private final A field_177186_d;

    public BipedArmorLayer(IEntityRenderer<T, M> rendererIn, A modelLeggingsIn, A modelArmorIn) {
        super(rendererIn);
        this.field_177189_c = modelLeggingsIn;
        this.field_177186_d = modelArmorIn;
    }

    public void func_225628_a_(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        this.func_241739_a_(matrixStackIn, bufferIn, entitylivingbaseIn, EquipmentSlotType.CHEST, packedLightIn, this.func_241736_a_(EquipmentSlotType.CHEST));
        this.func_241739_a_(matrixStackIn, bufferIn, entitylivingbaseIn, EquipmentSlotType.LEGS, packedLightIn, this.func_241736_a_(EquipmentSlotType.LEGS));
        this.func_241739_a_(matrixStackIn, bufferIn, entitylivingbaseIn, EquipmentSlotType.FEET, packedLightIn, this.func_241736_a_(EquipmentSlotType.FEET));
        this.func_241739_a_(matrixStackIn, bufferIn, entitylivingbaseIn, EquipmentSlotType.HEAD, packedLightIn, this.func_241736_a_(EquipmentSlotType.HEAD));
    }

    private void func_241739_a_(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, T livingEntityIn, EquipmentSlotType slotIn, int packedLightIn, A modelIn) {
        ArmorItem armoritem;
        ItemStack itemstack = livingEntityIn.func_184582_a(slotIn);
        if (itemstack.func_77973_b() instanceof ArmorItem && (armoritem = (ArmorItem)itemstack.func_77973_b()).func_185083_B_() == slotIn) {
            if (Reflector.ForgeHooksClient.exists()) {
                modelIn = this.getArmorModelHook(livingEntityIn, itemstack, slotIn, modelIn);
            }
            ((BipedModel)this.func_215332_c()).func_217148_a(modelIn);
            this.func_188359_a(modelIn, slotIn);
            boolean flag = this.func_188363_b(slotIn);
            boolean flag1 = itemstack.func_77962_s();
            if (armoritem instanceof IDyeableArmorItem) {
                int i2 = ((IDyeableArmorItem)armoritem).func_200886_f(itemstack);
                float f2 = (float)(i2 >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(i2 >> 8 & 0xFF) / 255.0f;
                float f22 = (float)(i2 & 0xFF) / 255.0f;
                this.renderModel(matrixStackIn, bufferIn, packedLightIn, flag1, modelIn, f2, f1, f22, this.getArmorResource(livingEntityIn, itemstack, slotIn, null));
                this.renderModel(matrixStackIn, bufferIn, packedLightIn, flag1, modelIn, 1.0f, 1.0f, 1.0f, this.getArmorResource(livingEntityIn, itemstack, slotIn, "overlay"));
            } else {
                this.renderModel(matrixStackIn, bufferIn, packedLightIn, flag1, modelIn, 1.0f, 1.0f, 1.0f, this.getArmorResource(livingEntityIn, itemstack, slotIn, null));
            }
        }
    }

    protected void func_188359_a(A modelIn, EquipmentSlotType slotIn) {
        modelIn.func_178719_a(false);
        switch (1.$SwitchMap$net$minecraft$inventory$EquipmentSlotType[slotIn.ordinal()]) {
            case 1: {
                ((BipedModel)modelIn).field_78116_c.field_78806_j = true;
                ((BipedModel)modelIn).field_178720_f.field_78806_j = true;
                break;
            }
            case 2: {
                ((BipedModel)modelIn).field_78115_e.field_78806_j = true;
                ((BipedModel)modelIn).field_178723_h.field_78806_j = true;
                ((BipedModel)modelIn).field_178724_i.field_78806_j = true;
                break;
            }
            case 3: {
                ((BipedModel)modelIn).field_78115_e.field_78806_j = true;
                ((BipedModel)modelIn).field_178721_j.field_78806_j = true;
                ((BipedModel)modelIn).field_178722_k.field_78806_j = true;
                break;
            }
            case 4: {
                ((BipedModel)modelIn).field_178721_j.field_78806_j = true;
                ((BipedModel)modelIn).field_178722_k.field_78806_j = true;
            }
        }
    }

    private void func_241738_a_(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, ArmorItem itemIn, boolean hasEffect, A bipedModelIn, boolean isLegSlot, float red, float green, float blue, @Nullable String suffixIn) {
        this.renderModel(matrixStackIn, bufferIn, packedLightIn, hasEffect, bipedModelIn, red, green, blue, this.func_241737_a_(itemIn, isLegSlot, suffixIn));
    }

    private void renderModel(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, boolean hasEffect, A bipedModelIn, float red, float green, float blue, ResourceLocation armorResource) {
        IVertexBuilder ivertexbuilder = ItemRenderer.func_239386_a_((IRenderTypeBuffer)bufferIn, (RenderType)RenderType.func_239263_a_((ResourceLocation)armorResource), (boolean)false, (boolean)hasEffect);
        bipedModelIn.func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, red, green, blue, 1.0f);
    }

    private A func_241736_a_(EquipmentSlotType slotIn) {
        return (A)(this.func_188363_b(slotIn) ? this.field_177189_c : this.field_177186_d);
    }

    private boolean func_188363_b(EquipmentSlotType slotIn) {
        return slotIn == EquipmentSlotType.LEGS;
    }

    private ResourceLocation func_241737_a_(ArmorItem itemIn, boolean isLegSlot, @Nullable String suffixIn) {
        String s2 = "textures/models/armor/" + itemIn.func_200880_d().func_200897_d() + "_layer_" + (isLegSlot ? 2 : 1) + (suffixIn == null ? "" : "_" + suffixIn) + ".png";
        return field_177191_j.computeIfAbsent(s2, ResourceLocation::new);
    }

    protected A getArmorModelHook(T entity, ItemStack itemStack, EquipmentSlotType slot, A model) {
        if (Reflector.ForgeHooksClient_getArmorModel.exists()) {
            return (A)((BipedModel)Reflector.ForgeHooksClient_getArmorModel.call(entity, itemStack, slot, model));
        }
        return model;
    }

    public ResourceLocation getArmorResource(Entity entity, ItemStack stack, EquipmentSlotType slot, String type) {
        ResourceLocation resourcelocation;
        ArmorItem item = (ArmorItem)stack.func_77973_b();
        String texture = item.func_200880_d().func_200897_d();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String s1 = String.format("%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, this.func_188363_b(slot) ? 2 : 1, type == null ? "" : String.format("_%s", type));
        if (Reflector.ForgeHooksClient_getArmorTexture.exists()) {
            s1 = Reflector.callString(Reflector.ForgeHooksClient_getArmorTexture, entity, stack, s1, slot, type);
        }
        if ((resourcelocation = (ResourceLocation)field_177191_j.get(s1)) == null) {
            resourcelocation = new ResourceLocation(s1);
            field_177191_j.put(s1, resourcelocation);
        }
        if (Config.isCustomItems()) {
            resourcelocation = CustomItems.getCustomArmorTexture((ItemStack)stack, (EquipmentSlotType)slot, (String)type, (ResourceLocation)resourcelocation);
        }
        return resourcelocation;
    }
}

