/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverride;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.SpriteMap;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.optifine.Config;
import net.optifine.ItemOverrideCache;

public class ItemOverrideList {
    public static final ItemOverrideList field_188022_a = new ItemOverrideList();
    private final List<ItemOverride> field_188023_b = Lists.newArrayList();
    private final List<IBakedModel> field_209582_c;
    private ItemOverrideCache itemOverrideCache;
    public static ResourceLocation lastModelLocation = null;

    private ItemOverrideList() {
        this.field_209582_c = Collections.emptyList();
    }

    public ItemOverrideList(ModelBakery modelBakeryIn, BlockModel blockModelIn, Function<ResourceLocation, IUnbakedModel> modelGetter, List<ItemOverride> itemOverridesIn) {
        this(modelBakeryIn, (IUnbakedModel)blockModelIn, modelGetter, arg_0 -> ((SpriteMap)modelBakeryIn.getSpriteMap()).func_229151_a_(arg_0), itemOverridesIn);
    }

    public ItemOverrideList(ModelBakery modelBakeryIn, IUnbakedModel blockModelIn, Function<ResourceLocation, IUnbakedModel> modelGetter, Function<RenderMaterial, TextureAtlasSprite> textureGetter, List<ItemOverride> itemOverridesIn) {
        this.field_209582_c = itemOverridesIn.stream().map(p_217649_3_ -> {
            IUnbakedModel iunbakedmodel = (IUnbakedModel)modelGetter.apply(p_217649_3_.func_188026_a());
            return Objects.equals(iunbakedmodel, blockModelIn) ? null : modelBakeryIn.getBakedModel(p_217649_3_.func_188026_a(), (IModelTransform)ModelRotation.X0_Y0, textureGetter);
        }).collect(Collectors.toList());
        Collections.reverse(this.field_209582_c);
        for (int i2 = itemOverridesIn.size() - 1; i2 >= 0; --i2) {
            this.field_188023_b.add(itemOverridesIn.get(i2));
        }
        if (this.field_188023_b.size() > 65) {
            this.itemOverrideCache = ItemOverrideCache.make(this.field_188023_b);
        }
    }

    @Nullable
    public IBakedModel func_239290_a_(IBakedModel model, ItemStack stack, @Nullable ClientWorld worldIn, @Nullable LivingEntity entityIn) {
        boolean customItems = Config.isCustomItems();
        if (customItems) {
            lastModelLocation = null;
        }
        if (!this.field_188023_b.isEmpty()) {
            Integer modelIndex;
            if (this.itemOverrideCache != null && (modelIndex = this.itemOverrideCache.getModelIndex(stack, worldIn, entityIn)) != null) {
                int indexCached = modelIndex;
                if (indexCached >= 0 && indexCached < this.field_209582_c.size()) {
                    IBakedModel modelCached;
                    if (customItems) {
                        lastModelLocation = ((ItemOverride)this.field_188023_b.get(indexCached)).func_188026_a();
                    }
                    if ((modelCached = (IBakedModel)this.field_209582_c.get(indexCached)) != null) {
                        return modelCached;
                    }
                }
                return model;
            }
            for (int i2 = 0; i2 < this.field_188023_b.size(); ++i2) {
                ItemOverride itemoverride = (ItemOverride)this.field_188023_b.get(i2);
                if (!itemoverride.func_239289_a_(stack, worldIn, entityIn)) continue;
                IBakedModel ibakedmodel = (IBakedModel)this.field_209582_c.get(i2);
                if (customItems) {
                    lastModelLocation = itemoverride.func_188026_a();
                }
                if (this.itemOverrideCache != null) {
                    this.itemOverrideCache.putModelIndex(stack, worldIn, entityIn, i2);
                }
                if (ibakedmodel == null) {
                    return model;
                }
                return ibakedmodel;
            }
            if (this.itemOverrideCache != null) {
                this.itemOverrideCache.putModelIndex(stack, worldIn, entityIn, ItemOverrideCache.INDEX_NONE);
            }
        }
        return model;
    }

    public ImmutableList<ItemOverride> getOverrides() {
        return ImmutableList.copyOf((Collection)this.field_188023_b);
    }
}

