/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.SpriteAwareVertexBuilder;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.MipmapGenerator;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.PngSizeInfo;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.data.AnimationFrame;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.extensions.IForgeTextureAtlasSprite;
import net.optifine.Config;
import net.optifine.SmartAnimations;
import net.optifine.shaders.Shaders;
import net.optifine.shaders.ShadersTextureType;
import net.optifine.texture.IColorBlender;
import net.optifine.util.CounterInt;
import net.optifine.util.TextureUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class TextureAtlasSprite
implements AutoCloseable,
IForgeTextureAtlasSprite {
    private final AtlasTexture field_229225_b_;
    private final Info field_229226_c_;
    private final AnimationMetadataSection field_110982_k;
    protected final NativeImage[] field_195670_c;
    private final int[] field_195671_d;
    private final int[] field_195672_e;
    @Nullable
    private final InterpolationData field_229227_g_;
    private final int field_110975_c;
    private final int field_110974_d;
    private final float field_110979_l;
    private final float field_110980_m;
    private final float field_110977_n;
    private final float field_110978_o;
    private int field_110973_g;
    private int field_110983_h;
    private int indexInMap = -1;
    public float baseU;
    public float baseV;
    public int sheetWidth;
    public int sheetHeight;
    public int glSpriteTextureId = -1;
    public TextureAtlasSprite spriteSingle = null;
    public boolean isSpriteSingle = false;
    public static final String SUFFIX_SPRITE_SINGLE = ".sprite_single";
    public int mipmapLevels = 0;
    public TextureAtlasSprite spriteNormal = null;
    public TextureAtlasSprite spriteSpecular = null;
    public ShadersTextureType spriteShadersType = null;
    public TextureAtlasSprite spriteEmissive = null;
    public boolean isSpriteEmissive = false;
    private int animationIndex = -1;
    private boolean animationActive = false;
    private boolean usesParentAnimationTime = false;
    private boolean terrain;
    private boolean shaders;
    private boolean multiTexture;
    private IResourceManager resourceManager;

    public TextureAtlasSprite(ResourceLocation name) {
        this.field_229225_b_ = null;
        this.field_229226_c_ = new Info(name, 0, 0, null);
        this.field_110982_k = null;
        this.field_195670_c = null;
        this.field_195671_d = new int[0];
        this.field_195672_e = new int[0];
        this.field_229227_g_ = null;
        this.field_110975_c = 0;
        this.field_110974_d = 0;
        this.field_110979_l = 0.0f;
        this.field_110980_m = 0.0f;
        this.field_110977_n = 0.0f;
        this.field_110978_o = 0.0f;
    }

    private TextureAtlasSprite(TextureAtlasSprite parent) {
        this.field_229225_b_ = parent.field_229225_b_;
        Info infoParent = parent.field_229226_c_;
        ResourceLocation locParent = infoParent.func_229248_a_();
        ResourceLocation loc = new ResourceLocation(locParent.func_110624_b(), locParent.func_110623_a() + ".sprite_single");
        int w2 = infoParent.func_229250_b_();
        int h2 = infoParent.func_229252_c_();
        AnimationMetadataSection animMeta = infoParent.getSpriteAnimationMetadata();
        this.field_229226_c_ = new Info(loc, w2, h2, animMeta);
        this.field_110982_k = parent.field_110982_k;
        this.usesParentAnimationTime = true;
        this.field_195670_c = parent.field_195670_c;
        this.field_195671_d = parent.field_195671_d;
        this.field_195672_e = parent.field_195672_e;
        this.field_229227_g_ = parent.field_229227_g_ != null ? new InterpolationData(this, InterpolationData.access$000((InterpolationData)parent.field_229227_g_), null) : null;
        this.field_110975_c = 0;
        this.field_110974_d = 0;
        this.field_110979_l = 0.0f;
        this.field_110980_m = 1.0f;
        this.field_110977_n = 0.0f;
        this.field_110978_o = 1.0f;
        this.field_110973_g = parent.field_110973_g;
        this.field_110983_h = parent.field_110983_h;
        this.indexInMap = parent.indexInMap;
        this.baseU = parent.baseU;
        this.baseV = parent.baseV;
        this.sheetWidth = parent.sheetWidth;
        this.sheetHeight = parent.sheetHeight;
        this.isSpriteSingle = true;
        this.mipmapLevels = parent.mipmapLevels;
        this.animationIndex = parent.animationIndex;
        this.animationActive = parent.animationActive;
    }

    protected TextureAtlasSprite(AtlasTexture atlasTextureIn, Info spriteInfoIn, int mipmapLevelsIn, int atlasWidthIn, int atlasHeightIn, int xIn, int yIn, NativeImage imageIn) {
        this(atlasTextureIn, spriteInfoIn, mipmapLevelsIn, atlasWidthIn, atlasHeightIn, xIn, yIn, imageIn, null);
    }

    protected TextureAtlasSprite(AtlasTexture atlasTextureIn, Info spriteInfoIn, int mipmapLevelsIn, int atlasWidthIn, int atlasHeightIn, int xIn, int yIn, NativeImage imageIn, ShadersTextureType spriteShadersTypeIn) {
        int widthScaled;
        NativeImage imageScaled;
        this.field_229225_b_ = atlasTextureIn;
        AnimationMetadataSection animationmetadatasection = Info.access$200((Info)spriteInfoIn);
        int i2 = Info.access$300((Info)spriteInfoIn);
        int j2 = Info.access$400((Info)spriteInfoIn);
        this.field_110975_c = xIn;
        this.field_110974_d = yIn;
        this.field_110979_l = (float)xIn / (float)atlasWidthIn;
        this.field_110980_m = (float)(xIn + i2) / (float)atlasWidthIn;
        this.field_110977_n = (float)yIn / (float)atlasHeightIn;
        this.field_110978_o = (float)(yIn + j2) / (float)atlasHeightIn;
        if (Info.access$500((Info)spriteInfoIn) > 1.0 && (imageScaled = TextureUtils.scaleImage((NativeImage)imageIn, (int)(widthScaled = (int)Math.round((double)imageIn.func_195702_a() * Info.access$500((Info)spriteInfoIn))))) != imageIn) {
            imageIn.close();
            imageIn = imageScaled;
        }
        this.spriteShadersType = spriteShadersTypeIn;
        IColorBlender colorBlender = this.field_229225_b_.getShadersColorBlender(this.spriteShadersType);
        if (this.spriteShadersType == null && !spriteInfoIn.func_229248_a_().func_110623_a().endsWith("_leaves")) {
            this.fixTransparentColor(imageIn);
        }
        NativeImage imageInF = imageIn;
        int k2 = imageIn.func_195702_a() / animationmetadatasection.func_229302_b_(i2);
        int l2 = imageIn.func_195714_b() / animationmetadatasection.func_229301_a_(j2);
        if (animationmetadatasection.func_110473_c() > 0) {
            int i1 = (Integer)animationmetadatasection.func_130073_e().stream().max(Integer::compareTo).get() + 1;
            this.field_195671_d = new int[i1];
            this.field_195672_e = new int[i1];
            Arrays.fill(this.field_195671_d, -1);
            Arrays.fill(this.field_195672_e, -1);
            Iterator iterator = animationmetadatasection.func_130073_e().iterator();
            while (iterator.hasNext()) {
                int l1;
                int j1 = (Integer)iterator.next();
                if (j1 >= k2 * l2) {
                    throw new RuntimeException("invalid frameindex " + j1);
                }
                int k1 = j1 / k2;
                this.field_195671_d[j1] = l1 = j1 % k2;
                this.field_195672_e[j1] = k1;
            }
        } else {
            ArrayList list = Lists.newArrayList();
            int i22 = k2 * l2;
            this.field_195671_d = new int[i22];
            this.field_195672_e = new int[i22];
            for (int j22 = 0; j22 < l2; ++j22) {
                int k22 = 0;
                while (k22 < k2) {
                    int l22 = j22 * k2 + k22;
                    this.field_195671_d[l22] = k22++;
                    this.field_195672_e[l22] = j22;
                    list.add(new AnimationFrame(l22, -1));
                }
            }
            animationmetadatasection = new AnimationMetadataSection((List)list, i2, j2, animationmetadatasection.func_110469_d(), animationmetadatasection.func_177219_e());
        }
        this.field_229226_c_ = new Info(Info.access$600((Info)spriteInfoIn), i2, j2, animationmetadatasection);
        this.field_110982_k = animationmetadatasection;
        try {
            try {
                this.field_195670_c = MipmapGenerator.generateMipmaps((NativeImage)imageIn, (int)mipmapLevelsIn, (IColorBlender)colorBlender);
            }
            catch (Throwable throwable) {
                CrashReport crashreport1 = CrashReport.func_85055_a((Throwable)throwable, (String)"Generating mipmaps for frame");
                CrashReportCategory crashreportcategory1 = crashreport1.func_85058_a("Frame being iterated");
                crashreportcategory1.func_189529_a("First frame", () -> {
                    StringBuilder stringbuilder = new StringBuilder();
                    if (stringbuilder.length() > 0) {
                        stringbuilder.append(", ");
                    }
                    stringbuilder.append(imageInF.func_195702_a()).append("x").append(imageInF.func_195714_b());
                    return stringbuilder.toString();
                });
                throw new ReportedException(crashreport1);
            }
        }
        catch (Throwable throwable1) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable1, (String)"Applying mipmap");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Sprite being mipmapped");
            crashreportcategory.func_189529_a("Sprite name", () -> this.func_195668_m().toString());
            crashreportcategory.func_189529_a("Sprite size", () -> this.func_94211_a() + " x " + this.func_94216_b());
            crashreportcategory.func_189529_a("Sprite frames", () -> this.func_110970_k() + " frames");
            crashreportcategory.func_71507_a("Mipmap levels", (Object)mipmapLevelsIn);
            throw new ReportedException(crashreport);
        }
        this.field_229227_g_ = animationmetadatasection.func_177219_e() ? new InterpolationData(this, spriteInfoIn, mipmapLevelsIn, null) : null;
        this.mipmapLevels = mipmapLevelsIn;
        this.baseU = Math.min(this.field_110979_l, this.field_110980_m);
        this.baseV = Math.min(this.field_110977_n, this.field_110978_o);
        this.sheetWidth = atlasWidthIn;
        this.sheetHeight = atlasHeightIn;
    }

    private void func_195659_d(int index) {
        int i2 = this.field_195671_d[index] * Info.access$300((Info)this.field_229226_c_);
        int j2 = this.field_195672_e[index] * Info.access$400((Info)this.field_229226_c_);
        this.func_195667_a(i2, j2, this.field_195670_c);
    }

    private void func_195667_a(int xOffsetIn, int yOffsetIn, NativeImage[] framesIn) {
        boolean blur = false;
        boolean clamp = this.isSpriteSingle;
        for (int i2 = 0; i2 < framesIn.length && this.func_94211_a() >> i2 > 0 && this.func_94216_b() >> i2 > 0; ++i2) {
            framesIn[i2].func_227789_a_(i2, this.field_110975_c >> i2, this.field_110974_d >> i2, xOffsetIn >> i2, yOffsetIn >> i2, Info.access$300((Info)this.field_229226_c_) >> i2, Info.access$400((Info)this.field_229226_c_) >> i2, blur, clamp, framesIn.length > 1, false);
        }
    }

    public int func_94211_a() {
        return Info.access$300((Info)this.field_229226_c_);
    }

    public int func_94216_b() {
        return Info.access$400((Info)this.field_229226_c_);
    }

    public float func_94209_e() {
        return this.field_110979_l;
    }

    public float func_94212_f() {
        return this.field_110980_m;
    }

    public float func_94214_a(double u2) {
        float f2 = this.field_110980_m - this.field_110979_l;
        return this.field_110979_l + f2 * (float)u2 / 16.0f;
    }

    public float func_94206_g() {
        return this.field_110977_n;
    }

    public float func_94210_h() {
        return this.field_110978_o;
    }

    public float func_94207_b(double v2) {
        float f2 = this.field_110978_o - this.field_110977_n;
        return this.field_110977_n + f2 * (float)v2 / 16.0f;
    }

    public ResourceLocation func_195668_m() {
        return Info.access$600((Info)this.field_229226_c_);
    }

    public AtlasTexture func_229241_m_() {
        return this.field_229225_b_;
    }

    public int func_110970_k() {
        return this.field_195671_d.length;
    }

    @Override
    public void close() {
        for (NativeImage nativeimage : this.field_195670_c) {
            if (nativeimage == null) continue;
            nativeimage.close();
        }
        if (this.field_229227_g_ != null) {
            this.field_229227_g_.close();
        }
        if (this.spriteSingle != null) {
            // empty if block
        }
        if (this.spriteNormal != null) {
            this.spriteNormal.close();
        }
        if (this.spriteSpecular != null) {
            this.spriteSpecular.close();
        }
    }

    public String toString() {
        int i2 = this.field_195671_d.length;
        return "TextureAtlasSprite{name='" + Info.access$600((Info)this.field_229226_c_) + '\'' + ", frameCount=" + i2 + ", x=" + this.field_110975_c + ", y=" + this.field_110974_d + ", height=" + Info.access$400((Info)this.field_229226_c_) + ", width=" + Info.access$300((Info)this.field_229226_c_) + ", u0=" + this.field_110979_l + ", u1=" + this.field_110980_m + ", v0=" + this.field_110977_n + ", v1=" + this.field_110978_o + '}';
    }

    public boolean func_195662_a(int frameIndex, int pixelX, int pixelY) {
        return (this.field_195670_c[0].func_195709_a(pixelX + this.field_195671_d[frameIndex] * Info.access$300((Info)this.field_229226_c_), pixelY + this.field_195672_e[frameIndex] * Info.access$400((Info)this.field_229226_c_)) >> 24 & 0xFF) == 0;
    }

    public void func_195663_q() {
        this.func_195659_d(0);
    }

    private float func_229228_a_() {
        float f2 = (float)Info.access$300((Info)this.field_229226_c_) / (this.field_110980_m - this.field_110979_l);
        float f1 = (float)Info.access$400((Info)this.field_229226_c_) / (this.field_110978_o - this.field_110977_n);
        return Math.max(f1, f2);
    }

    public float func_229242_p_() {
        return 4.0f / this.func_229228_a_();
    }

    public void func_94219_l() {
        if (this.field_110982_k == null) {
            return;
        }
        boolean bl = this.animationActive = SmartAnimations.isActive() ? SmartAnimations.isSpriteRendered((TextureAtlasSprite)this) : true;
        if (this.field_110982_k.func_110473_c() <= 1) {
            this.animationActive = false;
        }
        if (this.spriteSingle != null && this.spriteSingle.usesParentAnimationTime) {
            this.spriteSingle.field_110983_h = this.field_110983_h;
            this.spriteSingle.field_110973_g = this.field_110973_g;
        }
        if (this.spriteNormal != null && this.spriteNormal.usesParentAnimationTime) {
            this.spriteNormal.field_110983_h = this.field_110983_h;
            this.spriteNormal.field_110973_g = this.field_110973_g;
        }
        if (this.spriteSpecular != null && this.spriteSpecular.usesParentAnimationTime) {
            this.spriteSpecular.field_110983_h = this.field_110983_h;
            this.spriteSpecular.field_110973_g = this.field_110973_g;
        }
        ++this.field_110983_h;
        if (this.field_110983_h >= this.field_110982_k.func_110472_a(this.field_110973_g)) {
            int i2 = this.field_110982_k.func_110468_c(this.field_110973_g);
            int j2 = this.field_110982_k.func_110473_c() == 0 ? this.func_110970_k() : this.field_110982_k.func_110473_c();
            this.field_110973_g = (this.field_110973_g + 1) % j2;
            this.field_110983_h = 0;
            int k2 = this.field_110982_k.func_110468_c(this.field_110973_g);
            if (!this.animationActive) {
                return;
            }
            if (i2 != k2 && k2 >= 0 && k2 < this.func_110970_k()) {
                this.func_195659_d(k2);
            }
        } else if (this.field_229227_g_ != null) {
            if (!this.animationActive) {
                return;
            }
            if (!RenderSystem.isOnRenderThread()) {
                RenderSystem.recordRenderCall(() -> InterpolationData.access$800((InterpolationData)this.field_229227_g_));
            } else {
                InterpolationData.access$800((InterpolationData)this.field_229227_g_);
            }
        }
    }

    public boolean func_130098_m() {
        return this.field_110982_k.func_110473_c() > 1;
    }

    public IVertexBuilder func_229230_a_(IVertexBuilder bufferIn) {
        IRenderTypeBuffer.Impl rtb;
        if (this.func_195668_m() == TextureUtils.LOCATION_SPRITE_EMPTY && (rtb = bufferIn.getRenderTypeBuffer()) != null) {
            return rtb.getDummyBuffer();
        }
        return new SpriteAwareVertexBuilder(bufferIn, this);
    }

    public int getIndexInMap() {
        return this.indexInMap;
    }

    public void updateIndexInMap(CounterInt counterInt) {
        TextureAtlasSprite registeredSprite;
        if (this.indexInMap >= 0) {
            return;
        }
        if (this.field_229225_b_ != null && (registeredSprite = this.field_229225_b_.getRegisteredSprite(this.func_195668_m())) != null) {
            this.indexInMap = registeredSprite.getIndexInMap();
        }
        if (this.indexInMap < 0) {
            this.indexInMap = counterInt.nextValue();
        }
    }

    public int getAnimationIndex() {
        return this.animationIndex;
    }

    public void setAnimationIndex(int animationIndex) {
        this.animationIndex = animationIndex;
        if (this.spriteSingle != null) {
            this.spriteSingle.setAnimationIndex(animationIndex);
        }
        if (this.spriteNormal != null) {
            this.spriteNormal.setAnimationIndex(animationIndex);
        }
        if (this.spriteSpecular != null) {
            this.spriteSpecular.setAnimationIndex(animationIndex);
        }
    }

    public boolean isAnimationActive() {
        return this.animationActive;
    }

    private void fixTransparentColor(NativeImage ni) {
        int[] data = new int[ni.func_195702_a() * ni.func_195714_b()];
        ni.getBufferRGBA().get(data);
        this.fixTransparentColor(data);
        ni.getBufferRGBA().put(data);
    }

    private void fixTransparentColor(int[] data) {
        if (data == null) {
            return;
        }
        long redSum = 0L;
        long greenSum = 0L;
        long blueSum = 0L;
        long count = 0L;
        for (int i2 = 0; i2 < data.length; ++i2) {
            int col = data[i2];
            int alpha = col >> 24 & 0xFF;
            if (alpha < 16) continue;
            int red = col >> 16 & 0xFF;
            int green = col >> 8 & 0xFF;
            int blue = col & 0xFF;
            redSum += (long)red;
            greenSum += (long)green;
            blueSum += (long)blue;
            ++count;
        }
        if (count <= 0L) {
            return;
        }
        int redAvg = (int)(redSum / count);
        int greenAvg = (int)(greenSum / count);
        int blueAvg = (int)(blueSum / count);
        int colAvg = redAvg << 16 | greenAvg << 8 | blueAvg;
        for (int i3 = 0; i3 < data.length; ++i3) {
            int col = data[i3];
            int alpha = col >> 24 & 0xFF;
            if (alpha > 16) continue;
            data[i3] = colAvg;
        }
    }

    public double getSpriteU16(float atlasU) {
        float dU = this.field_110980_m - this.field_110979_l;
        return (atlasU - this.field_110979_l) / dU * 16.0f;
    }

    public double getSpriteV16(float atlasV) {
        float dV = this.field_110978_o - this.field_110977_n;
        return (atlasV - this.field_110977_n) / dV * 16.0f;
    }

    public void bindSpriteTexture() {
        if (this.glSpriteTextureId < 0) {
            this.glSpriteTextureId = TextureUtil.func_225678_a_();
            TextureUtil.func_225681_a_((int)this.glSpriteTextureId, (int)this.mipmapLevels, (int)this.func_94211_a(), (int)this.func_94216_b());
            boolean blend = this.field_229225_b_.isTextureBlend(this.spriteShadersType);
            if (blend) {
                TextureUtils.applyAnisotropicLevel();
            } else {
                GlStateManager.func_227642_a_((int)3553, (int)34046, (float)1.0f);
                int minFilter = this.mipmapLevels > 0 ? 9984 : 9728;
                GlStateManager.func_227677_b_((int)3553, (int)10241, (int)minFilter);
                GlStateManager.func_227677_b_((int)3553, (int)10240, (int)9728);
            }
        }
        TextureUtils.bindTexture(this.glSpriteTextureId);
    }

    public void deleteSpriteTexture() {
        if (this.glSpriteTextureId < 0) {
            return;
        }
        TextureUtil.func_225679_a_((int)this.glSpriteTextureId);
        this.glSpriteTextureId = -1;
    }

    public float toSingleU(float u2) {
        u2 -= this.baseU;
        float ku = (float)this.sheetWidth / (float)this.func_94211_a();
        return u2 *= ku;
    }

    public float toSingleV(float v2) {
        v2 -= this.baseV;
        float kv = (float)this.sheetHeight / (float)this.func_94216_b();
        return v2 *= kv;
    }

    public NativeImage[] getMipmapImages() {
        return this.field_195670_c;
    }

    public AnimationMetadataSection getAnimationMetadata() {
        return this.field_110982_k;
    }

    public int getOriginX() {
        return this.field_110975_c;
    }

    public int getOriginY() {
        return this.field_110974_d;
    }

    public float getUnInterpolatedU(float u2) {
        float f2 = this.field_110980_m - this.field_110979_l;
        return (u2 - this.field_110979_l) / f2 * 16.0f;
    }

    public float getUnInterpolatedV(float v2) {
        float f2 = this.field_110978_o - this.field_110977_n;
        return (v2 - this.field_110977_n) / f2 * 16.0f;
    }

    public TextureAtlasSprite makeSpriteSingle() {
        TextureAtlasSprite ss = new TextureAtlasSprite(this);
        ss.isSpriteSingle = true;
        return ss;
    }

    public TextureAtlasSprite makeSpriteShaders(ShadersTextureType type, int colDef, AnimationMetadataSection parentAnimation) {
        String suffix = type.getSuffix();
        ResourceLocation loc = new ResourceLocation(this.func_195668_m().func_110624_b(), this.func_195668_m().func_110623_a() + suffix);
        ResourceLocation locPng = this.field_229225_b_.func_195420_b(loc);
        TextureAtlasSprite ss = null;
        if (this.resourceManager.func_219533_b(locPng)) {
            try (IResource iresource2 = this.resourceManager.func_199002_a(locPng);){
                NativeImage imageScaled;
                IResource resPngSize = this.resourceManager.func_199002_a(locPng);
                PngSizeInfo pngSize = new PngSizeInfo(locPng.toString(), resPngSize.func_199027_b());
                AnimationMetadataSection animMeta = (AnimationMetadataSection)iresource2.func_199028_a((IMetadataSectionSerializer)AnimationMetadataSection.field_195817_a);
                if (animMeta == null) {
                    animMeta = AnimationMetadataSection.field_229300_b_;
                }
                Pair sizePair = animMeta.func_225641_a_(pngSize.field_188533_a, pngSize.field_188534_b);
                Info infoShaders = new Info(loc, ((Integer)sizePair.getFirst()).intValue(), ((Integer)sizePair.getSecond()).intValue(), animMeta);
                NativeImage image = NativeImage.func_195713_a((InputStream)iresource2.func_199027_b());
                if (image.func_195702_a() != this.func_94211_a() && (imageScaled = TextureUtils.scaleImage((NativeImage)image, (int)this.func_94211_a())) != image) {
                    double scaleFactor = 1.0 * (double)this.func_94211_a() / (double)image.func_195702_a();
                    image.close();
                    image = imageScaled;
                    infoShaders = new Info(loc, (int)((double)((Integer)sizePair.getFirst()).intValue() * scaleFactor), (int)((double)((Integer)sizePair.getSecond()).intValue() * scaleFactor), animMeta);
                }
                ss = new TextureAtlasSprite(this.field_229225_b_, infoShaders, this.mipmapLevels, this.sheetWidth, this.sheetHeight, this.field_110975_c, this.field_110974_d, image, type);
            }
            catch (IOException iresource2) {
                // empty catch block
            }
        }
        if (ss == null) {
            NativeImage image = new NativeImage(this.func_94211_a(), this.func_94216_b(), false);
            int colAbgr = TextureUtils.toAbgr(colDef);
            image.func_195715_a(0, 0, image.func_195702_a(), image.func_195714_b(), colAbgr);
            Info infoShaders = new Info(loc, this.func_94211_a(), this.func_94216_b(), AnimationMetadataSection.field_229300_b_);
            ss = new TextureAtlasSprite(this.field_229225_b_, infoShaders, this.mipmapLevels, this.sheetWidth, this.sheetHeight, this.field_110975_c, this.field_110974_d, image, type);
        }
        if (this.terrain && this.multiTexture && !this.isSpriteSingle) {
            ss.spriteSingle = ss.makeSpriteSingle();
        }
        ss.usesParentAnimationTime = TextureAtlasSprite.matchesTiming((AnimationMetadataSection)ss.field_110982_k, (AnimationMetadataSection)parentAnimation);
        return ss;
    }

    public boolean isTerrain() {
        return this.terrain;
    }

    private void setTerrain(boolean terrainIn) {
        this.terrain = terrainIn;
        this.multiTexture = false;
        this.shaders = false;
        if (this.spriteSingle != null) {
            this.deleteSpriteTexture();
            this.spriteSingle = null;
        }
        if (this.spriteNormal != null) {
            if (this.spriteNormal.spriteSingle != null) {
                this.spriteNormal.deleteSpriteTexture();
            }
            this.spriteNormal.close();
            this.spriteNormal = null;
        }
        if (this.spriteSpecular != null) {
            if (this.spriteSpecular.spriteSingle != null) {
                this.spriteSpecular.deleteSpriteTexture();
            }
            this.spriteSpecular.close();
            this.spriteSpecular = null;
        }
        this.multiTexture = Config.isMultiTexture();
        this.shaders = Config.isShaders();
        if (this.terrain && this.multiTexture && !this.isSpriteSingle) {
            this.spriteSingle = this.makeSpriteSingle();
        }
        if (this.shaders && !this.isSpriteSingle) {
            if (this.spriteNormal == null && Shaders.configNormalMap) {
                this.spriteNormal = this.makeSpriteShaders(ShadersTextureType.NORMAL, -8421377, this.field_110982_k);
            }
            if (this.spriteSpecular == null && Shaders.configSpecularMap) {
                this.spriteSpecular = this.makeSpriteShaders(ShadersTextureType.SPECULAR, 0, this.field_110982_k);
            }
        }
    }

    private static boolean matchesTiming(AnimationMetadataSection am1, AnimationMetadataSection am2) {
        if (am1 == am2) {
            return true;
        }
        if (am1 == null || am2 == null) {
            return false;
        }
        if (am1.func_110469_d() != am2.func_110469_d()) {
            return false;
        }
        if (am1.func_177219_e() != am2.func_177219_e()) {
            return false;
        }
        if (am1.func_110473_c() != am2.func_110473_c()) {
            return false;
        }
        for (int i2 = 0; i2 < am1.func_110473_c(); ++i2) {
            if (am1.func_110472_a(i2) == am2.func_110472_a(i2)) continue;
            return false;
        }
        return true;
    }

    public void update(IResourceManager resourceManager) {
        this.resourceManager = resourceManager;
        this.updateIndexInMap(this.field_229225_b_.getCounterIndexInMap());
        this.setTerrain(this.field_229225_b_.isTerrain());
    }

    public int getPixelRGBA(int frameIndex, int x2, int y2) {
        return this.field_195670_c[0].func_195709_a(x2 + this.field_195671_d[frameIndex] * this.func_94211_a(), y2 + this.field_195672_e[frameIndex] * this.func_94216_b());
    }

    static /* synthetic */ int access$900(TextureAtlasSprite x0) {
        return x0.field_110983_h;
    }

    static /* synthetic */ int access$1000(TextureAtlasSprite x0) {
        return x0.field_110973_g;
    }

    static /* synthetic */ AnimationMetadataSection access$1100(TextureAtlasSprite x0) {
        return x0.field_110982_k;
    }

    static /* synthetic */ Info access$1200(TextureAtlasSprite x0) {
        return x0.field_229226_c_;
    }

    static /* synthetic */ void access$1300(TextureAtlasSprite x0, int x1, int x2, NativeImage[] x3) {
        x0.func_195667_a(x1, x2, x3);
    }

    static /* synthetic */ int[] access$1400(TextureAtlasSprite x0) {
        return x0.field_195671_d;
    }

    static /* synthetic */ int[] access$1500(TextureAtlasSprite x0) {
        return x0.field_195672_e;
    }
}

