/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.crash;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletionException;
import java.util.stream.Collectors;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.optifine.CrashReporter;
import net.optifine.reflect.Reflector;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class CrashReport {
    private static final Logger field_147150_a = LogManager.getLogger();
    private final String field_71513_a;
    private final Throwable field_71511_b;
    private final CrashReportCategory field_85061_c = new CrashReportCategory(this, "System Details");
    private final List<CrashReportCategory> field_71512_c = Lists.newArrayList();
    private File field_71510_d;
    private boolean field_85059_f = true;
    private StackTraceElement[] field_85060_g = new StackTraceElement[0];
    private boolean reported = false;

    public CrashReport(String descriptionIn, Throwable causeThrowable) {
        this.field_71513_a = descriptionIn;
        this.field_71511_b = causeThrowable;
        this.func_71504_g();
    }

    private void func_71504_g() {
        this.field_85061_c.func_189529_a("Minecraft Version", () -> SharedConstants.func_215069_a().getName());
        this.field_85061_c.func_189529_a("Minecraft Version ID", () -> SharedConstants.func_215069_a().getId());
        this.field_85061_c.func_189529_a("Operating System", () -> System.getProperty("os.name") + " (" + System.getProperty("os.arch") + ") version " + System.getProperty("os.version"));
        this.field_85061_c.func_189529_a("Java Version", () -> System.getProperty("java.version") + ", " + System.getProperty("java.vendor"));
        this.field_85061_c.func_189529_a("Java VM Version", () -> System.getProperty("java.vm.name") + " (" + System.getProperty("java.vm.info") + "), " + System.getProperty("java.vm.vendor"));
        this.field_85061_c.func_189529_a("Memory", () -> {
            Runtime runtime = Runtime.getRuntime();
            long i2 = runtime.maxMemory();
            long j2 = runtime.totalMemory();
            long k2 = runtime.freeMemory();
            long l2 = i2 / 1024L / 1024L;
            long i1 = j2 / 1024L / 1024L;
            long j1 = k2 / 1024L / 1024L;
            return k2 + " bytes (" + j1 + " MB) / " + j2 + " bytes (" + i1 + " MB) up to " + i2 + " bytes (" + l2 + " MB)";
        });
        this.field_85061_c.func_71507_a("CPUs", (Object)Runtime.getRuntime().availableProcessors());
        this.field_85061_c.func_189529_a("JVM Flags", () -> {
            List list = Util.func_211565_f().collect(Collectors.toList());
            return String.format("%d total; %s", list.size(), list.stream().collect(Collectors.joining(" ")));
        });
        if (Reflector.CrashReportExtender_enhanceCrashReport != null) {
            Reflector.CrashReportExtender_enhanceCrashReport.call(this, this.field_85061_c);
        }
    }

    public String func_71501_a() {
        return this.field_71513_a;
    }

    public Throwable func_71505_b() {
        return this.field_71511_b;
    }

    public void func_71506_a(StringBuilder builder) {
        if (!(this.field_85060_g != null && this.field_85060_g.length > 0 || this.field_71512_c.isEmpty())) {
            this.field_85060_g = (StackTraceElement[])ArrayUtils.subarray((Object[])((CrashReportCategory)this.field_71512_c.get(0)).func_147152_a(), (int)0, (int)1);
        }
        if (this.field_85060_g != null && this.field_85060_g.length > 0) {
            builder.append("-- Head --\n");
            builder.append("Thread: ").append(Thread.currentThread().getName()).append("\n");
            if (Reflector.CrashReportExtender_generateEnhancedStackTraceSTE.exists()) {
                builder.append("Stacktrace:");
                builder.append(Reflector.CrashReportExtender_generateEnhancedStackTraceSTE.callString1(this.field_85060_g));
            } else {
                builder.append("Stacktrace:\n");
                for (StackTraceElement stacktraceelement : this.field_85060_g) {
                    builder.append("\t").append("at ").append(stacktraceelement);
                    builder.append("\n");
                }
                builder.append("\n");
            }
        }
        for (CrashReportCategory crashreportcategory : this.field_71512_c) {
            crashreportcategory.func_85072_a(builder);
            builder.append("\n\n");
        }
        this.field_85061_c.func_85072_a(builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String func_71498_d() {
        String s2;
        StringWriter stringwriter = null;
        PrintWriter printwriter = null;
        Throwable throwable = this.field_71511_b;
        if (throwable.getMessage() == null) {
            if (throwable instanceof NullPointerException) {
                throwable = new NullPointerException(this.field_71513_a);
            } else if (throwable instanceof StackOverflowError) {
                throwable = new StackOverflowError(this.field_71513_a);
            } else if (throwable instanceof OutOfMemoryError) {
                throwable = new OutOfMemoryError(this.field_71513_a);
            }
            throwable.setStackTrace(this.field_71511_b.getStackTrace());
        }
        if (Reflector.CrashReportExtender_generateEnhancedStackTraceT.exists()) {
            return Reflector.CrashReportExtender_generateEnhancedStackTraceT.callString(throwable);
        }
        try {
            stringwriter = new StringWriter();
            printwriter = new PrintWriter(stringwriter);
            throwable.printStackTrace(printwriter);
            s2 = stringwriter.toString();
        }
        catch (Throwable throwable2) {
            IOUtils.closeQuietly((Writer)stringwriter);
            IOUtils.closeQuietly(printwriter);
            throw throwable2;
        }
        IOUtils.closeQuietly((Writer)stringwriter);
        IOUtils.closeQuietly((Writer)printwriter);
        return s2;
    }

    public String func_71502_e() {
        if (!this.reported) {
            this.reported = true;
            CrashReporter.onCrashReport((CrashReport)this, (CrashReportCategory)this.field_85061_c);
        }
        StringBuilder stringbuilder = new StringBuilder();
        stringbuilder.append("---- Minecraft Crash Report ----\n");
        if (Reflector.CrashReportExtender_addCrashReportHeader != null && Reflector.CrashReportExtender_addCrashReportHeader.exists()) {
            Reflector.CrashReportExtender_addCrashReportHeader.call(stringbuilder, this);
        }
        stringbuilder.append("// ");
        stringbuilder.append(CrashReport.func_71503_h());
        stringbuilder.append("\n\n");
        stringbuilder.append("Time: ");
        stringbuilder.append(new SimpleDateFormat().format(new Date()));
        stringbuilder.append("\n");
        stringbuilder.append("Description: ");
        stringbuilder.append(this.field_71513_a);
        stringbuilder.append("\n\n");
        stringbuilder.append(this.func_71498_d());
        stringbuilder.append("\n\nA detailed walkthrough of the error, its code path and all known details is as follows:\n");
        for (int i2 = 0; i2 < 87; ++i2) {
            stringbuilder.append("-");
        }
        stringbuilder.append("\n\n");
        this.func_71506_a(stringbuilder);
        return stringbuilder.toString();
    }

    public File func_71497_f() {
        return this.field_71510_d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_147149_a(File toFile) {
        boolean bl;
        if (this.field_71510_d != null) {
            return false;
        }
        if (toFile.getParentFile() != null) {
            toFile.getParentFile().mkdirs();
        }
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(toFile), StandardCharsets.UTF_8);
            writer.write(this.func_71502_e());
            this.field_71510_d = toFile;
            bl = true;
        }
        catch (Throwable throwable) {
            boolean flag;
            try {
                field_147150_a.error("Could not save crash report to {}", (Object)toFile, (Object)throwable);
                flag = false;
            }
            catch (Throwable throwable2) {
                IOUtils.closeQuietly(writer);
                throw throwable2;
            }
            IOUtils.closeQuietly((Writer)writer);
            return flag;
        }
        IOUtils.closeQuietly((Writer)writer);
        return bl;
    }

    public CrashReportCategory func_85056_g() {
        return this.field_85061_c;
    }

    public CrashReportCategory func_85058_a(String name) {
        return this.func_85057_a(name, 1);
    }

    public CrashReportCategory func_85057_a(String categoryName, int stacktraceLength) {
        CrashReportCategory crashreportcategory = new CrashReportCategory(this, categoryName);
        try {
            if (this.field_85059_f) {
                int i2 = crashreportcategory.func_85073_a(stacktraceLength);
                StackTraceElement[] astacktraceelement = this.field_71511_b.getStackTrace();
                StackTraceElement stacktraceelement = null;
                StackTraceElement stacktraceelement1 = null;
                int j2 = astacktraceelement.length - i2;
                if (j2 < 0) {
                    System.out.println("Negative index in crash report handler (" + astacktraceelement.length + "/" + i2 + ")");
                }
                if (astacktraceelement != null && 0 <= j2 && j2 < astacktraceelement.length) {
                    stacktraceelement = astacktraceelement[j2];
                    if (astacktraceelement.length + 1 - i2 < astacktraceelement.length) {
                        stacktraceelement1 = astacktraceelement[astacktraceelement.length + 1 - i2];
                    }
                }
                this.field_85059_f = crashreportcategory.func_85069_a(stacktraceelement, stacktraceelement1);
                if (i2 > 0 && !this.field_71512_c.isEmpty()) {
                    CrashReportCategory crashreportcategory1 = (CrashReportCategory)this.field_71512_c.get(this.field_71512_c.size() - 1);
                    crashreportcategory1.func_85070_b(i2);
                } else if (astacktraceelement != null && astacktraceelement.length >= i2 && 0 <= j2 && j2 < astacktraceelement.length) {
                    this.field_85060_g = new StackTraceElement[j2];
                    System.arraycopy(astacktraceelement, 0, this.field_85060_g, 0, this.field_85060_g.length);
                } else {
                    this.field_85059_f = false;
                }
            }
        }
        catch (Throwable e2) {
            e2.printStackTrace();
        }
        this.field_71512_c.add(crashreportcategory);
        return crashreportcategory;
    }

    private static String func_71503_h() {
        String[] astring = new String[]{"Who set us up the TNT?", "Everything's going to plan. No, really, that was supposed to happen.", "Uh... Did I do that?", "Oops.", "Why did you do that?", "I feel sad now :(", "My bad.", "I'm sorry, Dave.", "I let you down. Sorry :(", "On the bright side, I bought you a teddy bear!", "Daisy, daisy...", "Oh - I know what I did wrong!", "Hey, that tickles! Hehehe!", "I blame Dinnerbone.", "You should try our sister game, Minceraft!", "Don't be sad. I'll do better next time, I promise!", "Don't be sad, have a hug! <3", "I just don't know what went wrong :(", "Shall we play a game?", "Quite honestly, I wouldn't worry myself about that.", "I bet Cylons wouldn't have this problem.", "Sorry :(", "Surprise! Haha. Well, this is awkward.", "Would you like a cupcake?", "Hi. I'm Minecraft, and I'm a crashaholic.", "Ooh. Shiny.", "This doesn't make any sense!", "Why is it breaking :(", "Don't do that.", "Ouch. That hurt :(", "You're mean.", "This is a token for 1 free hug. Redeem at your nearest Mojangsta: [~~HUG~~]", "There are four lights!", "But it works on my machine."};
        try {
            return astring[(int)(Util.func_211178_c() % (long)astring.length)];
        }
        catch (Throwable throwable) {
            return "Witty comment unavailable :(";
        }
    }

    public static CrashReport func_85055_a(Throwable causeIn, String descriptionIn) {
        while (causeIn instanceof CompletionException && causeIn.getCause() != null) {
            causeIn = causeIn.getCause();
        }
        CrashReport crashreport = causeIn instanceof ReportedException ? ((ReportedException)causeIn).func_71575_a() : new CrashReport(descriptionIn, causeIn);
        return crashreport;
    }

    public static void func_230188_h_() {
        new CrashReport("Don't panic!", new Throwable()).func_71502_e();
    }
}

