/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.lighting;

import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongList;
import java.util.function.LongPredicate;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.lighting.BlockLightEngine;
import net.minecraft.world.lighting.BlockLightStorage;
import net.minecraft.world.lighting.SkyLightEngine;
import net.minecraft.world.lighting.SkyLightStorage;

public abstract class LevelBasedGraph {
    private final int field_215486_a;
    private final LongLinkedOpenHashSet[] field_215487_b;
    private final Long2ByteMap field_215488_c;
    private int field_215489_d;
    private volatile boolean field_215490_e;

    protected LevelBasedGraph(int levelCount, int p_i51298_2_, int p_i51298_3_) {
        if (levelCount >= 254) {
            throw new IllegalArgumentException("Level count must be < 254.");
        }
        this.field_215486_a = levelCount;
        this.field_215487_b = new LongLinkedOpenHashSet[levelCount];
        int capacity1 = p_i51298_2_;
        int capacity2 = p_i51298_3_;
        if (this.getClass() == BlockLightEngine.class || this.getClass() == SkyLightEngine.class) {
            capacity1 = Math.max(capacity1, 8192);
            capacity2 = Math.max(capacity2, 8192);
        } else if (this.getClass() == BlockLightStorage.class || this.getClass() == SkyLightStorage.class) {
            capacity1 = Math.max(capacity1, 2048);
            capacity2 = Math.max(capacity2, 2048);
        }
        for (int i2 = 0; i2 < levelCount; ++i2) {
            this.field_215487_b[i2] = new /* Unavailable Anonymous Inner Class!! */;
        }
        this.field_215488_c = new /* Unavailable Anonymous Inner Class!! */;
        this.field_215488_c.defaultReturnValue((byte)-1);
        this.field_215489_d = levelCount;
    }

    private int func_215482_a(int level1, int level2) {
        int i2 = level1;
        if (level1 > level2) {
            i2 = level2;
        }
        if (i2 > this.field_215486_a - 1) {
            i2 = this.field_215486_a - 1;
        }
        return i2;
    }

    private void func_215472_a(int maxLevel) {
        int i2 = this.field_215489_d;
        this.field_215489_d = maxLevel;
        for (int j2 = i2 + 1; j2 < maxLevel; ++j2) {
            if (this.field_215487_b[j2].isEmpty()) continue;
            this.field_215489_d = j2;
            break;
        }
    }

    protected void func_215479_e(long positionIn) {
        int i2 = this.field_215488_c.get(positionIn) & 0xFF;
        if (i2 != 255) {
            int j2 = this.func_215471_c(positionIn);
            int k2 = this.func_215482_a(j2, i2);
            this.func_215484_a(positionIn, k2, this.field_215486_a, true);
            this.field_215490_e = this.field_215489_d < this.field_215486_a;
        }
    }

    public void func_227465_a_(LongPredicate p_227465_1_) {
        LongArrayList longlist = new LongArrayList();
        this.field_215488_c.keySet().forEach(arg_0 -> LevelBasedGraph.lambda$func_227465_a_$0(p_227465_1_, (LongList)longlist, arg_0));
        longlist.forEach(arg_0 -> this.func_215479_e(arg_0));
    }

    private void func_215484_a(long pos, int level, int maxLevel, boolean removeAll) {
        if (removeAll) {
            this.field_215488_c.remove(pos);
        }
        this.field_215487_b[level].remove(pos);
        if (this.field_215487_b[level].isEmpty() && this.field_215489_d == level) {
            this.func_215472_a(maxLevel);
        }
    }

    private void func_215470_a(long pos, int levelToSet, int updateLevel) {
        this.field_215488_c.put(pos, (byte)levelToSet);
        this.field_215487_b[updateLevel].add(pos);
        if (this.field_215489_d > updateLevel) {
            this.field_215489_d = updateLevel;
        }
    }

    protected void func_215473_f(long worldPos) {
        this.func_215469_a(worldPos, worldPos, this.field_215486_a - 1, false);
    }

    protected void func_215469_a(long fromPos, long toPos, int newLevel, boolean isDecreasing) {
        this.func_215474_a(fromPos, toPos, newLevel, this.func_215471_c(toPos), this.field_215488_c.get(toPos) & 0xFF, isDecreasing);
        this.field_215490_e = this.field_215489_d < this.field_215486_a;
    }

    private void func_215474_a(long fromPos, long toPos, int newLevel, int previousLevel, int propagationLevel, boolean isDecreasing) {
        if (!this.func_215485_a(toPos)) {
            boolean flag;
            newLevel = MathHelper.func_76125_a((int)newLevel, (int)0, (int)(this.field_215486_a - 1));
            previousLevel = MathHelper.func_76125_a((int)previousLevel, (int)0, (int)(this.field_215486_a - 1));
            if (propagationLevel == 255) {
                flag = true;
                propagationLevel = previousLevel;
            } else {
                flag = false;
            }
            int i2 = isDecreasing ? Math.min(propagationLevel, newLevel) : MathHelper.func_76125_a((int)this.func_215477_a(toPos, fromPos, newLevel), (int)0, (int)(this.field_215486_a - 1));
            int j2 = this.func_215482_a(previousLevel, propagationLevel);
            if (previousLevel != i2) {
                int k2 = this.func_215482_a(previousLevel, i2);
                if (j2 != k2 && !flag) {
                    this.func_215484_a(toPos, j2, k2, false);
                }
                this.func_215470_a(toPos, i2, k2);
            } else if (!flag) {
                this.func_215484_a(toPos, j2, this.field_215486_a, true);
            }
        }
    }

    protected final void func_215475_b(long fromPos, long toPos, int sourceLevel, boolean isDecreasing) {
        int i2 = this.field_215488_c.get(toPos) & 0xFF;
        int j2 = MathHelper.func_76125_a((int)this.func_215480_b(fromPos, toPos, sourceLevel), (int)0, (int)(this.field_215486_a - 1));
        if (isDecreasing) {
            this.func_215474_a(fromPos, toPos, j2, this.func_215471_c(toPos), i2, true);
        } else {
            int k2;
            boolean flag;
            if (i2 == 255) {
                flag = true;
                k2 = MathHelper.func_76125_a((int)this.func_215471_c(toPos), (int)0, (int)(this.field_215486_a - 1));
            } else {
                k2 = i2;
                flag = false;
            }
            if (j2 == k2) {
                this.func_215474_a(fromPos, toPos, this.field_215486_a - 1, flag ? k2 : this.func_215471_c(toPos), i2, false);
            }
        }
    }

    protected final boolean func_215481_b() {
        return this.field_215490_e;
    }

    protected final int func_215483_b(int toUpdateCount) {
        if (this.field_215489_d >= this.field_215486_a) {
            return toUpdateCount;
        }
        while (this.field_215489_d < this.field_215486_a && toUpdateCount > 0) {
            int k2;
            --toUpdateCount;
            LongLinkedOpenHashSet longlinkedopenhashset = this.field_215487_b[this.field_215489_d];
            long i2 = longlinkedopenhashset.removeFirstLong();
            int j2 = MathHelper.func_76125_a((int)this.func_215471_c(i2), (int)0, (int)(this.field_215486_a - 1));
            if (longlinkedopenhashset.isEmpty()) {
                this.func_215472_a(this.field_215486_a);
            }
            if ((k2 = this.field_215488_c.remove(i2) & 0xFF) < j2) {
                this.func_215476_a(i2, k2);
                this.func_215478_a(i2, k2, true);
                continue;
            }
            if (k2 <= j2) continue;
            this.func_215470_a(i2, k2, this.func_215482_a(this.field_215486_a - 1, k2));
            this.func_215476_a(i2, this.field_215486_a - 1);
            this.func_215478_a(i2, j2, false);
        }
        this.field_215490_e = this.field_215489_d < this.field_215486_a;
        return toUpdateCount;
    }

    public int func_227467_c_() {
        return this.field_215488_c.size();
    }

    protected abstract boolean func_215485_a(long var1);

    protected abstract int func_215477_a(long var1, long var3, int var5);

    protected abstract void func_215478_a(long var1, int var3, boolean var4);

    protected abstract int func_215471_c(long var1);

    protected abstract void func_215476_a(long var1, int var3);

    protected abstract int func_215480_b(long var1, long var3, int var5);

    protected int queuedUpdateSize() {
        return this.field_215488_c.size();
    }

    private static /* synthetic */ void lambda$func_227465_a_$0(LongPredicate p_227465_1_, LongList longlist, long p_229982_2_) {
        if (p_227465_1_.test(p_229982_2_)) {
            longlist.add(p_229982_2_);
        }
    }
}

