/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.optifine.Config;
import net.optifine.config.ConnectedParser;
import net.optifine.config.MatchBlock;
import net.optifine.render.RenderTypes;
import net.optifine.shaders.BlockAliases;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.ResUtils;

public class CustomBlockLayers {
    private static eao[] renderLayers = null;
    public static boolean active = false;

    public static eao getRenderLayer(brc worldReader, ceh blockState, fx blockPos) {
        if (renderLayers == null) {
            return null;
        }
        if (blockState.i(worldReader, blockPos)) {
            return null;
        }
        int id = blockState.getBlockId();
        if (id <= 0 || id >= renderLayers.length) {
            return null;
        }
        return renderLayers[id];
    }

    public static void update() {
        PropertiesOrdered propsShaders;
        renderLayers = null;
        active = false;
        ArrayList<eao> list = new ArrayList<eao>();
        String pathProps = "optifine/block.properties";
        Properties props = ResUtils.readProperties(pathProps, "CustomBlockLayers");
        if (props != null) {
            CustomBlockLayers.readLayers(pathProps, props, list);
        }
        if (Config.isShaders() && (propsShaders = BlockAliases.getBlockLayerPropertes()) != null) {
            String pathPropsShaders = "shaders/block.properties";
            CustomBlockLayers.readLayers(pathPropsShaders, propsShaders, list);
        }
        if (list.isEmpty()) {
            return;
        }
        renderLayers = list.toArray(new eao[list.size()]);
        active = true;
    }

    private static void readLayers(String pathProps, Properties props, List<eao> list) {
        Config.dbg("CustomBlockLayers: " + pathProps);
        CustomBlockLayers.readLayer("solid", RenderTypes.SOLID, props, list);
        CustomBlockLayers.readLayer("cutout", RenderTypes.CUTOUT, props, list);
        CustomBlockLayers.readLayer("cutout_mipped", RenderTypes.CUTOUT_MIPPED, props, list);
        CustomBlockLayers.readLayer("translucent", RenderTypes.TRANSLUCENT, props, list);
    }

    private static void readLayer(String name, eao layer, Properties props, List<eao> listLayers) {
        String key = "layer." + name;
        String val = props.getProperty(key);
        if (val == null) {
            return;
        }
        ConnectedParser cp = new ConnectedParser("CustomBlockLayers");
        MatchBlock[] mbs = cp.parseMatchBlocks(val);
        if (mbs == null) {
            return;
        }
        for (int i2 = 0; i2 < mbs.length; ++i2) {
            MatchBlock mb = mbs[i2];
            int blockId = mb.getBlockId();
            if (blockId <= 0) continue;
            while (listLayers.size() < blockId + 1) {
                listLayers.add(null);
            }
            if (listLayers.get(blockId) != null) {
                Config.warn("CustomBlockLayers: Block layer is already set, block: " + blockId + ", layer: " + name);
            }
            listLayers.set(blockId, layer);
        }
    }

    public static boolean isActive() {
        return active;
    }
}

