/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders.config;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.optifine.Config;
import net.optifine.shaders.config.ShaderLine;

public class ShaderParser {
    public static Pattern PATTERN_UNIFORM = Pattern.compile("[\\w\\s(,=)]*uniform\\s+\\w+\\s+(\\w+).*");
    public static Pattern PATTERN_ATTRIBUTE = Pattern.compile("\\s*attribute\\s+\\w+\\s+(\\w+).*");
    public static Pattern PATTERN_CONST_INT = Pattern.compile("\\s*const\\s+int\\s+(\\w+)\\s*=\\s*([-+.\\w]+)\\s*;.*");
    public static Pattern PATTERN_CONST_IVEC3 = Pattern.compile("\\s*const\\s+ivec3\\s+(\\w+)\\s*=\\s*(.+)\\s*;.*");
    public static Pattern PATTERN_CONST_FLOAT = Pattern.compile("\\s*const\\s+float\\s+(\\w+)\\s*=\\s*([-+.\\w]+)\\s*;.*");
    public static Pattern PATTERN_CONST_VEC2 = Pattern.compile("\\s*const\\s+vec2\\s+(\\w+)\\s*=\\s*(.+)\\s*;.*");
    public static Pattern PATTERN_CONST_VEC4 = Pattern.compile("\\s*const\\s+vec4\\s+(\\w+)\\s*=\\s*(.+)\\s*;.*");
    public static Pattern PATTERN_CONST_BOOL = Pattern.compile("\\s*const\\s+bool\\s+(\\w+)\\s*=\\s*(\\w+)\\s*;.*");
    public static Pattern PATTERN_PROPERTY = Pattern.compile("\\s*(/\\*|//)?\\s*([A-Z]+):\\s*([\\w.,]+)\\s*(\\*/.*|\\s*)");
    public static Pattern PATTERN_EXTENSION = Pattern.compile("\\s*#\\s*extension\\s+(\\w+)\\s*:\\s*(\\w+).*");
    public static Pattern PATTERN_LAYOUT = Pattern.compile("\\s*layout\\s*\\((.*)\\)\\s*(\\w+).*");
    public static Pattern PATTERN_DRAW_BUFFERS = Pattern.compile("[0-9N]+");
    public static Pattern PATTERN_RENDER_TARGETS = Pattern.compile("[0-9N,]+");

    public static ShaderLine parseLine(String line) {
        Matcher mu = PATTERN_UNIFORM.matcher(line);
        if (mu.matches()) {
            return new ShaderLine(ShaderLine.Type.UNIFORM, mu.group(1), "", line);
        }
        Matcher ma = PATTERN_ATTRIBUTE.matcher(line);
        if (ma.matches()) {
            return new ShaderLine(ShaderLine.Type.ATTRIBUTE, ma.group(1), "", line);
        }
        Matcher mci = PATTERN_CONST_INT.matcher(line);
        if (mci.matches()) {
            return new ShaderLine(ShaderLine.Type.CONST_INT, mci.group(1), mci.group(2), line);
        }
        Matcher mciv3 = PATTERN_CONST_IVEC3.matcher(line);
        if (mciv3.matches()) {
            return new ShaderLine(ShaderLine.Type.CONST_IVEC3, mciv3.group(1), mciv3.group(2), line);
        }
        Matcher mcf = PATTERN_CONST_FLOAT.matcher(line);
        if (mcf.matches()) {
            return new ShaderLine(ShaderLine.Type.CONST_FLOAT, mcf.group(1), mcf.group(2), line);
        }
        Matcher mcv2 = PATTERN_CONST_VEC2.matcher(line);
        if (mcv2.matches()) {
            return new ShaderLine(ShaderLine.Type.CONST_VEC2, mcv2.group(1), mcv2.group(2), line);
        }
        Matcher mcv4 = PATTERN_CONST_VEC4.matcher(line);
        if (mcv4.matches()) {
            return new ShaderLine(ShaderLine.Type.CONST_VEC4, mcv4.group(1), mcv4.group(2), line);
        }
        Matcher mcb = PATTERN_CONST_BOOL.matcher(line);
        if (mcb.matches()) {
            return new ShaderLine(ShaderLine.Type.CONST_BOOL, mcb.group(1), mcb.group(2), line);
        }
        Matcher mc = PATTERN_PROPERTY.matcher(line);
        if (mc.matches()) {
            return new ShaderLine(ShaderLine.Type.PROPERTY, mc.group(2), mc.group(3), line);
        }
        Matcher mce = PATTERN_EXTENSION.matcher(line);
        if (mce.matches()) {
            return new ShaderLine(ShaderLine.Type.EXTENSION, mce.group(1), mce.group(2), line);
        }
        Matcher ml2 = PATTERN_LAYOUT.matcher(line);
        if (ml2.matches()) {
            return new ShaderLine(ShaderLine.Type.LAYOUT, ml2.group(2), ml2.group(1), line);
        }
        return null;
    }

    public static int getIndex(String uniform, String prefix, int minIndex, int maxIndex) {
        if (!uniform.startsWith(prefix)) {
            return -1;
        }
        String suffix = uniform.substring(prefix.length());
        int index = Config.parseInt(suffix, -1);
        if (index < minIndex || index > maxIndex) {
            return -1;
        }
        return index;
    }

    public static int getShadowDepthIndex(String uniform) {
        switch (uniform) {
            case "shadow": {
                return 0;
            }
            case "watershadow": {
                return 1;
            }
        }
        return ShaderParser.getIndex(uniform, "shadowtex", 0, 1);
    }

    public static int getShadowColorIndex(String uniform) {
        switch (uniform) {
            case "shadowcolor": {
                return 0;
            }
        }
        return ShaderParser.getIndex(uniform, "shadowcolor", 0, 1);
    }

    public static int getShadowColorImageIndex(String uniform) {
        return ShaderParser.getIndex(uniform, "shadowcolorimg", 0, 1);
    }

    public static int getDepthIndex(String uniform) {
        return ShaderParser.getIndex(uniform, "depthtex", 0, 2);
    }

    public static int getColorIndex(String uniform) {
        int gauxIndex = ShaderParser.getIndex(uniform, "gaux", 1, 4);
        if (gauxIndex > 0) {
            return gauxIndex + 3;
        }
        return ShaderParser.getIndex(uniform, "colortex", 0, 15);
    }

    public static int getColorImageIndex(String uniform) {
        return ShaderParser.getIndex(uniform, "colorimg", 0, 15);
    }

    public static String[] parseDrawBuffers(String str) {
        if (!PATTERN_DRAW_BUFFERS.matcher(str).matches()) {
            return null;
        }
        str = str.trim();
        String[] strs = new String[str.length()];
        for (int i2 = 0; i2 < strs.length; ++i2) {
            strs[i2] = String.valueOf(str.charAt(i2));
        }
        return strs;
    }

    public static String[] parseRenderTargets(String str) {
        if (!PATTERN_RENDER_TARGETS.matcher(str).matches()) {
            return null;
        }
        str = str.trim();
        String[] strs = Config.tokenize(str, ",");
        return strs;
    }

    public static gr parseLocalSize(String value) {
        int x2 = 1;
        int y2 = 1;
        int z = 1;
        String[] parts = Config.tokenize(value, ",");
        for (int i2 = 0; i2 < parts.length; ++i2) {
            String part = parts[i2];
            String[] tokens = Config.tokenize(part, "=");
            if (tokens.length != 2) continue;
            String name = tokens[0].trim();
            String valStr = tokens[1].trim();
            int val = Config.parseInt(valStr, -1);
            if (val < 1) {
                return null;
            }
            if (name.equals("local_size_x")) {
                x2 = val;
            }
            if (name.equals("local_size_y")) {
                y2 = val;
            }
            if (!name.equals("local_size_z")) continue;
            z = val;
        }
        if (x2 == 1 && y2 == 1 && z == 1) {
            return null;
        }
        return new gr(x2, y2, z);
    }
}

