/*
 * Decompiled with CFR 0.152.
 */
package com.apple.library.coregraphics;

import com.apple.library.coregraphics.CGAffineTransform;
import com.apple.library.impl.InterpolableImpl;
import java.util.Objects;

public class CGPoint
implements InterpolableImpl<CGPoint> {
    public static final CGPoint ZERO = new CGPoint(0.0f, 0.0f);
    public float x;
    public float y;

    public CGPoint(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public CGPoint(double x, double y) {
        this((float)x, (float)y);
    }

    public void apply(CGAffineTransform t) {
        float tx = t.a * this.x + t.c * this.y + t.tx;
        float ty = t.b * this.x + t.d * this.y + t.ty;
        this.x = tx;
        this.y = ty;
    }

    public CGPoint applying(CGAffineTransform t) {
        CGPoint pos = this.copy();
        pos.apply(t);
        return pos;
    }

    public CGPoint copy() {
        return new CGPoint(this.x, this.y);
    }

    @Override
    public CGPoint interpolating(CGPoint in, float t) {
        if (t <= 0.0f) {
            return this;
        }
        if (t >= 1.0f) {
            return in;
        }
        float v = 1.0f - t;
        float x = v * this.x + t * in.x;
        float y = v * this.y + t * in.y;
        return new CGPoint(x, y);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CGPoint pos = (CGPoint)o;
        return Float.compare(pos.x, this.x) == 0 && Float.compare(pos.y, this.y) == 0;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.x), Float.valueOf(this.y));
    }

    public String toString() {
        return String.format("(%f %f)", Float.valueOf(this.x), Float.valueOf(this.y));
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }
}

