/*
 * Decompiled with CFR 0.152.
 */
package com.apple.library.coregraphics;

import com.apple.library.coregraphics.CGAffineTransform;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGSize;
import com.apple.library.impl.InterpolableImpl;
import com.apple.library.uikit.UIEdgeInsets;
import java.util.Objects;

public class CGRect
implements InterpolableImpl<CGRect> {
    public static final CGRect ZERO = new CGRect(0.0f, 0.0f, 0.0f, 0.0f);
    public float x;
    public float y;
    public float width;
    public float height;

    public CGRect(CGRect rect) {
        this(rect.x, rect.y, rect.width, rect.height);
    }

    public CGRect(CGPoint point, CGSize size) {
        this(point.x, point.y, size.width, size.height);
    }

    public CGRect(float x, float y, float width, float height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public void apply(CGAffineTransform t) {
        CGPoint tl = new CGPoint(this.getMinX(), this.getMinY());
        CGPoint tr = new CGPoint(this.getMaxX(), this.getMinY());
        CGPoint bl = new CGPoint(this.getMinX(), this.getMaxY());
        CGPoint br = new CGPoint(this.getMaxX(), this.getMaxY());
        tl.apply(t);
        tr.apply(t);
        bl.apply(t);
        br.apply(t);
        float minX = Math.min(Math.min(tl.x, tr.x), Math.min(bl.x, br.x));
        float minY = Math.min(Math.min(tl.y, tr.y), Math.min(bl.y, br.y));
        float maxX = Math.max(Math.max(tl.x, tr.x), Math.max(bl.x, br.x));
        float maxY = Math.max(Math.max(tl.y, tr.y), Math.max(bl.y, br.y));
        this.x = minX;
        this.y = minY;
        this.width = maxX - minX;
        this.height = maxY - minY;
    }

    public CGRect applying(CGAffineTransform t) {
        CGRect rect = this.copy();
        rect.apply(t);
        return rect;
    }

    public CGRect intersection(CGRect r) {
        float tx1 = this.x;
        float ty1 = this.y;
        float rx1 = r.x;
        float ry1 = r.y;
        double tx2 = tx1;
        tx2 += (double)this.width;
        double ty2 = ty1;
        ty2 += (double)this.height;
        double rx2 = rx1;
        rx2 += (double)r.width;
        double ry2 = ry1;
        ry2 += (double)r.height;
        if (tx1 < rx1) {
            tx1 = rx1;
        }
        if (ty1 < ry1) {
            ty1 = ry1;
        }
        if (tx2 > rx2) {
            tx2 = rx2;
        }
        if (ty2 > ry2) {
            ty2 = ry2;
        }
        tx2 -= (double)tx1;
        ty2 -= (double)ty1;
        if (tx2 < -2.147483648E9) {
            tx2 = -2.147483648E9;
        }
        if (ty2 < -2.147483648E9) {
            ty2 = -2.147483648E9;
        }
        return new CGRect(tx1, ty1, (float)tx2, (float)ty2);
    }

    public boolean intersects(CGRect rect) {
        return this.intersects(rect.x, rect.y, rect.width, rect.height);
    }

    public boolean intersects(double x, double y, double w, double h) {
        if (w <= 0.0 || h <= 0.0) {
            return false;
        }
        double x0 = this.getX();
        double y0 = this.getY();
        return x + w > x0 && y + h > y0 && x < x0 + (double)this.getWidth() && y < y0 + (double)this.getHeight();
    }

    public CGRect offset(CGPoint point) {
        return this.offset(point.x, point.y);
    }

    public CGRect offset(float dx, float dy) {
        return new CGRect(this.x + dx, this.y + dy, this.width, this.height);
    }

    public CGRect insetBy(UIEdgeInsets insets) {
        return this.insetBy(insets.top, insets.left, insets.bottom, insets.right);
    }

    public CGRect insetBy(float top, float left, float bottom, float right) {
        float x0 = this.x + left;
        float x1 = this.x + this.width - right;
        float y0 = this.y + top;
        float y1 = this.y + this.height - bottom;
        return new CGRect(x0, y0, Math.max(x1 - x0, 0.0f), Math.max(y1 - y0, 0.0f));
    }

    public boolean contains(CGPoint point) {
        return this.contains(point.x, point.y);
    }

    public boolean contains(double x, double y) {
        double x0 = this.getX();
        double y0 = this.getY();
        return x >= x0 && y >= y0 && x <= x0 + (double)this.getWidth() && y <= y0 + (double)this.getHeight();
    }

    private boolean contains(float x, float y) {
        float x0 = this.getX();
        float y0 = this.getY();
        return x >= x0 && y >= y0 && x < x0 + this.getWidth() && y < y0 + this.getHeight();
    }

    public CGRect copy() {
        return new CGRect(this.x, this.y, this.width, this.height);
    }

    @Override
    public CGRect interpolating(CGRect in, float t) {
        if (t <= 0.0f) {
            return this;
        }
        if (t >= 1.0f) {
            return in;
        }
        float v = 1.0f - t;
        float x = v * this.x + t * in.y;
        float y = v * this.x + t * in.y;
        float w = v * this.width + t * in.width;
        float h = v * this.height + t * in.height;
        return new CGRect(x, y, w, h);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CGRect rect = (CGRect)o;
        return Float.compare(rect.x, this.x) == 0 && Float.compare(rect.y, this.y) == 0 && Float.compare(rect.width, this.width) == 0 && Float.compare(rect.height, this.height) == 0;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.width), Float.valueOf(this.height));
    }

    public String toString() {
        return String.format("(%f %f; %f %f)", Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.width), Float.valueOf(this.height));
    }

    public void setX(float x) {
        this.x = x;
    }

    public float getX() {
        return this.x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public float getY() {
        return this.y;
    }

    public float getMinX() {
        return this.x;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public float getWidth() {
        return this.width;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public float getHeight() {
        return this.height;
    }

    public float getMinY() {
        return this.y;
    }

    public float getMidX() {
        return this.x + this.width / 2.0f;
    }

    public float getMidY() {
        return this.y + this.height / 2.0f;
    }

    public float getMaxX() {
        return this.x + this.width;
    }

    public float getMaxY() {
        return this.y + this.height;
    }

    public CGSize size() {
        return new CGSize(this.width, this.height);
    }

    public void setSize(CGSize size) {
        this.width = size.width;
        this.height = size.height;
    }

    public CGPoint origin() {
        return new CGPoint(this.x, this.y);
    }

    public void setOrigin(CGPoint origin) {
        this.x = origin.x;
        this.y = origin.y;
    }
}

