/*
 * Decompiled with CFR 0.152.
 */
package com.apple.library.coregraphics;

import com.apple.library.coregraphics.CGAffineTransform;
import com.apple.library.impl.InterpolableImpl;
import java.util.Objects;

public class CGSize
implements InterpolableImpl<CGSize> {
    public static final CGSize ZERO = new CGSize(0.0f, 0.0f);
    public float width;
    public float height;

    public CGSize(float width, float height) {
        this.width = width;
        this.height = height;
    }

    public void apply(CGAffineTransform t) {
        float w = t.a * this.width + t.c * this.height;
        float h = t.b * this.width + t.d * this.height;
        this.width = w;
        this.height = h;
    }

    public CGSize applying(CGAffineTransform t) {
        CGSize size = this.copy();
        size.apply(t);
        return size;
    }

    public CGSize copy() {
        return new CGSize(this.width, this.height);
    }

    @Override
    public CGSize interpolating(CGSize in, float t) {
        if (t <= 0.0f) {
            return this;
        }
        if (t >= 1.0f) {
            return in;
        }
        float v = 1.0f - t;
        float w = v * this.width + t * in.width;
        float h = v * this.height + t * in.height;
        return new CGSize(w, h);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CGSize size = (CGSize)o;
        return Float.compare(size.width, this.width) == 0 && Float.compare(size.height, this.height) == 0;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.width), Float.valueOf(this.height));
    }

    public String toString() {
        return String.format("(%f %f)", Float.valueOf(this.width), Float.valueOf(this.height));
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }
}

