/*
 * Decompiled with CFR 0.152.
 */
package com.apple.library.uikit;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.coregraphics.CGSize;
import com.apple.library.uikit.UIView;
import java.util.ArrayList;
import java.util.List;

public class UIStackView
extends UIView {
    protected Axis _axis = Axis.HORIZONTAL;
    protected Distribution _distribution = Distribution.FILL;
    protected Alignment _alignment = Alignment.FILL;
    protected float _spacing = 0.0f;
    protected final ArrayList<UIView> _arrangedSubviews = new ArrayList();

    public UIStackView(CGRect frame) {
        super(frame);
    }

    @Override
    public void layoutSubviews() {
        super.layoutSubviews();
        this._apply(this._arrangedSubviews);
    }

    public void addArrangedSubview(UIView view) {
        this.addSubview(view);
        this._arrangedSubviews.add(view);
        this.setNeedsLayout();
    }

    public void removeArrangedSubview(UIView view) {
        view.removeFromSuperview();
        this._arrangedSubviews.remove(view);
        this.setNeedsLayout();
    }

    public void insertArrangedSubviewAtIndex(UIView view, int stackIndex) {
        this.insertViewAtIndex(view, stackIndex);
        this._arrangedSubviews.add(stackIndex, view);
        this.setNeedsLayout();
    }

    public final List<UIView> arrangedSubviews() {
        return this._arrangedSubviews;
    }

    public void setDistribution(Distribution distribution) {
        this._distribution = distribution;
    }

    public Distribution distribution() {
        return this._distribution;
    }

    public void setAlignment(Alignment alignment) {
        this._alignment = alignment;
    }

    public Alignment alignment() {
        return this._alignment;
    }

    public void setAxis(Axis axis) {
        this._axis = axis;
    }

    public Axis axis() {
        return this._axis;
    }

    public void setSpacing(float spacing) {
        this._spacing = spacing;
    }

    public float spacing() {
        return this._spacing;
    }

    public void setCustomSpacing(float spacing, UIView arrangedSubview) {
    }

    public float customSpacing(UIView arrangedSubview) {
        return 0.0f;
    }

    private void _apply(List<UIView> views) {
        CGRect bounds = this._rotation(this.bounds().copy());
        ArrayList<CGRect> rects = new ArrayList<CGRect>();
        for (UIView view : views) {
            rects.add(this._rotation(view.frame().copy()));
        }
        this._applySize(bounds, rects, this._distribution);
        this._applyOffset(bounds, rects, this._alignment);
        for (int i = 0; i < rects.size(); ++i) {
            views.get(i).setFrame(this._rotation(rects.get(i)));
        }
    }

    private void _applySize(CGRect bounds, List<CGRect> rects, Distribution distribution) {
        int count = rects.size();
        if (count == 0) {
            return;
        }
        switch (distribution) {
            case FILL: {
                this._applySize(bounds, rects, Distribution.FILL_EQUALLY);
                break;
            }
            case FILL_EQUALLY: {
                float usableSize = bounds.getWidth() - this._spacing * (float)(count - 1);
                float itemLeft = 0.0f;
                float itemWidth = usableSize / (float)count;
                for (CGRect rect : rects) {
                    rect.setX(itemLeft);
                    rect.setWidth(itemWidth);
                    itemLeft += itemWidth + this._spacing;
                }
                break;
            }
            case FILL_PROPORTIONALLY: {
                float usableSize = bounds.getWidth() - this._spacing * (float)(count - 1);
                float contentWidth = Math.max(this._calcSize(rects).getWidth(), 1.0f);
                float itemLeft = 0.0f;
                for (CGRect rect : rects) {
                    float pro = rect.getWidth() / contentWidth;
                    float itemWidth = pro * usableSize;
                    rect.setX(itemLeft);
                    rect.setWidth(itemWidth);
                    itemLeft += itemWidth + this._spacing;
                }
                break;
            }
            case EQUAL_SPACING: {
                if (count == 1) {
                    this._applySize(bounds, rects, Distribution.FILL_EQUALLY);
                    break;
                }
                float contentSize = Math.max(this._calcSize(rects).getWidth(), 1.0f);
                float spacing = (bounds.getWidth() - contentSize) / (float)(count - 1);
                float itemLeft = 0.0f;
                for (CGRect rect : rects) {
                    float itemWidth = rect.getWidth();
                    rect.setX(itemLeft);
                    itemLeft += itemWidth + spacing;
                }
                break;
            }
            case EQUAL_CENTERING: {
                float centerSize = bounds.getWidth() / (float)(count + 1);
                float itemLeft = 0.0f;
                for (CGRect rect : rects) {
                    float itemWidth = rect.getWidth();
                    rect.setX(itemLeft + centerSize - itemWidth / 2.0f);
                    itemLeft += centerSize;
                }
                break;
            }
        }
    }

    private void _applyOffset(CGRect bounds, List<CGRect> rects, Alignment alignment) {
        int count = rects.size();
        if (count == 0) {
            return;
        }
        switch (alignment) {
            case FILL: {
                float usableHeight = bounds.getHeight();
                for (CGRect rect : rects) {
                    rect.setY(0.0f);
                    rect.setHeight(usableHeight);
                }
                break;
            }
            case TOP: 
            case LEADING: {
                for (CGRect rect : rects) {
                    rect.setY(0.0f);
                }
                break;
            }
            case BOTTOM: 
            case TRAILING: {
                float usableHeight = bounds.getHeight();
                for (CGRect rect : rects) {
                    rect.setY(usableHeight - rect.getHeight());
                }
                break;
            }
            case CENTER: {
                float usableHeight = bounds.getHeight();
                for (CGRect rect : rects) {
                    rect.setY((usableHeight - rect.getHeight()) / 2.0f);
                }
                break;
            }
        }
    }

    private CGSize _calcSize(List<CGRect> rects) {
        float width = 0.0f;
        float height = 0.0f;
        for (CGRect rect : rects) {
            width += rect.getWidth();
            height = Math.max(height, rect.getHeight());
        }
        return new CGSize(width, height);
    }

    private CGRect _rotation(CGRect rect) {
        if (this._axis == Axis.VERTICAL) {
            float x = rect.getY();
            float y = rect.getX();
            float width = rect.getHeight();
            float height = rect.getWidth();
            rect.setX(x);
            rect.setY(y);
            rect.setWidth(width);
            rect.setHeight(height);
        }
        return rect;
    }

    public static enum Axis {
        HORIZONTAL,
        VERTICAL;

    }

    public static enum Distribution {
        FILL,
        FILL_EQUALLY,
        FILL_PROPORTIONALLY,
        EQUAL_SPACING,
        EQUAL_CENTERING;

    }

    public static enum Alignment {
        FILL,
        LEADING,
        TOP,
        FIRST_BASELINE,
        CENTER,
        TRAILING,
        BOTTOM,
        LAST_BASELINE;

    }
}

