/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.blockentity;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import moe.plushie.armourers_workshop.api.common.IBlockEntityHandler;
import moe.plushie.armourers_workshop.api.common.IWorldUpdateTask;
import moe.plushie.armourers_workshop.api.math.IRectangle3i;
import moe.plushie.armourers_workshop.api.math.IVector3i;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.api.skin.ISkinToolType;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.api.skin.property.ISkinProperty;
import moe.plushie.armourers_workshop.builder.block.ArmourerBlock;
import moe.plushie.armourers_workshop.builder.blockentity.BoundingBoxBlockEntity;
import moe.plushie.armourers_workshop.builder.data.BoundingBox;
import moe.plushie.armourers_workshop.builder.item.impl.IPaintToolSelector;
import moe.plushie.armourers_workshop.builder.other.CubeChangesCollector;
import moe.plushie.armourers_workshop.builder.other.CubeReplacingEvent;
import moe.plushie.armourers_workshop.builder.other.CubeSelector;
import moe.plushie.armourers_workshop.builder.other.CubeTransform;
import moe.plushie.armourers_workshop.builder.other.WorldBlockUpdateTask;
import moe.plushie.armourers_workshop.builder.other.WorldUpdater;
import moe.plushie.armourers_workshop.builder.other.WorldUtils;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.CompoundTag.OptionalAPI;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.level.block.state.BlockState.PropertyProvider;
import moe.plushie.armourers_workshop.core.blockentity.UpdatableBlockEntity;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.core.texture.PlayerTextureDescriptor;
import moe.plushie.armourers_workshop.init.ModBlocks;
import moe.plushie.armourers_workshop.utils.BlockUtils;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.math.Rectangle3i;
import moe.plushie.armourers_workshop.utils.math.TexturePos;
import moe.plushie.armourers_workshop.utils.texture.PlayerTextureModel;
import moe.plushie.armourers_workshop.utils.texture.SkinPaintData;
import moe.plushie.armourers_workshop.utils.texture.SkyBox;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class ArmourerBlockEntity
extends UpdatableBlockEntity
implements IBlockEntityHandler,
IPaintToolSelector.Provider {
    private static final ImmutableMap<ISkinPartType, ISkinProperty<Boolean>> PART_TO_MODEL = new ImmutableMap.Builder().put((Object)SkinPartTypes.BIPPED_HEAD, SkinProperty.OVERRIDE_MODEL_HEAD).put((Object)SkinPartTypes.BIPPED_CHEST, SkinProperty.OVERRIDE_MODEL_CHEST).put((Object)SkinPartTypes.BIPPED_LEFT_ARM, SkinProperty.OVERRIDE_MODEL_LEFT_ARM).put((Object)SkinPartTypes.BIPPED_RIGHT_ARM, SkinProperty.OVERRIDE_MODEL_RIGHT_ARM).put((Object)SkinPartTypes.BIPPED_LEFT_THIGH, SkinProperty.OVERRIDE_MODEL_LEFT_LEG).put((Object)SkinPartTypes.BIPPED_RIGHT_THIGH, SkinProperty.OVERRIDE_MODEL_RIGHT_LEG).put((Object)SkinPartTypes.BIPPED_LEFT_FOOT, SkinProperty.OVERRIDE_MODEL_LEFT_LEG).put((Object)SkinPartTypes.BIPPED_RIGHT_FOOT, SkinProperty.OVERRIDE_MODEL_RIGHT_LEG).build();
    protected int flags = 0;
    protected int version = 0;
    protected ISkinType skinType = SkinTypes.ARMOR_HEAD;
    protected SkinProperties skinProperties = new SkinProperties();
    protected PlayerTextureDescriptor textureDescriptor = PlayerTextureDescriptor.EMPTY;
    protected SkinPaintData paintData;
    protected Object renderData;
    protected AxisAlignedBB renderBoundingBox;

    public ArmourerBlockEntity(TileEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    @Override
    public void readFromNBT(CompoundNBT tag) {
        this.skinType = SkinTypes.byName(OptionalAPI.getOptionalString(tag, "SkinType", SkinTypes.ARMOR_HEAD.getRegistryName().toString()));
        this.skinProperties = OptionalAPI.getOptionalSkinProperties(tag, "SkinProperties");
        this.textureDescriptor = OptionalAPI.getOptionalTextureDescriptor(tag, "Texture", PlayerTextureDescriptor.EMPTY);
        this.flags = OptionalAPI.getOptionalInt(tag, "Flags", 0);
        this.version = OptionalAPI.getOptionalInt(tag, "DataVersion", 0);
        this.paintData = OptionalAPI.getOptionalPaintData(tag, "PaintData");
    }

    @Override
    public void writeToNBT(CompoundNBT tag) {
        OptionalAPI.putOptionalString(tag, "SkinType", this.skinType.getRegistryName().toString(), null);
        OptionalAPI.putOptionalSkinProperties(tag, "SkinProperties", this.skinProperties);
        OptionalAPI.putOptionalTextureDescriptor(tag, "Texture", this.textureDescriptor, PlayerTextureDescriptor.EMPTY);
        OptionalAPI.putOptionalInt(tag, "Flags", this.flags, 0);
        OptionalAPI.putOptionalInt(tag, "DataVersion", this.version, 0);
        OptionalAPI.putOptionalPaintData(tag, "PaintData", this.paintData);
    }

    public void onPlace(World level, BlockPos pos, BlockState state, @Nullable LivingEntity entity) {
        this.remakeBoundingBoxes(null, this.getBoundingBoxes(), true);
        if (entity instanceof PlayerEntity) {
            this.setTextureDescriptor(PlayerTextureDescriptor.fromProfile(((PlayerEntity)entity).func_146103_bH()));
        }
    }

    public void onRemove(World level, BlockPos pos, BlockState state) {
        if (!this.func_195044_w().func_203425_a((Block)ModBlocks.ARMOURER.get())) {
            return;
        }
        this.remakeBoundingBoxes(this.getBoundingBoxes(), null, true);
    }

    public ISkinType getSkinType() {
        return this.skinType;
    }

    public void setSkinType(ISkinType skinType) {
        if (this.skinType == skinType) {
            return;
        }
        Collection<BoundingBox> boxes = this.getBoundingBoxes();
        this.skinType = skinType;
        this.setPaintData(null);
        this.remakeSkinProperties();
        this.remakeBoundingBoxes(boxes, this.getBoundingBoxes(), true);
        BlockUtils.combine(this, this::sendBlockUpdates);
    }

    public SkinProperties getSkinProperties() {
        return this.skinProperties;
    }

    public void setSkinProperties(SkinProperties skinProperties) {
        Collection<BoundingBox> boxes = this.getBoundingBoxes();
        this.skinProperties = skinProperties;
        this.remakeBoundingBoxes(boxes, this.getBoundingBoxes(), false);
        BlockUtils.combine(this, this::sendBlockUpdates);
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        Collection<BoundingBox> boxes = this.getBoundingBoxes();
        this.flags = flags;
        this.remakeBoundingBoxes(boxes, this.getBoundingBoxes(), false);
        BlockUtils.combine(this, this::sendBlockUpdates);
    }

    public PlayerTextureDescriptor getTextureDescriptor() {
        return this.textureDescriptor;
    }

    public void setTextureDescriptor(PlayerTextureDescriptor textureDescriptor) {
        this.textureDescriptor = textureDescriptor;
        BlockUtils.combine(this, this::sendBlockUpdates);
    }

    public SkinPaintData getPaintData() {
        return this.paintData;
    }

    public void setPaintData(SkinPaintData paintData) {
        if (this.paintData == paintData) {
            return;
        }
        if (paintData != null) {
            this.paintData = SkinPaintData.v2();
            this.paintData.copyFrom(paintData);
        } else {
            this.paintData = null;
        }
        BlockUtils.combine(this, this::sendBlockUpdates);
    }

    public IPaintColor getPaintColor(TexturePos pos) {
        if (this.paintData != null) {
            return PaintColor.of(this.paintData.getColor(pos));
        }
        return null;
    }

    public void setPaintColor(TexturePos pos, IPaintColor paintColor) {
        if (this.paintData == null) {
            this.paintData = SkinPaintData.v2();
        }
        this.paintData.setColor(pos, paintColor.getRawValue());
        this.func_70296_d();
    }

    @Override
    public void func_70296_d() {
        super.func_70296_d();
        ++this.version;
    }

    public boolean isShowGuides() {
        return (this.flags & 1) == 0;
    }

    public void setShowGuides(boolean value) {
        this.flags = value ? (this.flags &= 0xFFFFFFFE) : (this.flags |= 1);
        this.func_70296_d();
    }

    public boolean isShowHelper() {
        return (this.flags & 2) == 0;
    }

    public void setShowHelper(boolean value) {
        this.flags = value ? (this.flags &= 0xFFFFFFFD) : (this.flags |= 2);
        this.func_70296_d();
    }

    public boolean isShowModelGuides() {
        return (this.flags & 4) == 0;
    }

    public void setShowModelGuides(boolean value) {
        this.flags = value ? (this.flags &= 0xFFFFFFFB) : (this.flags |= 4);
        this.func_70296_d();
    }

    public boolean isUseHelper() {
        if (this.skinType == SkinTypes.ARMOR_WINGS) {
            return true;
        }
        return this.skinType instanceof ISkinToolType;
    }

    @Override
    public IPaintToolSelector createPaintToolSelector(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        if (player == null || !player.func_226563_dT_()) {
            return null;
        }
        ArrayList<Rectangle3i> rects = new ArrayList<Rectangle3i>();
        CubeTransform transform = this.getTransform();
        for (ISkinPartType iSkinPartType : this.getSkinType().getParts()) {
            Rectangle3i box = WorldUtils.getResolvedBuildingSpace(iSkinPartType);
            BlockPos p1 = transform.mul(box.getMinX(), box.getMinY(), box.getMinZ());
            BlockPos p2 = transform.mul(box.getMaxX(), box.getMaxY(), box.getMaxZ());
            int minX = Math.min(p1.func_177958_n(), p2.func_177958_n());
            int minY = Math.min(p1.func_177956_o(), p2.func_177956_o());
            int minZ = Math.min(p1.func_177952_p(), p2.func_177952_p());
            int maxX = Math.max(p1.func_177958_n(), p2.func_177958_n());
            int maxY = Math.max(p1.func_177956_o(), p2.func_177956_o());
            int maxZ = Math.max(p1.func_177952_p(), p2.func_177952_p());
            rects.add(new Rectangle3i(minX, minY, minZ, maxX - minX, maxY - minY, maxZ - minZ));
        }
        return CubeSelector.all(rects);
    }

    public void copyPaintData(CubeChangesCollector collector, ISkinPartType srcPart, ISkinPartType destPart, boolean mirror) {
        if (this.paintData == null) {
            return;
        }
        PlayerTextureModel textureModel = BoundingBox.MODEL;
        SkyBox srcBox = textureModel.get(srcPart);
        SkyBox destBox = textureModel.get(destPart);
        if (srcBox != null && destBox != null) {
            WorldUtils.copyPaintData(this.paintData, srcBox, destBox, mirror);
            BlockUtils.combine(this, this::sendBlockUpdates);
        }
    }

    public void clearPaintData(CubeChangesCollector collector, ISkinPartType partType) {
        if (this.paintData == null) {
            return;
        }
        if (partType == SkinPartTypes.UNKNOWN) {
            this.setPaintData(null);
            return;
        }
        PlayerTextureModel textureModel = BoundingBox.MODEL;
        SkyBox srcBox = textureModel.get(partType);
        if (srcBox != null) {
            WorldUtils.clearPaintData(this.paintData, srcBox);
            BlockUtils.combine(this, this::sendBlockUpdates);
        }
    }

    public void clearCubes(CubeChangesCollector collector, ISkinPartType partType) {
        WorldUtils.clearCubes(collector, this.getTransform(), this.getSkinType(), this.getSkinProperties(), partType);
        if (partType != SkinPartTypes.UNKNOWN) {
            return;
        }
        boolean isMultiBlock = this.skinProperties.get(SkinProperty.BLOCK_MULTIBLOCK);
        this.skinProperties = new SkinProperties();
        this.skinProperties.put(SkinProperty.BLOCK_MULTIBLOCK, isMultiBlock);
        BlockUtils.combine(this, this::sendBlockUpdates);
    }

    public void replaceCubes(CubeChangesCollector collector, ISkinPartType partType, CubeReplacingEvent event) throws Exception {
        WorldUtils.replaceCubes(collector, this.getTransform(), this.getSkinType(), this.getSkinProperties(), event);
    }

    public void copyCubes(CubeChangesCollector collector, ISkinPartType srcPart, ISkinPartType destPart, boolean mirror) throws Exception {
        WorldUtils.copyCubes(collector, this.getTransform(), this.getSkinType(), this.getSkinProperties(), srcPart, destPart, mirror);
    }

    public void clearMarkers(CubeChangesCollector collector, ISkinPartType partType) {
        WorldUtils.clearMarkers(collector, this.getTransform(), this.getSkinType(), this.getSkinProperties(), partType);
        this.func_70296_d();
    }

    public boolean isModelOverridden(ISkinPartType partType) {
        ISkinProperty property = (ISkinProperty)PART_TO_MODEL.get((Object)partType);
        if (property != null) {
            return (Boolean)this.getSkinProperties().get(property);
        }
        return false;
    }

    public int getVersion() {
        return this.version;
    }

    public Object getRenderData() {
        return this.renderData;
    }

    public void setRenderData(Object renderData) {
        this.renderData = renderData;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox(BlockState blockState) {
        if (this.renderBoundingBox == null) {
            this.renderBoundingBox = new AxisAlignedBB(-32.0, -32.0, -44.0, 64.0, 64.0, 64.0);
            this.renderBoundingBox = this.renderBoundingBox.func_186670_a(this.func_174877_v());
        }
        return this.renderBoundingBox;
    }

    private void remakeSkinProperties() {
        String name = this.skinProperties.get(SkinProperty.ALL_CUSTOM_NAME);
        String flavour = this.skinProperties.get(SkinProperty.ALL_FLAVOUR_TEXT);
        this.skinProperties = new SkinProperties();
        this.skinProperties.put(SkinProperty.ALL_CUSTOM_NAME, name);
        this.skinProperties.put(SkinProperty.ALL_FLAVOUR_TEXT, flavour);
    }

    private boolean shouldAddBoundingBoxes(ISkinPartType partType) {
        if (this.isUseHelper()) {
            return this.isShowHelper();
        }
        return !this.isModelOverridden(partType);
    }

    private void remakeBoundingBoxes(Collection<BoundingBox> oldBoxes, Collection<BoundingBox> newBoxes, boolean forced) {
        World level = this.func_145831_w();
        if (level == null || level.func_201670_d()) {
            return;
        }
        if (!forced && Objects.equals(oldBoxes, newBoxes)) {
            return;
        }
        this.applyBoundingBoxes(oldBoxes, (partType, pos, offset) -> {
            WorldBlockUpdateTask task = new WorldBlockUpdateTask(level, pos, Blocks.field_150350_a.func_176223_P());
            task.setValidator(state -> state.func_203425_a((Block)ModBlocks.BOUNDING_BOX.get()));
            return task;
        });
        this.applyBoundingBoxes(newBoxes, (partType, pos, offset) -> {
            WorldBlockUpdateTask task = new WorldBlockUpdateTask(level, pos, ((Block)ModBlocks.BOUNDING_BOX.get()).func_176223_P());
            task.setValidator(state -> PropertyProvider.isReplaceable(state) || state.func_203425_a((Block)ModBlocks.BOUNDING_BOX.get()));
            task.setModifier(state -> this.setupBoundingBox(level, pos, offset, partType));
            return task;
        });
    }

    private void setupBoundingBox(World level, BlockPos pos, moe.plushie.armourers_workshop.utils.math.Vector3i offset, ISkinPartType partType) {
        BoundingBoxBlockEntity blockEntity = ObjectUtils.safeCast(level.func_175625_s(pos), BoundingBoxBlockEntity.class);
        if (blockEntity != null) {
            blockEntity.setPartType(partType);
            blockEntity.setGuide(offset);
            blockEntity.setParent(pos.func_177973_b((Vector3i)this.func_174877_v()));
            BlockUtils.combine(blockEntity, blockEntity::sendBlockUpdates);
        }
    }

    private void applyBoundingBoxes(@Nullable Collection<BoundingBox> boxes, IUpdateTaskBuilder builder) {
        if (boxes == null || boxes.isEmpty()) {
            return;
        }
        CubeTransform transform = this.getTransform();
        boxes.forEach(box -> box.forEach((ix, iy, iz) -> {
            BlockPos target = transform.mul(ix + box.getX(), iy + box.getY(), iz + box.getZ());
            ix = box.getWidth() - ix - 1;
            iy = box.getHeight() - iy - 1;
            ISkinPartType partType = box.getPartType();
            IWorldUpdateTask task = builder.build(partType, target, new moe.plushie.armourers_workshop.utils.math.Vector3i(ix, iy, iz));
            if (task != null) {
                WorldUpdater.getInstance().submit(task);
            }
        }));
    }

    private Collection<BoundingBox> getBoundingBoxes() {
        ArrayList<BoundingBox> boxes = new ArrayList<BoundingBox>();
        for (ISkinPartType iSkinPartType : this.skinType.getParts()) {
            if (!this.shouldAddBoundingBoxes(iSkinPartType)) continue;
            IVector3i offset = iSkinPartType.getOffset();
            IRectangle3i bounds = iSkinPartType.getBuildingSpace();
            Rectangle3i rect = new Rectangle3i(iSkinPartType.getGuideSpace());
            rect = rect.offset(-offset.getX(), -offset.getY() - bounds.getMinY(), offset.getZ());
            boxes.add(new BoundingBox(iSkinPartType, rect));
        }
        return boxes;
    }

    private Collection<BoundingBox> getFullBoundingBoxes() {
        ArrayList<BoundingBox> boxes = new ArrayList<BoundingBox>();
        for (ISkinPartType iSkinPartType : this.skinType.getParts()) {
            if (!this.shouldAddBoundingBoxes(iSkinPartType)) continue;
            IVector3i origin = iSkinPartType.getOffset();
            IRectangle3i buildSpace = iSkinPartType.getBuildingSpace();
            int dx = -origin.getX() + buildSpace.getX();
            int dy = -origin.getY();
            int dz = origin.getZ() + buildSpace.getZ();
            Rectangle3i rect = new Rectangle3i(dx, dy, dz, buildSpace.getWidth(), buildSpace.getHeight(), buildSpace.getDepth());
            boxes.add(new BoundingBox(iSkinPartType, rect));
        }
        return boxes;
    }

    public Direction getFacing() {
        return this.func_195044_w().func_235903_d_((Property)ArmourerBlock.field_185512_D).orElse(Direction.NORTH);
    }

    public CubeTransform getTransform() {
        BlockPos pos = this.func_174877_v().func_177982_a(0, 1, 0);
        return new CubeTransform(this.func_145831_w(), pos, this.getFacing());
    }

    public static interface IUpdateTaskBuilder {
        public IWorldUpdateTask build(ISkinPartType var1, BlockPos var2, moe.plushie.armourers_workshop.utils.math.Vector3i var3);
    }
}

