/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.blockentity;

import java.util.Map;
import moe.plushie.armourers_workshop.api.client.IBlockEntityExtendedRenderer;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.api.painting.IPaintable;
import moe.plushie.armourers_workshop.builder.block.ArmourerBlock;
import moe.plushie.armourers_workshop.core.blockentity.UpdatableBlockEntity;
import moe.plushie.armourers_workshop.core.data.color.BlockPaintColor;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import moe.plushie.armourers_workshop.core.skin.painting.SkinPaintTypes;
import moe.plushie.armourers_workshop.utils.BlockUtils;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;

public class SkinCubeBlockEntity
extends UpdatableBlockEntity
implements IPaintable,
IBlockEntityExtendedRenderer {
    protected BlockPaintColor colors = new BlockPaintColor(PaintColor.WHITE);
    protected boolean customRenderer = false;

    public SkinCubeBlockEntity(TileEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    @Override
    public void readFromNBT(CompoundNBT nbt) {
        this.colors.deserializeNBT(nbt.func_74775_l("Color"));
        this.customRenderer = this.checkRendererFromColors();
    }

    @Override
    public void writeToNBT(CompoundNBT nbt) {
        nbt.func_218657_a("Color", (INBT)this.colors.serializeNBT());
    }

    private boolean checkRendererFromColors() {
        for (IPaintColor color : this.colors.values()) {
            if (color.getPaintType() == SkinPaintTypes.NORMAL) continue;
            return true;
        }
        return false;
    }

    private Direction getResolvedDirection(Direction dir) {
        switch (this.getDirection()) {
            case SOUTH: {
                return Rotation.CLOCKWISE_180.func_185831_a(dir);
            }
            case WEST: {
                return Rotation.CLOCKWISE_90.func_185831_a(dir);
            }
            case EAST: {
                return Rotation.COUNTERCLOCKWISE_90.func_185831_a(dir);
            }
        }
        return dir;
    }

    @Override
    public IPaintColor getColor(Direction direction) {
        return this.colors.getOrDefault(this.getResolvedDirection(direction), PaintColor.WHITE);
    }

    @Override
    public void setColor(Direction direction, IPaintColor color) {
        this.colors.put(this.getResolvedDirection(direction), color);
        this.customRenderer = this.checkRendererFromColors();
        BlockUtils.combine(this, this::sendBlockUpdates);
    }

    @Override
    public void setColors(Map<Direction, IPaintColor> colors) {
        colors.forEach((direction, color) -> this.colors.put(this.getResolvedDirection((Direction)direction), (IPaintColor)color));
        this.customRenderer = this.checkRendererFromColors();
        BlockUtils.combine(this, this::sendBlockUpdates);
    }

    public Direction getDirection() {
        return this.func_195044_w().func_235903_d_((Property)ArmourerBlock.field_185512_D).orElse(Direction.NORTH);
    }

    @Override
    public boolean shouldUseExtendedRenderer() {
        return this.customRenderer;
    }
}

