/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.guide;

import moe.plushie.armourers_workshop.api.action.ICanHeld;
import moe.plushie.armourers_workshop.api.client.IBufferSource;
import moe.plushie.armourers_workshop.api.math.IPoseStack;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.guide.AbstractAdvancedGuideRenderer;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderType;
import moe.plushie.armourers_workshop.core.client.other.SkinVertexBufferBuilder;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocument;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentNode;
import moe.plushie.armourers_workshop.utils.ext.OpenModelPart;
import moe.plushie.armourers_workshop.utils.ext.OpenModelPartBuilder;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AdvancedItemGuideRenderer
extends AbstractAdvancedGuideRenderer {
    private final OpenModelPart armSolid = OpenModelPartBuilder.player().uv(40, 16).cube(-2.0f, -10.0f, -4.0f, 4.0f, 8.0f, 4.0f).offset(0.0f, 0.0f, 0.0f).build();
    private final OpenModelPart armTransparent = OpenModelPartBuilder.player().uv(40, 24).cube(-2.0f, -2.0f, -4.0f, 4.0f, 4.0f, 4.0f).offset(0.0f, 0.0f, 0.0f).build();

    @Override
    public void render(SkinDocument document, IPoseStack poseStack, int light, int overlay, IBufferSource bufferSource) {
        SkinDocumentNode node = this.findItemNode(document.getRoot());
        if (node == null) {
            return;
        }
        poseStack.pushPose();
        this.applyOffset(poseStack);
        SkinVertexBufferBuilder skinBufferSource = SkinVertexBufferBuilder.getBuffer(bufferSource);
        this.armSolid.render(poseStack, bufferSource.getBuffer(SkinRenderType.PLAYER_CUTOUT), 0xF000F0, overlay);
        this.armTransparent.render(poseStack, skinBufferSource.getBuffer(SkinRenderType.PLAYER_TRANSLUCENT), 0xF000F0, overlay, 1.0f, 1.0f, 1.0f, 0.75f);
        poseStack.popPose();
    }

    protected void applyOffset(IPoseStack poseStack) {
        poseStack.translate(0.0f, 2.0f, 0.0f);
        poseStack.rotate(Vector3f.XP.rotationDegrees(-90.0f));
        poseStack.scale(16.0f, 16.0f, 16.0f);
    }

    protected SkinDocumentNode findItemNode(SkinDocumentNode node) {
        if (node.getType() instanceof ICanHeld) {
            return node;
        }
        for (SkinDocumentNode child : node.children()) {
            SkinDocumentNode result = this.findItemNode(child);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

