/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.panel;

import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.impl.InputManagerImpl;
import com.apple.library.uikit.UIEvent;
import com.apple.library.uikit.UIView;
import java.util.Collection;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.math.IRectangle3f;
import moe.plushie.armourers_workshop.builder.blockentity.AdvancedBuilderBlockEntity;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.document.DocumentEditor;
import moe.plushie.armourers_workshop.builder.entity.CameraEntity;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.client.Options.FOVSupport;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkinPart;
import moe.plushie.armourers_workshop.utils.math.ClamppedVector3f;
import moe.plushie.armourers_workshop.utils.math.OpenBoundingBox;
import moe.plushie.armourers_workshop.utils.math.OpenMatrix4f;
import moe.plushie.armourers_workshop.utils.math.OpenNearPlane;
import moe.plushie.armourers_workshop.utils.math.OpenRay;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;

public class AdvancedCameraPanel
extends UIView {
    private CGPoint startMousePos = CGPoint.ZERO;
    private final Vector3f origin = new Vector3f();
    private final Vector3f oldRotation = new Vector3f();
    private final Vector3f oldTranslate = new Vector3f();
    private final Vector3f lastZoom = new ClamppedVector3f(1.0f, 1.0f, 1.0f, 0.1f, 0.1f, 0.1f, 2.0f, 2.0f, 2.0f);
    private final Vector3f lastRotation = new ClamppedVector3f(0.0f, 0.0f, 0.0f, -90.0f, Float.NEGATIVE_INFINITY, 0.0f, 90.0f, Float.POSITIVE_INFINITY, 0.0f);
    private final Vector3f lastTranslate = new Vector3f(0.0f, 0.0f, 0.0f);
    private final GameSettings options;
    private final AdvancedBuilderBlockEntity blockEntity;
    private final CameraEntity cameraEntity = new CameraEntity();
    private Collection<Node> cachedTree;
    boolean moveMode = false;
    boolean rotationMode = false;

    public AdvancedCameraPanel(DocumentEditor editor) {
        super(CGRect.ZERO);
        this.options = Minecraft.func_71410_x().field_71474_y;
        this.blockEntity = editor.getBlockEntity();
    }

    public void connect() {
        this.cameraEntity.connect();
        this.reset();
    }

    public void disconnect() {
        this.reset();
        this.cameraEntity.disconnect();
    }

    public void reset() {
        this.origin.set(this.blockEntity.getRenderOrigin());
        this.lastRotation.set(0.0f, 0.0f, 0.0f);
        this.lastTranslate.set(0.0f, 0.0f, 0.0f);
        this.lastZoom.set(1.0f, 1.0f, 1.0f);
        this.applyCameraChanges();
    }

    @Override
    public void mouseDown(UIEvent event) {
        boolean bl = this.rotationMode = event.type() != UIEvent.Type.MOUSE_RIGHT_DOWN;
        if (InputManagerImpl.hasSpaceDown()) {
            this.rotationMode = !this.rotationMode;
        }
        this.moveMode = !this.rotationMode;
        this.startMousePos = event.locationInWindow();
        this.oldRotation.set(this.lastRotation);
        this.oldTranslate.set(this.lastTranslate);
    }

    @Override
    public void mouseUp(UIEvent event) {
        this.oldRotation.set(this.lastRotation);
        this.oldTranslate.set(this.lastTranslate);
    }

    @Override
    public void mouseDragged(UIEvent event) {
        CGPoint mousePos = event.locationInWindow();
        if (this.moveMode) {
            float dx = mousePos.x - this.startMousePos.x;
            float dy = mousePos.y - this.startMousePos.y;
            this.move(new Vector3f(dx, dy, 0.0f));
        }
        if (this.rotationMode) {
            this.rotation(mousePos);
        }
        this.applyCameraChanges();
    }

    @Override
    public void mouseWheel(UIEvent event) {
        this.zoom(event.delta().getY());
    }

    @Override
    public void mouseMoved(UIEvent event) {
    }

    private void move(Vector3f delta) {
        CGRect window = this.bounds();
        OpenNearPlane plane = this.cameraEntity.getNearPlane();
        float near = FOVSupport.getCameraNear(this.options);
        float deltaX = -delta.getX() / (window.width / 2.0f);
        float deltaY = delta.getY() / (window.height / 2.0f);
        float deltaZ = near + delta.getZ();
        Vector3f d1 = plane.at(0.0f, 0.0f, -near);
        Vector3f d2 = plane.at(deltaX, deltaY, deltaZ);
        float x = this.oldTranslate.getX() + d1.getX() + d2.getX();
        float y = this.oldTranslate.getY() + d1.getY() + d2.getY();
        float z = this.oldTranslate.getZ() + d1.getZ() + d2.getZ();
        this.lastTranslate.set(x, y, z);
    }

    private void rotation(CGPoint mousePos) {
        CGRect window = this.bounds();
        float dx = (mousePos.y - this.startMousePos.y) / window.height;
        float dy = (mousePos.x - this.startMousePos.x) / window.width;
        float rx = this.oldRotation.getX() + dx * 360.0f;
        float ry = this.oldRotation.getY() + dy * 360.0f;
        this.lastRotation.set(rx, ry, 0.0f);
    }

    private void zoom(double delta) {
        float scale = this.lastZoom.getX();
        if (delta < 0.0) {
            scale /= 0.99f;
        } else if (delta > 0.0) {
            scale *= 0.99f;
        }
        this.lastZoom.set(scale, scale, scale);
        this.applyCameraChanges();
    }

    public void applyCameraChanges() {
        float tx = this.lastTranslate.getX();
        float ty = this.lastTranslate.getY();
        float tz = this.lastTranslate.getZ();
        float rx = this.lastRotation.getX();
        float ry = this.lastRotation.getY();
        float rz = this.lastRotation.getZ();
        this.blockEntity.carmeOffset.set(tx, ty, tz);
        this.blockEntity.carmeRot.set(rx, ry, rz);
        this.cameraEntity.setZoom(this.lastZoom.getZ());
        PropertyProvider.setXRot((Entity)this.cameraEntity, rx);
        PropertyProvider.setYRot((Entity)this.cameraEntity, ry);
        this.cameraEntity.func_70107_b(this.origin.getX() + tx, this.origin.getY() + ty, this.origin.getZ() + tz);
        PropertyProvider.setOldPosAndRot((Entity)this.cameraEntity);
    }

    public static class Node {
        final OpenMatrix4f invMat;
        final BakedSkinPart part;
        final OpenBoundingBox box;

        Node(BakedSkinPart part, OpenMatrix4f invMat) {
            this.part = part;
            this.invMat = invMat;
            this.box = part.getRenderShape().aabb();
        }

        public void raycast(OpenRay ray, Consumer<Result> recorder) {
            OpenRay ray1 = ray.transforming(this.invMat);
            if (!this.box.intersects(ray1)) {
                return;
            }
            Result[] result = new Result[]{null};
            this.part.forEach(ray1, face -> {
                IRectangle3f shape = face.getShape();
                float distance = ray1.origin.distanceToSquared(shape.getMinX(), shape.getMinY(), shape.getMinZ());
                if (result[0] == null) {
                    result[0] = new Result(this.part, distance);
                } else {
                    result[0].distance = Math.min(result[0].distance, distance);
                }
            });
            if (result[0] != null) {
                recorder.accept(result[0]);
            }
        }
    }

    public static class Result {
        final BakedSkinPart part;
        float distance;

        Result(BakedSkinPart part, float distance) {
            this.part = part;
            this.distance = distance;
        }
    }
}

