/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.armourer;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UIImage;
import moe.plushie.armourers_workshop.builder.blockentity.ArmourerBlockEntity;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.ArmourerBaseSetting;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.ArmourerBlockSetting;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.ArmourerDisplaySetting;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.ArmourerMainSetting;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.ArmourerSkinSetting;
import moe.plushie.armourers_workshop.builder.menu.ArmourerMenu;
import moe.plushie.armourers_workshop.core.client.gui.widget.MenuWindow;
import moe.plushie.armourers_workshop.core.client.gui.widget.PlayerInventoryView;
import moe.plushie.armourers_workshop.core.client.gui.widget.TabView;
import moe.plushie.armourers_workshop.init.ModTextures;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ArmourerWindow
extends MenuWindow<ArmourerMenu> {
    private final ArmourerBlockEntity blockEntity;
    private final TabView tabView = new TabView(new CGRect(0.0f, 0.0f, 176.0f, 224.0f));
    private int lastVersion = 0;

    public ArmourerWindow(ArmourerMenu container, PlayerInventory inventory, NSString title) {
        super(container, inventory, title);
        this.setFrame(new CGRect(0.0f, 0.0f, 176.0f, 224.0f));
        this.setBackgroundView(ModTextures.defaultWindowImage());
        this.inventoryView.setStyle(PlayerInventoryView.Style.COMPACT);
        this.inventoryView.setUserInteractionEnabled(false);
        this.blockEntity = (ArmourerBlockEntity)container.getBlockEntity();
    }

    @Override
    public void init() {
        super.init();
        this.setupTabView();
        this.bringSubviewToFront(this.titleView);
        this.bringSubviewToFront(this.inventoryView);
    }

    private void setupTabView() {
        this.addTab(new ArmourerMainSetting((ArmourerMenu)this.menu)).setTarget((Object)ArmourerMenu.Group.MAIN).setIcon(this.tabIcon(0, 0, 8, 150));
        this.addTab(new ArmourerDisplaySetting((ArmourerMenu)this.menu)).setTarget((Object)ArmourerMenu.Group.DISPLAY).setIcon(this.tabIcon(16, 0, 8, 150));
        this.addTab(new ArmourerSkinSetting((ArmourerMenu)this.menu)).setTarget((Object)ArmourerMenu.Group.SKIN).setIcon(this.tabIcon(32, 0, 8, 150));
        this.addTab(new ArmourerBlockSetting((ArmourerMenu)this.menu)).setTarget((Object)ArmourerMenu.Group.BLOCK).setIcon(this.tabIcon(48, 0, 8, 150));
        this.tabView.addTarget(this, ArmourerWindow::switchTab);
        this.tabView.setSelectedTab(this.tabView.firstActiveTab());
        this.addSubview(this.tabView);
    }

    @Override
    public void screenWillTick() {
        super.screenWillTick();
        int lastVersion = this.blockEntity.getVersion();
        if (this.lastVersion != lastVersion) {
            this.tabView.tabs().forEach(tab -> {
                ArmourerBaseSetting setting = ObjectUtils.safeCast(tab.contentView(), ArmourerBaseSetting.class);
                if (setting != null) {
                    setting.reloadData();
                }
            });
            this.lastVersion = lastVersion;
        }
    }

    private void switchTab(TabView.Entry entry) {
        ArmourerMenu.Group group = ArmourerMenu.Group.MAIN;
        Object value = entry.target();
        if (value != null) {
            group = (ArmourerMenu.Group)((Object)value);
        }
        ((ArmourerMenu)this.menu).setGroup(group);
        this.inventoryView.setHidden(!((ArmourerMenu)this.menu).shouldRenderInventory());
        ArmourerBaseSetting setting = ObjectUtils.safeCast(entry.contentView(), ArmourerBaseSetting.class);
        if (setting != null) {
            setting.reloadData();
        }
    }

    private TabView.EntryBuilder addTab(ArmourerBaseSetting contentView) {
        contentView.init();
        return this.tabView.addContentView(contentView).setTooltip(contentView.getTitle());
    }

    private UIImage tabIcon(int u, int v, int frame, int speed) {
        return UIImage.of(ModTextures.TAB_ICONS).uv(u, v).fixed(16.0f, 16.0f).animation(frame, speed).build();
    }
}

