/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.armourer.guide;

import moe.plushie.armourers_workshop.api.client.IBufferSource;
import moe.plushie.armourers_workshop.api.client.guide.IGuideDataProvider;
import moe.plushie.armourers_workshop.api.math.IPoseStack;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.guide.AbstractGuideRenderer;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.guide.GuideRendererManager;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderType;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.utils.ext.OpenModelPart;
import moe.plushie.armourers_workshop.utils.ext.OpenModelPartBuilder;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ChestGuideRenderer
extends AbstractGuideRenderer {
    protected final OpenModelPart body = OpenModelPartBuilder.player().uv(16, 16).cube(-4.0f, -12.0f, -2.0f, 8.0f, 12.0f, 4.0f).build();
    protected final OpenModelPart leftArm = OpenModelPartBuilder.player().uv(32, 48).cube(-1.0f, -12.0f, -2.0f, 4.0f, 12.0f, 4.0f).build();
    protected final OpenModelPart rightArm = OpenModelPartBuilder.player().uv(40, 16).cube(-3.0f, -12.0f, -2.0f, 4.0f, 12.0f, 4.0f).build();
    protected final OpenModelPart jacket;
    protected final OpenModelPart leftSleeve = OpenModelPartBuilder.player().uv(48, 48).cube(-1.0f, -12.0f, -2.0f, 4.0f, 12.0f, 4.0f, 0.25f).build();
    protected final OpenModelPart rightSleeve = OpenModelPartBuilder.player().uv(40, 32).cube(-3.0f, -12.0f, -2.0f, 4.0f, 12.0f, 4.0f, 0.25f).build();

    public ChestGuideRenderer() {
        this.jacket = OpenModelPartBuilder.player().uv(16, 32).cube(-4.0f, -12.0f, -2.0f, 8.0f, 12.0f, 4.0f, 0.25f).build();
    }

    @Override
    public void init(GuideRendererManager rendererManager) {
        rendererManager.register(SkinPartTypes.BIPPED_CHEST, this::render);
        rendererManager.register(SkinPartTypes.BIPPED_LEFT_ARM, this::renderLeftArm);
        rendererManager.register(SkinPartTypes.BIPPED_RIGHT_ARM, this::renderRightArm);
    }

    public void render(IPoseStack poseStack, IGuideDataProvider provider, int light, int overlay, IBufferSource bufferSource) {
        this.body.render(poseStack, bufferSource.getBuffer(SkinRenderType.PLAYER_CUTOUT), light, overlay);
        if (provider.shouldRenderOverlay(SkinProperty.OVERRIDE_OVERLAY_JACKET)) {
            this.jacket.render(poseStack, bufferSource.getBuffer(SkinRenderType.PLAYER_CUTOUT_NO_CULL), light, overlay);
        }
    }

    public void renderLeftArm(IPoseStack poseStack, IGuideDataProvider provider, int light, int overlay, IBufferSource bufferSource) {
        this.leftArm.render(poseStack, bufferSource.getBuffer(SkinRenderType.PLAYER_CUTOUT), light, overlay);
        if (provider.shouldRenderOverlay(SkinProperty.OVERRIDE_OVERLAY_LEFT_SLEEVE)) {
            this.leftSleeve.render(poseStack, bufferSource.getBuffer(SkinRenderType.PLAYER_CUTOUT_NO_CULL), light, overlay);
        }
    }

    public void renderRightArm(IPoseStack poseStack, IGuideDataProvider provider, int light, int overlay, IBufferSource bufferSource) {
        this.rightArm.render(poseStack, bufferSource.getBuffer(SkinRenderType.PLAYER_CUTOUT), light, overlay);
        if (provider.shouldRenderOverlay(SkinProperty.OVERRIDE_OVERLAY_RIGHT_SLEEVE)) {
            this.rightSleeve.render(poseStack, bufferSource.getBuffer(SkinRenderType.PLAYER_CUTOUT_NO_CULL), light, overlay);
        }
    }
}

