/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.widget;

import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.coregraphics.CGSize;
import com.apple.library.foundation.NSString;
import com.apple.library.foundation.NSTextAlignment;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UILabel;
import com.apple.library.uikit.UIMenuPopoverView;
import com.apple.library.uikit.UIScrollView;
import com.apple.library.uikit.UIView;
import com.apple.library.uikit.UIWindow;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import moe.plushie.armourers_workshop.builder.client.gui.widget.PartItem;
import moe.plushie.armourers_workshop.builder.client.gui.widget.PartItemList;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.player.Player.PropertyProvider;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;

public class PartPickerView
extends UIControl {
    protected SkinDescriptor selectedPart = SkinDescriptor.EMPTY;
    protected Collection<SkinDescriptor> historySkins;
    protected Consumer<SkinDescriptor> itemSelector;
    protected Runnable itemImporter;
    protected Predicate<SkinDescriptor> filter;
    protected final UIScrollView scrollView = new UIScrollView(CGRect.ZERO);
    protected final ArrayList<PartItemList> itemLists = new ArrayList();

    public PartPickerView(CGRect frame) {
        super(frame);
        this.scrollView.setFrame(this.bounds());
        this.addSubview(this.scrollView);
    }

    public void showInView(UIView fromView) {
        UIWindow window = fromView.window();
        if (window == null) {
            return;
        }
        this.setupData();
        CGRect bounds = this.bounds().applying(this.transform());
        CGRect rect = fromView.convertRectToView(fromView.bounds(), window).copy();
        if (rect.x + bounds.width > window.bounds().getMaxX()) {
            rect.x -= bounds.width;
        }
        rect.x += bounds.width / 2.0f;
        rect.y += bounds.height / 2.0f;
        this.setCenter(new CGPoint(rect.x, rect.y));
        UIMenuPopoverView popoverView = new UIMenuPopoverView();
        popoverView.setBackgroundColor(null);
        popoverView.setContentView(this);
        popoverView.showInView(fromView);
    }

    public void dismiss() {
        UIMenuPopoverView popoverView = ObjectUtils.safeCast(this.window(), UIMenuPopoverView.class);
        if (popoverView != null) {
            popoverView.dismiss();
        }
    }

    public SkinDescriptor getSelectedPart() {
        return this.selectedPart;
    }

    public void setSelectedPart(SkinDescriptor selectedItem) {
        this.selectedPart = selectedItem;
        this.itemLists.forEach(it -> it.setSelectedItem(selectedItem));
        if (this.itemSelector != null) {
            this.itemSelector.accept(selectedItem);
        }
        this.dismiss();
    }

    private void importPartAction() {
        this.dismiss();
        if (this.itemImporter != null) {
            this.itemImporter.run();
        }
    }

    private void selectPartAction(PartItem selectedItem) {
        if (selectedItem == PartItem.IMPORT) {
            this.importPartAction();
            return;
        }
        this.setSelectedPart(selectedItem.getDescriptor());
    }

    public Consumer<SkinDescriptor> getItemSelector() {
        return this.itemSelector;
    }

    public void setChangeListener(Consumer<SkinDescriptor> itemSelector) {
        this.itemSelector = itemSelector;
    }

    public void setHistorySkins(Collection<SkinDescriptor> historySkins) {
        this.historySkins = historySkins;
    }

    public Collection<SkinDescriptor> getHistorySkins() {
        return this.historySkins;
    }

    public void setImporter(Runnable itemImporter) {
        this.itemImporter = itemImporter;
    }

    public Runnable getImporter() {
        return this.itemImporter;
    }

    public void setFilter(Predicate<SkinDescriptor> filter) {
        this.filter = filter;
    }

    public Predicate<SkinDescriptor> getFilter() {
        return this.filter;
    }

    private void setupData() {
        ArrayList<List<PartItem>> items = new ArrayList<List<PartItem>>();
        items.add(Lists.newArrayList((Object[])new PartItem[]{PartItem.IMPORT, PartItem.CLEAR}));
        items.add(this.getInventorySkins().stream().filter(this::isValid).collect(Collectors.toList()));
        items.add(this.getImportedSkins().stream().filter(this::isValid).collect(Collectors.toList()));
        this.buildSections(items);
    }

    private void buildSections(List<List<PartItem>> sections) {
        float x = 4.0f;
        float y = 4.0f;
        float width = this.bounds().getWidth() - 8.0f;
        float height = this.bounds().getHeight() - 8.0f;
        for (int i = 0; i < sections.size(); ++i) {
            UIView contentView;
            List<PartItem> items = sections.get(i);
            UILabel titleView = new UILabel(new CGRect(x, y, width, 10.0f));
            titleView.setTextColor(UIColor.WHITE);
            titleView.setText(NSString.localizedString("advanced-skin-builder.picker.section" + (i + 1), new Object[0]));
            if (items.isEmpty()) {
                UILabel emptyView = new UILabel(new CGRect(x, y + 12.0f, width, 65.0f));
                emptyView.setText(NSString.localizedString("advanced-skin-builder.picker.section" + (i + 1) + ".empty", new Object[0]));
                emptyView.setTextColor(UIColor.LIGHT_GRAY);
                emptyView.setNumberOfLines(0);
                emptyView.setTextHorizontalAlignment(NSTextAlignment.Horizontal.CENTER);
                emptyView.setBackgroundColor(UIColor.rgba(0x22AAAAAA));
                contentView = emptyView;
            } else {
                PartItemList sectionView = this.buildSectionView(x, y + 12.0f, width, height);
                sectionView.setEntries(new ArrayList<PartItem>(items));
                CGSize size = sectionView.sizeThatFits(new CGSize(width, height));
                sectionView.setFrame(new CGRect(x, y + 12.0f, size.getWidth(), size.getHeight()));
                sectionView.reloadData();
                contentView = sectionView;
            }
            this.scrollView.addSubview(titleView);
            this.scrollView.addSubview(contentView);
            y = contentView.frame().getMaxY() + 10.0f;
        }
        this.scrollView.setContentSize(new CGSize(width, y));
    }

    private PartItemList buildSectionView(float x, float y, float width, float height) {
        PartItemList fileList = new PartItemList(new CGRect(x, y, width, height));
        fileList.setItemSize(new CGSize(32.0f, 32.0f));
        fileList.setBackgroundColor(0);
        fileList.setShowsName(false);
        fileList.setSelectedItem(this.selectedPart);
        fileList.setItemSelector(this::selectPartAction);
        this.itemLists.add(fileList);
        return fileList;
    }

    private boolean isValid(PartItem item) {
        return this.filter == null || this.filter.test(item.getDescriptor());
    }

    private ArrayList<PartItem> getInventorySkins() {
        ArrayList<PartItem> allSkins = new ArrayList<PartItem>();
        PlayerEntity player = EnvironmentManager.getPlayer();
        if (player == null) {
            return allSkins;
        }
        PlayerInventory inventory = PropertyProvider.getInventory(player);
        int containerSize = inventory.func_70302_i_();
        for (int i = 0; i < containerSize; ++i) {
            ItemStack itemStack = inventory.func_70301_a(i);
            SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
            if (descriptor.isEmpty()) continue;
            allSkins.add(new PartItem(descriptor, itemStack));
        }
        return allSkins;
    }

    private ArrayList<PartItem> getImportedSkins() {
        ArrayList<PartItem> allSkins = new ArrayList<PartItem>();
        if (this.historySkins != null) {
            this.historySkins.forEach(it -> allSkins.add(new PartItem((SkinDescriptor)it)));
            return allSkins;
        }
        return allSkins;
    }
}

