/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.data.properties;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.data.IDataProperty;

public class DataProperty<T>
implements IDataProperty<T> {
    protected T value;
    protected Consumer<Boolean> editingObserver;
    protected final ArrayList<Consumer<T>> valueObservers = new ArrayList();

    @Override
    public void beginEditing() {
        if (this.editingObserver != null) {
            this.editingObserver.accept(true);
        }
    }

    @Override
    public void endEditing() {
        if (this.editingObserver != null) {
            this.editingObserver.accept(false);
        }
    }

    @Override
    public void set(T value) {
        if (Objects.equal(this.value, value)) {
            return;
        }
        this.value = value;
        this.valueObservers.forEach((Consumer<Consumer<T>>)((Consumer<Consumer>)it -> it.accept(value)));
    }

    @Override
    public T get() {
        return this.value;
    }

    @Override
    public void addObserver(Consumer<T> observer) {
        this.valueObservers.add(observer);
    }

    public void addEditingObserver(Consumer<Boolean> observer) {
        this.editingObserver = observer;
    }
}

