/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.data.undo.action;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import moe.plushie.armourers_workshop.api.action.IUserAction;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.api.painting.IPaintable;
import moe.plushie.armourers_workshop.builder.data.undo.action.BlockUserAction;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SetBlockColorAction
extends BlockUserAction {
    private final ImmutableMap<Direction, IPaintColor> newValue;

    public SetBlockColorAction(World level, BlockPos pos, HashMap<Direction, IPaintColor> newValue) {
        super(level, pos);
        this.newValue = ImmutableMap.copyOf(newValue);
    }

    @Override
    public IUserAction apply() throws RuntimeException {
        IPaintable target = (IPaintable)this.getBlockEntity();
        HashMap<Direction, IPaintColor> oldValue = new HashMap<Direction, IPaintColor>();
        for (Direction direction : this.newValue.keySet()) {
            IPaintColor paintColor = target.getColor(direction);
            if (paintColor == null) {
                paintColor = PaintColor.CLEAR;
            }
            oldValue.put(direction, paintColor);
        }
        SetBlockColorAction revertAction = new SetBlockColorAction(this.level, this.blockPos, oldValue);
        target.setColors((Map<Direction, IPaintColor>)this.newValue);
        return revertAction;
    }

    @Override
    public TileEntity getBlockEntity() {
        TileEntity blockEntity = super.getBlockEntity();
        if (blockEntity instanceof IPaintable) {
            return blockEntity;
        }
        return null;
    }
}

