/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.item;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.common.IConfigurableToolProperty;
import moe.plushie.armourers_workshop.api.painting.IBlockPaintViewer;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.api.registry.IRegistryKey;
import moe.plushie.armourers_workshop.builder.blockentity.ArmourerBlockEntity;
import moe.plushie.armourers_workshop.builder.item.AbstractColoredToolItem;
import moe.plushie.armourers_workshop.builder.item.impl.IPaintToolAction;
import moe.plushie.armourers_workshop.builder.item.impl.IPaintToolSelector;
import moe.plushie.armourers_workshop.builder.item.option.PaintingToolOptions;
import moe.plushie.armourers_workshop.builder.other.CubeChangesCollector;
import moe.plushie.armourers_workshop.builder.other.CubePaintingEvent;
import moe.plushie.armourers_workshop.builder.other.CubeSelector;
import moe.plushie.armourers_workshop.builder.other.CubeWrapper;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import moe.plushie.armourers_workshop.core.skin.painting.SkinPaintTypes;
import moe.plushie.armourers_workshop.init.ModSounds;
import moe.plushie.armourers_workshop.utils.ColorUtils;
import moe.plushie.armourers_workshop.utils.TranslateUtils;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;

public class BlendingToolItem
extends AbstractColoredToolItem
implements IBlockPaintViewer {
    public BlendingToolItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public void createToolProperties(Consumer<IConfigurableToolProperty<?>> builder) {
        builder.accept(PaintingToolOptions.INTENSITY);
        builder.accept(PaintingToolOptions.RADIUS_SAMPLE);
        builder.accept(PaintingToolOptions.RADIUS_EFFECT);
        builder.accept(PaintingToolOptions.PLANE_RESTRICT);
        builder.accept(PaintingToolOptions.FULL_BLOCK_MODE);
    }

    protected CubeSelector createColorApplierSelector(int radius, ItemUseContext context) {
        ItemStack itemStack = context.func_195996_i();
        boolean restrictPlane = (Boolean)PaintingToolOptions.PLANE_RESTRICT.get(itemStack);
        boolean isFullMode = this.shouldUseFullMode(context);
        return CubeSelector.touching(context.func_195995_a(), radius, isFullMode, restrictPlane);
    }

    @Override
    public IPaintToolSelector createPaintToolSelector(TileEntity blockEntity, ItemUseContext context) {
        if (blockEntity instanceof ArmourerBlockEntity) {
            return null;
        }
        return super.createPaintToolSelector(blockEntity, context);
    }

    @Override
    public IPaintToolSelector createPaintToolSelector(ItemUseContext context) {
        ItemStack itemStack = context.func_195996_i();
        int radiusEffect = (Integer)PaintingToolOptions.RADIUS_EFFECT.get(itemStack);
        return this.createColorApplierSelector(radiusEffect, context);
    }

    @Override
    public IPaintToolAction createPaintToolAction(ItemUseContext context) {
        ItemStack itemStack = context.func_195996_i();
        int intensity = (Integer)PaintingToolOptions.INTENSITY.get(itemStack);
        int radiusSample = (Integer)PaintingToolOptions.RADIUS_SAMPLE.get(itemStack);
        ArrayList<Integer> colors = new ArrayList<Integer>();
        CubeChangesCollector collector = new CubeChangesCollector(context.func_195991_k());
        this.createColorApplierSelector(radiusSample, context).forEach(context, (targetPos, dir) -> {
            IPaintColor paintColor;
            CubeWrapper cube = collector.getCube((BlockPos)targetPos);
            if (cube.shouldChangeColor((Direction)dir) && (paintColor = cube.getColor((Direction)dir)) != null) {
                colors.add(paintColor.getRGB());
            }
        });
        PaintColor paintColor = PaintColor.of(ColorUtils.getAverageColor(colors), SkinPaintTypes.NORMAL);
        return new CubePaintingEvent.BlendingAction(paintColor, intensity);
    }

    @Override
    public void appendSettingHoverText(ItemStack itemStack, List<ITextComponent> tooltips) {
        int intensity = (Integer)PaintingToolOptions.INTENSITY.get(itemStack);
        int radiusSample = (Integer)PaintingToolOptions.RADIUS_SAMPLE.get(itemStack);
        int radiusEffect = (Integer)PaintingToolOptions.RADIUS_EFFECT.get(itemStack);
        tooltips.add((ITextComponent)TranslateUtils.subtitle("item.armourers_workshop.rollover.intensity", intensity));
        tooltips.add((ITextComponent)TranslateUtils.subtitle("item.armourers_workshop.rollover.sampleRadius", radiusSample, radiusSample, 1));
        tooltips.add((ITextComponent)TranslateUtils.subtitle("item.armourers_workshop.rollover.effectRadius", radiusEffect, radiusEffect, 1));
        super.appendSettingHoverText(itemStack, tooltips);
    }

    @Override
    public IRegistryKey<SoundEvent> getItemSoundEvent(ItemUseContext context) {
        return ModSounds.PAINT;
    }
}

