/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.item;

import java.util.List;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.common.IConfigurableToolProperty;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.api.registry.IRegistryKey;
import moe.plushie.armourers_workshop.builder.item.PaintbrushItem;
import moe.plushie.armourers_workshop.builder.item.impl.IPaintToolAction;
import moe.plushie.armourers_workshop.builder.item.option.PaintingToolOptions;
import moe.plushie.armourers_workshop.builder.other.CubePaintingEvent;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import moe.plushie.armourers_workshop.init.ModSounds;
import moe.plushie.armourers_workshop.utils.ColorUtils;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;

public class HueToolItem
extends PaintbrushItem {
    public HueToolItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public void createToolProperties(Consumer<IConfigurableToolProperty<?>> builder) {
        builder.accept(PaintingToolOptions.CHANGE_HUE);
        builder.accept(PaintingToolOptions.CHANGE_SATURATION);
        builder.accept(PaintingToolOptions.CHANGE_BRIGHTNESS);
        builder.accept(PaintingToolOptions.CHANGE_PAINT_TYPE);
        super.createToolProperties(builder);
    }

    @Override
    public IPaintToolAction createPaintToolAction(ItemUseContext context) {
        ItemStack itemStack = context.func_195996_i();
        IPaintColor paintColor = this.getItemColor(itemStack, PaintColor.WHITE);
        boolean hue = (Boolean)PaintingToolOptions.CHANGE_HUE.get(itemStack);
        boolean saturation = (Boolean)PaintingToolOptions.CHANGE_SATURATION.get(itemStack);
        boolean brightness = (Boolean)PaintingToolOptions.CHANGE_BRIGHTNESS.get(itemStack);
        boolean paintType = (Boolean)PaintingToolOptions.CHANGE_PAINT_TYPE.get(itemStack);
        return new CubePaintingEvent.HueAction(paintColor, hue, saturation, brightness, paintType);
    }

    @Override
    public void appendColorHoverText(ItemStack itemStack, List<ITextComponent> tooltips) {
        IPaintColor paintColor = this.getItemColor(itemStack, PaintColor.WHITE);
        tooltips.addAll(ColorUtils.getColorTooltips(paintColor, true));
    }

    @Override
    public IRegistryKey<SoundEvent> getItemSoundEvent(ItemUseContext context) {
        return ModSounds.PAINT;
    }
}

