/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.builder.blockentity.AdvancedBuilderBlockEntity;
import moe.plushie.armourers_workshop.builder.menu.AdvancedBuilderMenu;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinLoader;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentNode;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.ModPermissions;
import moe.plushie.armourers_workshop.library.data.SkinLibraryManager;
import moe.plushie.armourers_workshop.utils.SkinFileStreamUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class AdvancedImportPacket
extends CustomPacket {
    private final BlockPos pos;
    private final Skin skin;
    private final String target;

    public AdvancedImportPacket(AdvancedBuilderBlockEntity blockEntity, Skin skin, String target) {
        this.pos = blockEntity.func_174877_v();
        this.skin = skin;
        this.target = target;
    }

    public AdvancedImportPacket(PacketBuffer buffer) {
        this.pos = buffer.func_179259_c();
        this.target = buffer.func_218666_n();
        this.skin = this.decodeSkin(buffer);
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos);
        buffer.func_180714_a(this.target);
        this.encodeSkin(buffer);
    }

    @Override
    public void accept(IServerPacketHandler packetHandler, ServerPlayerEntity player) {
        TileEntity blockEntity = player.func_71121_q().func_175625_s(this.pos);
        if (!(blockEntity instanceof AdvancedBuilderBlockEntity) || !(player.field_71070_bA instanceof AdvancedBuilderMenu) || this.skin == null) {
            this.abort((PlayerEntity)player, "unauthorized", "user status is incorrect or the skin is invalid");
            return;
        }
        SkinLibraryManager.Server server = SkinLibraryManager.getServer();
        if (!((SkinLibraryManager)server).shouldUploadFile((PlayerEntity)player)) {
            this.abort((PlayerEntity)player, "import", "uploading prohibited in the config file");
            return;
        }
        if (!ModPermissions.ADVANCED_SKIN_BUILDER_SKIN_IMPORT.accept((PlayerEntity)player)) {
            this.abort((PlayerEntity)player, "import", "prohibited by the config file");
            return;
        }
        if (!this.skin.getSettings().isEditable()) {
            this.abort((PlayerEntity)player, "import", "prohibited by the skin can't editing.");
            return;
        }
        SkinDocumentNode node = null;
        AdvancedBuilderBlockEntity blockEntity1 = (AdvancedBuilderBlockEntity)blockEntity;
        if (!this.target.isEmpty() && (node = blockEntity1.getDocument().nodeById(this.target)) == null) {
            this.abort((PlayerEntity)player, "import", "can't found node.");
            return;
        }
        this.accept((PlayerEntity)player, "import");
        String identifier = SkinLoader.getInstance().saveSkin("", this.skin);
        if (node != null) {
            blockEntity1.importToNode(identifier, this.skin, node);
        } else {
            blockEntity1.importToDocument(identifier, this.skin);
        }
    }

    private void accept(PlayerEntity player, String op) {
        String playerName = player.func_195047_I_();
        ModLog.info("accept {} request of the '{}'", op, playerName);
    }

    private void abort(PlayerEntity player, String op, String reason) {
        String playerName = player.func_195047_I_();
        ModLog.info("abort {} request of the '{}', reason: '{}'", op, playerName, reason);
    }

    private void encodeSkin(PacketBuffer buffer) {
        try {
            GZIPOutputStream stream = new GZIPOutputStream((OutputStream)new ByteBufOutputStream((ByteBuf)buffer));
            SkinFileStreamUtils.saveSkinToStream(stream, this.skin);
            stream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Skin decodeSkin(PacketBuffer buffer) {
        Skin skin = null;
        try {
            GZIPInputStream stream = new GZIPInputStream((InputStream)new ByteBufInputStream((ByteBuf)buffer));
            skin = SkinFileStreamUtils.loadSkinFromStream(stream);
            stream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return skin;
    }
}

