/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.other;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.builder.item.impl.IPaintToolSelector;
import moe.plushie.armourers_workshop.init.ModBlocks;
import moe.plushie.armourers_workshop.utils.BlockUtils;
import moe.plushie.armourers_workshop.utils.math.Rectangle3i;
import moe.plushie.armourers_workshop.utils.math.Vector3i;
import net.minecraft.block.Block;
import net.minecraft.item.ItemUseContext;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CubeSelector
implements IPaintToolSelector {
    final BlockPos blockPos;
    final MatchMode mode;
    final ArrayList<Rectangle3i> rects;
    final int radius;
    final boolean isPlaneOnly;
    final boolean isApplyAllFaces;

    protected CubeSelector(MatchMode mode, BlockPos blockPos, int radius, boolean isApplyAllFaces, boolean isPlaneOnly) {
        this.blockPos = blockPos;
        this.mode = mode;
        this.radius = Math.max(radius, 1);
        this.isApplyAllFaces = isApplyAllFaces;
        this.isPlaneOnly = isPlaneOnly;
        this.rects = new ArrayList();
    }

    protected CubeSelector(MatchMode mode, Iterable<Rectangle3i> rects) {
        this.blockPos = BlockPos.field_177992_a;
        this.mode = mode;
        this.radius = 0;
        this.isApplyAllFaces = true;
        this.isPlaneOnly = false;
        this.rects = Lists.newArrayList(rects);
    }

    protected CubeSelector(PacketBuffer buffer) {
        this.blockPos = buffer.func_179259_c();
        this.mode = (MatchMode)buffer.func_179257_a(MatchMode.class);
        this.radius = buffer.readInt();
        this.isApplyAllFaces = buffer.readBoolean();
        this.isPlaneOnly = buffer.readBoolean();
        this.rects = new ArrayList();
        if (this.mode == MatchMode.ALL) {
            int size = buffer.readInt();
            for (int i = 0; i < size; ++i) {
                int x = buffer.readInt();
                int y = buffer.readInt();
                int z = buffer.readInt();
                int width = buffer.readInt();
                int height = buffer.readInt();
                int depth = buffer.readInt();
                this.rects.add(new Rectangle3i(x, y, z, width, height, depth));
            }
        }
    }

    public static CubeSelector from(PacketBuffer buffer) {
        return new CubeSelector(buffer);
    }

    public static CubeSelector box(BlockPos pos, boolean isApplyAllFaces) {
        return CubeSelector.box(pos, 1, isApplyAllFaces);
    }

    public static CubeSelector box(BlockPos pos, int radius, boolean isApplyAllFaces) {
        return new CubeSelector(MatchMode.SAME, pos, radius, isApplyAllFaces, false);
    }

    public static CubeSelector all(Iterable<Rectangle3i> rects) {
        return new CubeSelector(MatchMode.ALL, rects);
    }

    public static CubeSelector plane(BlockPos pos, int radius, boolean isApplyAllFaces) {
        return new CubeSelector(MatchMode.SAME, pos, radius, isApplyAllFaces, true);
    }

    public static CubeSelector touching(BlockPos pos, int radius, boolean isApplyAllFaces, boolean isPlaneOnly) {
        return new CubeSelector(MatchMode.TOUCHING, pos, radius, isApplyAllFaces, isPlaneOnly);
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179255_a(this.blockPos);
        buffer.func_179249_a((Enum)this.mode);
        buffer.writeInt(this.radius);
        buffer.writeBoolean(this.isApplyAllFaces);
        buffer.writeBoolean(this.isPlaneOnly);
        if (this.mode == MatchMode.ALL) {
            buffer.writeInt(this.rects.size());
            for (Rectangle3i rect : this.rects) {
                buffer.writeInt(rect.getX());
                buffer.writeInt(rect.getY());
                buffer.writeInt(rect.getZ());
                buffer.writeInt(rect.getWidth());
                buffer.writeInt(rect.getHeight());
                buffer.writeInt(rect.getDepth());
            }
        }
    }

    @Override
    public void forEach(ItemUseContext context, BiConsumer<BlockPos, Direction> consumer) {
        World level = context.func_195991_k();
        Direction clickedFace = context.func_196000_l();
        Direction[] dirs = this.resolvedDirections(clickedFace);
        this.forEach(level, clickedFace, targetPos -> {
            for (Direction dir : dirs) {
                consumer.accept((BlockPos)targetPos, dir);
            }
        });
    }

    private void forEach(World level, Direction dir, Consumer<BlockPos> consumer) {
        switch (this.mode) {
            case ALL: {
                for (Rectangle3i rect : this.rects) {
                    for (Vector3i pos : rect.enumerateZYX()) {
                        consumer.accept(pos.asBlockPos());
                    }
                }
                break;
            }
            case SAME: {
                Object info = this.resolvedBlockInfo(level, this.blockPos);
                Consumer<BlockPos> consumer1 = targetPos -> {
                    if (Objects.equals(info, this.resolvedBlockInfo(level, (BlockPos)targetPos))) {
                        consumer.accept((BlockPos)targetPos);
                    }
                };
                if (this.isPlaneOnly) {
                    for (int j = -this.radius + 1; j < this.radius; ++j) {
                        for (int i = -this.radius + 1; i < this.radius; ++i) {
                            consumer1.accept(this.resolvedPos(dir, i, j));
                        }
                    }
                } else {
                    for (int iy = -this.radius + 1; iy < this.radius; ++iy) {
                        for (int ix = -this.radius + 1; ix < this.radius; ++ix) {
                            for (int iz = -this.radius + 1; iz < this.radius; ++iz) {
                                consumer1.accept(this.blockPos.func_177982_a(ix, iy, iz));
                            }
                        }
                    }
                }
                break;
            }
            case TOUCHING: {
                BlockUtils.findTouchingBlockFaces(level, this.blockPos, dir, this.radius, this.isPlaneOnly).forEach(consumer);
            }
        }
    }

    private BlockPos resolvedPos(Direction dir, int i, int j) {
        switch (dir) {
            case UP: 
            case DOWN: {
                return this.blockPos.func_177982_a(j, 0, i);
            }
            case NORTH: 
            case SOUTH: {
                return this.blockPos.func_177982_a(i, j, 0);
            }
            case WEST: 
            case EAST: {
                return this.blockPos.func_177982_a(0, i, j);
            }
        }
        return this.blockPos;
    }

    private Direction[] resolvedDirections(Direction clickedFace) {
        if (!this.isApplyAllFaces) {
            return new Direction[]{clickedFace};
        }
        return Direction.values();
    }

    private Object resolvedBlockInfo(World level, BlockPos pos) {
        if (this.radius == 1) {
            return null;
        }
        return level.func_180495_p(pos).func_203425_a((Block)ModBlocks.BOUNDING_BOX.get());
    }

    private static enum MatchMode {
        ALL,
        SAME,
        TOUCHING;

    }
}

