/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility;

import com.google.common.collect.ImmutableList;
import moe.plushie.armourers_workshop.api.client.IRenderedBuffer;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBufferBuilder;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderObject;
import moe.plushie.armourers_workshop.core.data.cache.SkinCache;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class AbstractLightBufferObject
extends SkinRenderObject {
    public static final RenderType TYPE = RenderType.func_228633_a_((String)"", (VertexFormat)AbstractLightBufferObject.createDefaultFormat(), (int)7, (int)256, (boolean)false, (boolean)false, (RenderType.State)RenderType.State.func_228694_a_().func_228728_a_(false));
    public static final int PAGE_SIZE = 4096;
    private static final SkinCache.LRU<Integer, AbstractLightBufferObject> SHARED_LIGHTS = new SkinCache.LRU();
    private final int light;
    private int capacity;

    public AbstractLightBufferObject(int light) {
        this.light = light;
        this.capacity = 0;
    }

    @NotNull
    public static AbstractLightBufferObject getLightBuffer(int light) {
        return SHARED_LIGHTS.computeIfAbsent(light, AbstractLightBufferObject::new);
    }

    private static VertexFormat createDefaultFormat() {
        return new VertexFormat(ImmutableList.of((Object)DefaultVertexFormats.field_227848_e_));
    }

    public void ensureCapacity(int capacity) {
        if (capacity <= this.capacity) {
            return;
        }
        int alignedCapacity = (capacity / 4096 + 1) * 4096;
        AbstractBufferBuilder builder = new AbstractBufferBuilder(alignedCapacity * this.getFormat().func_177338_f());
        builder.begin(TYPE);
        for (int i = 0; i < alignedCapacity; ++i) {
            builder.uv2(this.light).endVertex();
        }
        IRenderedBuffer renderedBuffer = builder.end();
        this.upload(renderedBuffer.vertexBuffer());
        this.capacity = alignedCapacity;
        renderedBuffer.release();
    }

    public VertexFormat getFormat() {
        return TYPE.func_228663_p_();
    }
}

