/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.client;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import moe.plushie.armourers_workshop.api.client.IBufferSource;
import moe.plushie.armourers_workshop.api.client.IVertexConsumer;
import moe.plushie.armourers_workshop.compatibility.client.AbstractVertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;

public class AbstractBufferSource
implements IBufferSource {
    private static final Cache<Object, AbstractBufferSource> CACHED_BUFFER_SOURCES = CacheBuilder.newBuilder().expireAfterAccess(3L, TimeUnit.SECONDS).build();
    private final HashMap<IVertexBuilder, IVertexConsumer> cachedBuffers = new HashMap();
    private final IRenderTypeBuffer bufferSource;

    public AbstractBufferSource(IRenderTypeBuffer bufferSource) {
        this.bufferSource = bufferSource;
    }

    public static IBufferSource defaultBufferSource() {
        return AbstractBufferSource.wrap((IRenderTypeBuffer)Minecraft.func_71410_x().func_228019_au_().func_228487_b_());
    }

    public static IBufferSource immediateBufferSource(BufferBuilder bufferBuilder) {
        return new AbstractBufferSource((IRenderTypeBuffer)IRenderTypeBuffer.func_228455_a_((BufferBuilder)bufferBuilder));
    }

    public static IBufferSource wrap(IRenderTypeBuffer bufferSource) {
        AbstractBufferSource bufferSource1 = (AbstractBufferSource)CACHED_BUFFER_SOURCES.getIfPresent((Object)bufferSource);
        if (bufferSource1 == null) {
            bufferSource1 = new AbstractBufferSource(bufferSource);
            CACHED_BUFFER_SOURCES.put((Object)bufferSource, (Object)bufferSource1);
        }
        return bufferSource1;
    }

    public static IRenderTypeBuffer unwrap(IBufferSource bufferSource) {
        return ((AbstractBufferSource)bufferSource).bufferSource;
    }

    @Override
    public IVertexConsumer getBuffer(RenderType renderType) {
        IVertexBuilder builder = this.bufferSource.getBuffer(renderType);
        return this.cachedBuffers.computeIfAbsent(builder, AbstractVertexConsumer::new);
    }

    @Override
    public void endBatch() {
        if (this.bufferSource instanceof IRenderTypeBuffer.Impl) {
            ((IRenderTypeBuffer.Impl)this.bufferSource).func_228461_a_();
        }
    }
}

