/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.client.gui;

import com.apple.library.impl.EntityRendererImpl;
import com.mojang.blaze3d.matrix.MatrixStack;
import moe.plushie.armourers_workshop.compatibility.client.AbstractPoseStack;
import moe.plushie.armourers_workshop.compatibility.client.gui.AbstractGraphicsRenderer;
import moe.plushie.armourers_workshop.compatibility.extensions.com.mojang.blaze3d.vertex.PoseStack.ABI;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import moe.plushie.armourers_workshop.utils.math.OpenQuaternionf;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AbstractGraphicsRendererImpl {
    private static final EntityRendererImpl<LivingEntity> DEFAULT_ENTITY_RENDERER = (entity, origin, scale, focus, context) -> {
        RenderSystem.pushMatrix();
        RenderSystem.multMatrix((Matrix4f)AbstractGraphicsRenderer.of(context).func_227866_c_().func_227870_a_());
        RenderSystem.translatef((float)origin.x, (float)origin.y, (float)0.0f);
        InventoryScreen.func_228187_a_((int)0, (int)0, (int)scale, (float)focus.x, (float)focus.y, (LivingEntity)entity);
        RenderSystem.popMatrix();
    };
    private static final EntityRendererImpl<Entity> CUSTOM_ENTITY_RENDERER = (entity, origin, scale, focus, context) -> {
        RenderSystem.pushMatrix();
        RenderSystem.multMatrix((Matrix4f)AbstractGraphicsRenderer.of(context).func_227866_c_().func_227870_a_());
        RenderSystem.translatef((float)origin.x, (float)origin.y, (float)1050.0f);
        RenderSystem.scalef((float)1.0f, (float)1.0f, (float)-1.0f);
        float h = (float)Math.atan(focus.getX() / 40.0f);
        float l = (float)Math.atan(focus.getY() / 40.0f);
        MatrixStack poseStack = new MatrixStack();
        poseStack.func_227861_a_(0.0, 0.0, 1000.0);
        poseStack.func_227862_a_((float)scale, (float)scale, (float)scale);
        OpenQuaternionf quaternion = Vector3f.ZP.rotationDegrees(180.0f);
        OpenQuaternionf quaternion2 = Vector3f.XP.rotationDegrees(l * 20.0f);
        quaternion.mul(Vector3f.YP.rotationDegrees(180.0f));
        quaternion.mul(quaternion2);
        ABI.mulPose(poseStack, quaternion);
        float n = entity.field_70177_z;
        float o = entity.field_70125_A;
        entity.field_70177_z = h * 40.0f;
        entity.field_70125_A = -l * 20.0f;
        EntityRendererManager entityRenderDispatcher = Minecraft.func_71410_x().func_175598_ae();
        quaternion2.conjugate();
        entityRenderDispatcher.func_229089_a_(AbstractPoseStack.convertQuaternion(quaternion2));
        entityRenderDispatcher.func_178633_a(false);
        IRenderTypeBuffer.Impl bufferSource = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        RenderSystem.runAsFancy(() -> entityRenderDispatcher.func_229084_a_(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack, (IRenderTypeBuffer)bufferSource, 0xF000F0));
        bufferSource.func_228461_a_();
        entityRenderDispatcher.func_178633_a(true);
        entity.field_70177_z = n;
        entity.field_70125_A = o;
        RenderSystem.popMatrix();
    };

    public static <T extends Entity> EntityRendererImpl<T> getRenderer(T entity) {
        if (entity instanceof LivingEntity) {
            return DEFAULT_ENTITY_RENDERER;
        }
        return CUSTOM_ENTITY_RENDERER;
    }
}

