/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.client.resources.SkinManager;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.function.Consumer;
import manifold.ext.rt.api.Extension;
import manifold.ext.rt.api.This;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.util.ResourceLocation;

@Extension
public class ABI {
    public static void loadCustomSkin(@This SkinManager skinManager, GameProfile profile, Consumer<PlayerSkin> handler) {
        skinManager.func_152790_a(profile, (type, location, profileTexture) -> {
            if (type == MinecraftProfileTexture.Type.SKIN) {
                handler.accept(new PlayerSkin(location, profileTexture));
            }
        }, true);
    }

    public static class PlayerSkin {
        private final ResourceLocation location;
        private final MinecraftProfileTexture texture;
        private final Model model;

        public PlayerSkin(ResourceLocation location, MinecraftProfileTexture texture) {
            this.model = Model.byName(texture.getMetadata("model"));
            this.location = location;
            this.texture = texture;
        }

        public Model model() {
            return this.model;
        }

        public ResourceLocation texture() {
            return this.location;
        }

        public String textureUrl() {
            return this.texture.getUrl();
        }

        public static enum Model {
            SLIM("slim"),
            DEFAULT("default");

            private final String id;

            private Model(String id) {
                this.id = id;
            }

            static Model byName(String name) {
                if (name != null && name.equalsIgnoreCase("slim")) {
                    return SLIM;
                }
                return DEFAULT;
            }

            public String id() {
                return this.id;
            }
        }
    }
}

