/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.CompoundTag;

import com.mojang.authlib.GameProfile;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import manifold.ext.rt.api.Extension;
import manifold.ext.rt.api.This;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.api.registry.IRegistryEntry;
import moe.plushie.armourers_workshop.core.data.color.BlockPaintColor;
import moe.plushie.armourers_workshop.core.data.color.ColorScheme;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import moe.plushie.armourers_workshop.core.data.transform.SkinItemTransforms;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinMarker;
import moe.plushie.armourers_workshop.core.skin.SkinOptions;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.texture.PlayerTextureDescriptor;
import moe.plushie.armourers_workshop.utils.DataSerializers;
import moe.plushie.armourers_workshop.utils.SkinFileUtils;
import moe.plushie.armourers_workshop.utils.StreamUtils;
import moe.plushie.armourers_workshop.utils.math.Rectangle3i;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import moe.plushie.armourers_workshop.utils.math.Vector3i;
import moe.plushie.armourers_workshop.utils.texture.SkinPaintData;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Rotations;
import org.jetbrains.annotations.Nullable;

@Extension
public class OptionalAPI {
    public static boolean getOptionalBoolean(@This CompoundNBT tag, String key, boolean defaultValue) {
        if (tag.func_150297_b(key, 1)) {
            return tag.func_74767_n(key);
        }
        return defaultValue;
    }

    public static void putOptionalBoolean(@This CompoundNBT tag, String key, boolean value, boolean defaultValue) {
        if (OptionalAPI._shouldPutValue(tag, key, value, defaultValue)) {
            tag.func_74757_a(key, value);
        }
    }

    public static int getOptionalInt(@This CompoundNBT tag, String key, int defaultValue) {
        if (tag.func_150297_b(key, 3)) {
            return tag.func_74762_e(key);
        }
        return defaultValue;
    }

    public static void putOptionalInt(@This CompoundNBT tag, String key, int value, int defaultValue) {
        if (OptionalAPI._shouldPutValue(tag, key, value, defaultValue)) {
            tag.func_74768_a(key, value);
        }
    }

    public static float getOptionalFloat(@This CompoundNBT tag, String key, float defaultValue) {
        if (tag.func_150297_b(key, 5)) {
            return tag.func_74760_g(key);
        }
        return defaultValue;
    }

    public static void putOptionalFloat(@This CompoundNBT tag, String key, float value, float defaultValue) {
        if (OptionalAPI._shouldPutValue(tag, key, Float.valueOf(value), Float.valueOf(defaultValue))) {
            tag.func_74776_a(key, value);
        }
    }

    public static String getOptionalString(@This CompoundNBT tag, String key, String defaultValue) {
        if (tag.func_150297_b(key, 8)) {
            return tag.func_74779_i(key);
        }
        return defaultValue;
    }

    public static void putOptionalString(@This CompoundNBT tag, String key, String value, String defaultValue) {
        if (OptionalAPI._shouldPutValue(tag, key, value, defaultValue)) {
            tag.func_74778_a(key, value);
        }
    }

    public static <T extends IRegistryEntry> T getOptionalType(@This CompoundNBT tag, String key, T defaultValue, Function<String, T> provider) {
        if (tag.func_150297_b(key, 8)) {
            return (T)((IRegistryEntry)provider.apply(tag.func_74779_i(key)));
        }
        return defaultValue;
    }

    public static <T extends IRegistryEntry> void putOptionalType(@This CompoundNBT tag, String key, T value, T defaultValue) {
        if (OptionalAPI._shouldPutValue(tag, key, value, defaultValue)) {
            tag.func_74778_a(key, value.getRegistryName().toString());
        }
    }

    public static Vector3f getOptionalVector3f(@This CompoundNBT tag, String key, Vector3f defaultValue) {
        ListNBT listNBT = tag.func_150295_c(key, 5);
        if (listNBT.size() >= 3) {
            return new Vector3f(listNBT.func_150308_e(0), listNBT.func_150308_e(1), listNBT.func_150308_e(2));
        }
        return defaultValue;
    }

    public static void putOptionalVector3f(@This CompoundNBT tag, String key, Vector3f value, Vector3f defaultValue) {
        if (OptionalAPI._shouldPutValue(tag, key, value, defaultValue)) {
            ListNBT tags = new ListNBT();
            tags.add((Object)FloatNBT.func_229689_a_((float)value.getX()));
            tags.add((Object)FloatNBT.func_229689_a_((float)value.getY()));
            tags.add((Object)FloatNBT.func_229689_a_((float)value.getZ()));
            tag.func_218657_a(key, (INBT)tags);
        }
    }

    public static Vector3i getOptionalVector3i(@This CompoundNBT tag, String key, Vector3i defaultValue) {
        ListNBT listNBT = tag.func_150295_c(key, 3);
        if (listNBT.size() >= 3) {
            return new Vector3i(listNBT.func_186858_c(0), listNBT.func_186858_c(1), listNBT.func_186858_c(2));
        }
        return defaultValue;
    }

    public static void putOptionalVector3i(@This CompoundNBT tag, String key, Vector3i value, Vector3i defaultValue) {
        if (OptionalAPI._shouldPutValue(tag, key, value, defaultValue)) {
            ListNBT tags = new ListNBT();
            tags.add((Object)IntNBT.func_229692_a_((int)value.getX()));
            tags.add((Object)IntNBT.func_229692_a_((int)value.getY()));
            tags.add((Object)IntNBT.func_229692_a_((int)value.getZ()));
            tag.func_218657_a(key, (INBT)tags);
        }
    }

    public static Rectangle3i getOptionalRectangle3i(@This CompoundNBT tag, String key, Rectangle3i defaultValue) {
        ListNBT listTag = tag.func_150295_c(key, 3);
        if (listTag.size() >= 6) {
            return new Rectangle3i(listTag.func_186858_c(0), listTag.func_186858_c(1), listTag.func_186858_c(2), listTag.func_186858_c(3), listTag.func_186858_c(4), listTag.func_186858_c(5));
        }
        return defaultValue;
    }

    public static void putOptionalRectangle3i(@This CompoundNBT tag, String key, Rectangle3i value, Rectangle3i defaultValue) {
        if (OptionalAPI._shouldPutValue(tag, key, value, defaultValue)) {
            ListNBT tags = new ListNBT();
            tags.add((Object)IntNBT.func_229692_a_((int)value.getX()));
            tags.add((Object)IntNBT.func_229692_a_((int)value.getY()));
            tags.add((Object)IntNBT.func_229692_a_((int)value.getZ()));
            tags.add((Object)IntNBT.func_229692_a_((int)value.getWidth()));
            tags.add((Object)IntNBT.func_229692_a_((int)value.getHeight()));
            tags.add((Object)IntNBT.func_229692_a_((int)value.getDepth()));
            tag.func_218657_a(key, (INBT)tags);
        }
    }

    public static BlockPos getOptionalBlockPos(@This CompoundNBT tag, String key, BlockPos defaultValue) {
        if (tag.func_150297_b(key, 4)) {
            return BlockPos.func_218283_e((long)tag.func_74763_f(key));
        }
        return defaultValue;
    }

    public static void putOptionalBlockPos(@This CompoundNBT tag, String key, BlockPos value, BlockPos defaultValue) {
        if (OptionalAPI._shouldPutValue(tag, key, value, defaultValue)) {
            tag.func_74772_a(key, value.func_218275_a());
        }
    }

    public static Collection<BlockPos> getOptionalBlockPosArray(@This CompoundNBT tag, String key) {
        ArrayList<BlockPos> elements = new ArrayList<BlockPos>();
        if (tag.func_150297_b(key, 12)) {
            for (long value : tag.func_197645_o(key)) {
                elements.add(BlockPos.func_218283_e((long)value));
            }
        }
        return elements;
    }

    public static void putOptionalBlockPosArray(@This CompoundNBT tag, String key, Collection<BlockPos> elements) {
        if (OptionalAPI._shouldPutValueArray(tag, key, elements)) {
            ArrayList<Long> list = new ArrayList<Long>(elements.size());
            for (BlockPos pos : elements) {
                list.add(pos.func_218275_a());
            }
            tag.func_202168_c(key, list);
        }
    }

    public static Rotations getOptionalRotations(@This CompoundNBT tag, String key, Rotations defaultValue) {
        ListNBT listTag = tag.func_150295_c(key, 5);
        if (listTag.size() >= 3) {
            return new Rotations(listTag);
        }
        return defaultValue;
    }

    public static void putOptionalRotations(@This CompoundNBT tag, String key, Rotations value, Rotations defaultValue) {
        if (OptionalAPI._shouldPutValue(tag, key, value, defaultValue)) {
            tag.func_218657_a(key, (INBT)value.func_179414_a());
        }
    }

    public static GameProfile getOptionalGameProfile(@This CompoundNBT tag, String key, GameProfile defaultValue) {
        CompoundNBT profileTag = tag.func_74775_l(key);
        if (profileTag.isEmpty()) {
            return defaultValue;
        }
        GameProfile value = DataSerializers.readGameProfile(profileTag);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public static void putOptionalGameProfile(@This CompoundNBT tag, String key, GameProfile value, GameProfile defaultValue) {
        if (OptionalAPI._shouldPutValue(tag, key, value, defaultValue)) {
            CompoundNBT profileTag = new CompoundNBT();
            DataSerializers.writeGameProfile(profileTag, value);
            if (!profileTag.isEmpty()) {
                tag.func_218657_a(key, (INBT)profileTag);
            }
        }
    }

    public static PlayerTextureDescriptor getOptionalTextureDescriptor(@This CompoundNBT tag, String key, PlayerTextureDescriptor defaultValue) {
        CompoundNBT nbt1;
        if (tag.func_150297_b(key, 10) && !(nbt1 = tag.func_74775_l(key)).isEmpty()) {
            return new PlayerTextureDescriptor(nbt1);
        }
        return defaultValue;
    }

    public static void putOptionalTextureDescriptor(@This CompoundNBT tag, String key, PlayerTextureDescriptor value, PlayerTextureDescriptor defaultValue) {
        if (OptionalAPI._shouldPutValue(tag, key, value, defaultValue)) {
            tag.func_218657_a(key, (INBT)value.serializeNBT());
        }
    }

    @Nullable
    public static SkinPaintData getOptionalPaintData(@This CompoundNBT tag, String key) {
        if (tag != null && tag.func_150297_b(key, 7)) {
            try {
                ByteBuf buffer = Unpooled.wrappedBuffer((byte[])tag.func_74770_j(key));
                ByteBufInputStream bufferedStream = new ByteBufInputStream(buffer);
                GZIPInputStream compressedStream = new GZIPInputStream((InputStream)bufferedStream);
                DataInputStream dataStream = new DataInputStream(compressedStream);
                SkinPaintData paintData = SkinPaintData.v2();
                int length = dataStream.readInt();
                int[] colors = paintData.getData();
                for (int i = 0; i < length; ++i) {
                    if (i >= colors.length) continue;
                    colors[i] = dataStream.readInt();
                }
                StreamUtils.closeQuietly(new Closeable[]{dataStream, compressedStream, bufferedStream});
                return paintData;
            }
            catch (Exception ignored) {
                return null;
            }
        }
        return null;
    }

    public static void putOptionalPaintData(@This CompoundNBT tag, String key, SkinPaintData paintData) {
        if (paintData != null) {
            try {
                int[] colors = paintData.getData();
                ByteBuf buffer = Unpooled.buffer();
                ByteBufOutputStream bufferedStream = new ByteBufOutputStream(buffer);
                GZIPOutputStream compressedStream = new GZIPOutputStream((OutputStream)bufferedStream);
                DataOutputStream dataStream = new DataOutputStream(compressedStream);
                dataStream.writeInt(colors.length);
                for (int color : colors) {
                    dataStream.writeInt(color);
                }
                StreamUtils.closeQuietly(new Closeable[]{dataStream, compressedStream, bufferedStream});
                tag.func_74773_a(key, Arrays.copyOf(buffer.array(), buffer.writerIndex()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static ColorScheme getOptionalColorScheme(@This CompoundNBT tag, String key, ColorScheme defaultValue) {
        if (tag.func_150297_b(key, 10)) {
            return new ColorScheme(tag.func_74775_l(key));
        }
        return defaultValue;
    }

    public static void putOptionalColorScheme(@This CompoundNBT tag, String key, ColorScheme value, ColorScheme defaultValue) {
        if (OptionalAPI._shouldPutValue(tag, key, value, defaultValue)) {
            tag.func_218657_a(key, (INBT)value.serializeNBT());
        }
    }

    public static IPaintColor getOptionalPaintColor(@This CompoundNBT tag, String key, IPaintColor defaultValue) {
        if (tag != null && tag.func_150297_b(key, 3)) {
            return PaintColor.of(tag.func_74762_e(key));
        }
        return defaultValue;
    }

    public static void putOptionalPaintColor(@This CompoundNBT tag, String key, IPaintColor value, IPaintColor defaultValue) {
        if (OptionalAPI._shouldPutValue(tag, key, value, defaultValue)) {
            tag.func_74768_a(key, value.getRawValue());
        }
    }

    public static SkinItemTransforms getOptionalItemTransforms(@This CompoundNBT tag, String key, SkinItemTransforms defaultValue) {
        if (tag.func_150297_b(key, 10)) {
            return new SkinItemTransforms(tag.func_74775_l(key));
        }
        return defaultValue;
    }

    public static void putOptionalItemTransforms(@This CompoundNBT tag, String key, SkinItemTransforms value, SkinItemTransforms defaultValue) {
        if (OptionalAPI._shouldPutValue(tag, key, value, defaultValue)) {
            tag.func_218657_a(key, (INBT)value.serializeNBT());
        }
    }

    public static BlockPaintColor getOptionalBlockPaintColor(@This CompoundNBT tag, String key, BlockPaintColor defaultValue) {
        if (!tag.func_150297_b(key, 10)) {
            return defaultValue;
        }
        CompoundNBT colorNBT = tag.func_74775_l(key);
        if (colorNBT.isEmpty()) {
            return defaultValue;
        }
        BlockPaintColor color = new BlockPaintColor();
        color.deserializeNBT(colorNBT);
        return color;
    }

    public static void putOptionalBlockPaintColor(@This CompoundNBT tag, String key, BlockPaintColor value, BlockPaintColor defaultValue) {
        if (OptionalAPI._shouldPutValue(tag, key, value, defaultValue)) {
            tag.func_218657_a(key, (INBT)value.serializeNBT());
        }
    }

    public static SkinDescriptor getOptionalSkinDescriptor(@This CompoundNBT tag, String key) {
        return OptionalAPI.getOptionalSkinDescriptor(tag, key, SkinDescriptor.EMPTY);
    }

    public static void putOptionalSkinDescriptor(@This CompoundNBT tag, String key, SkinDescriptor value) {
        OptionalAPI.putOptionalSkinDescriptor(tag, key, value, SkinDescriptor.EMPTY);
    }

    public static SkinDescriptor getOptionalSkinDescriptor(@This CompoundNBT tag, String key, SkinDescriptor defaultValue) {
        CompoundNBT parsedTag = OptionalAPI._parseCompoundTag(tag, key);
        if (parsedTag != null) {
            if (!parsedTag.isEmpty()) {
                return new SkinDescriptor(parsedTag);
            }
            return SkinDescriptor.EMPTY;
        }
        return defaultValue;
    }

    public static void putOptionalSkinDescriptor(@This CompoundNBT tag, String key, SkinDescriptor value, SkinDescriptor defaultValue) {
        if (OptionalAPI._shouldPutValue(tag, key, value, defaultValue)) {
            tag.func_218657_a(key, (INBT)value.serializeNBT());
        }
    }

    public static SkinProperties getOptionalSkinProperties(@This CompoundNBT tag, String key) {
        SkinProperties properties = new SkinProperties();
        if (tag.func_150297_b(key, 10)) {
            properties.readFromNBT(tag.func_74775_l(key));
        }
        return properties;
    }

    public static void putOptionalSkinProperties(@This CompoundNBT tag, String key, SkinProperties properties) {
        if (OptionalAPI._shouldPutValue(tag, key, properties, SkinProperties.EMPTY)) {
            CompoundNBT propertiesTag = new CompoundNBT();
            properties.writeToNBT(propertiesTag);
            tag.func_218657_a(key, (INBT)propertiesTag);
        }
    }

    public static SkinOptions getOptionalSkinOptions(@This CompoundNBT tag, String key, SkinOptions defaultValue) {
        CompoundNBT nbt1;
        if (tag.func_150297_b(key, 10) && !(nbt1 = tag.func_74775_l(key)).isEmpty()) {
            return new SkinOptions(nbt1);
        }
        return defaultValue;
    }

    public static void putOptionalSkinOptions(@This CompoundNBT tag, String key, SkinOptions value, SkinOptions defaultValue) {
        if (OptionalAPI._shouldPutValue(tag, key, value, defaultValue)) {
            tag.func_218657_a(key, (INBT)value.serializeNBT());
        }
    }

    public static Collection<SkinMarker> getOptionalSkinMarkerArray(@This CompoundNBT tag, String key) {
        ArrayList<SkinMarker> elements = new ArrayList<SkinMarker>();
        if (tag.func_150297_b(key, 12)) {
            for (long value : tag.func_197645_o(key)) {
                elements.add(SkinMarker.of(value));
            }
        }
        return elements;
    }

    public static void putOptionalSkinMarkerArray(@This CompoundNBT tag, String key, Collection<SkinMarker> elements) {
        if (OptionalAPI._shouldPutValueArray(tag, key, elements)) {
            ArrayList<Long> list = new ArrayList<Long>(elements.size());
            for (SkinMarker marker : elements) {
                list.add(marker.asLong());
            }
            tag.func_202168_c(key, list);
        }
    }

    private static <T> boolean _shouldPutValue(CompoundNBT tag, String key, T value, T defaultValue) {
        if (tag == null || key == null) {
            return false;
        }
        if (value == null || value.equals(defaultValue)) {
            tag.func_82580_o(key);
            return false;
        }
        return true;
    }

    private static <T> boolean _shouldPutValueArray(CompoundNBT tag, String key, Collection<T> value) {
        if (tag == null || key == null) {
            return false;
        }
        if (value == null || value.isEmpty()) {
            tag.func_82580_o(key);
            return false;
        }
        return true;
    }

    private static CompoundNBT _parseCompoundTag(CompoundNBT tag, String key) {
        if (tag.func_150297_b(key, 10)) {
            return tag.func_74775_l(key);
        }
        if (tag.func_150297_b(key, 8)) {
            return SkinFileUtils.readNBT(tag.func_74779_i(key));
        }
        return null;
    }
}

