/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.forge;

import com.google.common.base.Objects;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class AbstractForgeConfig {
    public static void register(Type type, Spec spec) {
        ModLoadingContext.get().registerConfig(type.value, spec.value);
    }

    public static enum Type {
        COMMON(ModConfig.Type.COMMON),
        CLIENT(ModConfig.Type.CLIENT),
        SERVER(ModConfig.Type.SERVER);

        final ModConfig.Type value;

        private Type(ModConfig.Type value) {
            this.value = value;
        }

        public String getExtension() {
            return this.value.extension();
        }
    }

    public static class Spec {
        protected final ForgeConfigSpec value;

        public Spec(Object value) {
            this((ForgeConfigSpec)value);
        }

        public Spec(ForgeConfigSpec value) {
            this.value = value;
        }

        public void save() {
            this.value.save();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Spec spec1 = (Spec)o;
            return Objects.equal((Object)this.value, (Object)spec1.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static class Builder {
        protected final ForgeConfigSpec.Builder builder;

        public Builder(ForgeConfigSpec.Builder builder) {
            this.builder = builder;
        }

        public static <T> Pair<T, Spec> configure(Function<Builder, T> consumer) {
            Pair pair = new ForgeConfigSpec.Builder().configure((T it) -> consumer.apply(new Builder((ForgeConfigSpec.Builder)it)));
            return Pair.of((Object)pair.getLeft(), (Object)new Spec((ForgeConfigSpec)pair.getValue()));
        }

        public void push(String name) {
            this.builder.push(name);
        }

        public void pop() {
            this.builder.pop();
        }

        public ConfigValue<Boolean> define(String path, boolean defaultValue) {
            return new ConfigValue<Boolean>((ForgeConfigSpec.ConfigValue<Boolean>)this.builder.define(path, defaultValue));
        }

        public ConfigValue<Integer> defineInRange(String path, int defaultValue, int minValue, int maxValue) {
            return new ConfigValue<Integer>((ForgeConfigSpec.ConfigValue<Integer>)this.builder.defineInRange(path, defaultValue, minValue, maxValue));
        }

        public ConfigValue<Double> defineInRange(String path, double defaultValue, double minValue, double maxValue) {
            return new ConfigValue<Double>((ForgeConfigSpec.ConfigValue<Double>)this.builder.defineInRange(path, defaultValue, minValue, maxValue));
        }

        public <T> ConfigValue<List<? extends T>> defineList(String path, List<? extends T> defaultValue, Predicate<Object> elementValidator) {
            return new ConfigValue<List<? extends T>>(this.builder.defineList(path, defaultValue, elementValidator));
        }

        public Builder comment(String ... comment) {
            this.builder.comment(comment);
            return this;
        }
    }

    public static class ConfigValue<T> {
        protected final ForgeConfigSpec.ConfigValue<T> value;

        public ConfigValue(ForgeConfigSpec.ConfigValue<T> value) {
            this.value = value;
        }

        public void set(T newValue) {
            this.value.set(newValue);
        }

        public T get() {
            return (T)this.value.get();
        }
    }
}

