/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.forge;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.GenericEvent;
import net.minecraftforge.fml.event.lifecycle.IModBusEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class AbstractForgeEventBus {
    private static final HashMap<Class<?>, ArrayList<?>> LISTENERS = new HashMap();

    public static <E extends Event> void observer(Class<E> eventType, Consumer<E> handler) {
        AbstractForgeEventBus.observer(eventType, handler, (E event) -> event);
    }

    public static <E extends Event, T> void observer(Class<E> eventType, Consumer<T> handler, Function<E, T> transform) {
        ArrayList handlers = (ArrayList)ObjectUtils.unsafeCast(LISTENERS.computeIfAbsent(eventType, key -> {
            ArrayList queue = new ArrayList();
            Consumer<Event> listener = event -> queue.forEach(element -> element.accept(transform.apply(event)));
            MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, eventType, listener);
            if (IModBusEvent.class.isAssignableFrom(eventType)) {
                FMLJavaModLoadingContext.get().getModEventBus().addListener(EventPriority.NORMAL, false, eventType, listener);
            }
            return queue;
        }));
        handlers.add(handler);
    }

    public static <E extends GenericEvent<? extends F>, F> void observer(Class<E> eventType, Class<F> genericClassFilter, Consumer<E> handler) {
        AbstractForgeEventBus.observer(eventType, genericClassFilter, handler, event -> event);
    }

    public static <E extends GenericEvent<? extends F>, F, T> void observer(Class<E> eventType, Class<F> genericClassFilter, Consumer<T> handler, Function<E, T> transform) {
        ArrayList handlers = (ArrayList)ObjectUtils.unsafeCast(LISTENERS.computeIfAbsent(eventType, key -> {
            ArrayList queue = new ArrayList();
            Consumer<GenericEvent> listener = event -> queue.forEach(element -> element.accept(transform.apply(event)));
            MinecraftForge.EVENT_BUS.addGenericListener(genericClassFilter, EventPriority.NORMAL, false, eventType, listener);
            if (IModBusEvent.class.isAssignableFrom(eventType)) {
                FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(genericClassFilter, EventPriority.NORMAL, false, eventType, listener);
            }
            return queue;
        }));
        handlers.add(handler);
    }
}

