/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.forge.extensions.net.minecraft.core.Registry;

import com.mojang.brigadier.CommandDispatcher;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import manifold.ext.rt.api.Extension;
import manifold.ext.rt.api.ThisClass;
import moe.plushie.armourers_workshop.api.common.IBlockSnapshot;
import moe.plushie.armourers_workshop.compatibility.AbstractArgumentTypeInfo;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.level.block.entity.BlockEntity.DataProvider;
import moe.plushie.armourers_workshop.compatibility.forge.AbstractForgeCommonEvents;
import moe.plushie.armourers_workshop.compatibility.forge.AbstractForgeConfig;
import moe.plushie.armourers_workshop.compatibility.forge.AbstractForgeEventBus;
import moe.plushie.armourers_workshop.init.provider.CommonNativeProvider;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;

@Extension
public class CommonEventProvider {
    public static void willServerTickFO(@ThisClass Class<?> clazz, Consumer<ServerWorld> consumer) {
        AbstractForgeEventBus.observer(AbstractForgeCommonEvents.TICK, event -> {
            if (event.side.isServer()) {
                consumer.accept((ServerWorld)event.world);
            }
        });
    }

    public static void willLoadCompleteFO(@ThisClass Class<?> clazz, Consumer<CommonNativeProvider.Dispatcher> consumer) {
        AbstractForgeEventBus.observer(AbstractForgeCommonEvents.FML_LOAD_COMPLETE, event -> consumer.accept(arg_0 -> ((FMLLoadCompleteEvent)event).enqueueWork(arg_0)));
    }

    public static void willClientSetupFO(@ThisClass Class<?> clazz, Consumer<CommonNativeProvider.Dispatcher> consumer) {
        AbstractForgeEventBus.observer(AbstractForgeCommonEvents.FML_CLIENT_SETUP, event -> consumer.accept(arg_0 -> ((FMLClientSetupEvent)event).enqueueWork(arg_0)));
    }

    public static void willCommonSetupFO(@ThisClass Class<?> clazz, Consumer<CommonNativeProvider.Dispatcher> consumer) {
        AbstractForgeEventBus.observer(AbstractForgeCommonEvents.FML_COMMON_SETUP, event -> consumer.accept(arg_0 -> ((FMLCommonSetupEvent)event).enqueueWork(arg_0)));
    }

    public static void willServerStartFO(@ThisClass Class<?> clazz, Consumer<MinecraftServer> consumer) {
        AbstractForgeEventBus.observer(AbstractForgeCommonEvents.SERVER_WILL_START, event -> consumer.accept(event.getServer()));
    }

    public static void didServerStartFO(@ThisClass Class<?> clazz, Consumer<MinecraftServer> consumer) {
        AbstractForgeEventBus.observer(AbstractForgeCommonEvents.SERVER_DID_START, event -> consumer.accept(event.getServer()));
    }

    public static void willServerStopFO(@ThisClass Class<?> clazz, Consumer<MinecraftServer> consumer) {
        AbstractForgeEventBus.observer(AbstractForgeCommonEvents.SERVER_WILL_STOP, event -> consumer.accept(event.getServer()));
    }

    public static void didServerStopFO(@ThisClass Class<?> clazz, Consumer<MinecraftServer> consumer) {
        AbstractForgeEventBus.observer(AbstractForgeCommonEvents.SERVER_DID_STOP, event -> consumer.accept(event.getServer()));
    }

    public static void willPlayerLoginFO(@ThisClass Class<?> clazz, Consumer<PlayerEntity> consumer) {
        AbstractForgeEventBus.observer(AbstractForgeCommonEvents.PLAYER_LOGIN, event -> consumer.accept(event.getPlayer()));
    }

    public static void willPlayerLogoutFO(@ThisClass Class<?> clazz, Consumer<PlayerEntity> consumer) {
        AbstractForgeEventBus.observer(AbstractForgeCommonEvents.PLAYER_LOGOUT, event -> consumer.accept(event.getPlayer()));
    }

    public static void willPlayerCloneFO(@ThisClass Class<?> clazz, BiConsumer<PlayerEntity, PlayerEntity> consumer) {
        AbstractForgeEventBus.observer(AbstractForgeCommonEvents.PLAYER_CLONE, event -> consumer.accept(event.getOriginal(), event.getPlayer()));
    }

    public static void didEntityTackingFO(@ThisClass Class<?> clazz, BiConsumer<Entity, PlayerEntity> consumer) {
        AbstractForgeEventBus.observer(AbstractForgeCommonEvents.PLAYER_TRACKING, event -> consumer.accept(event.getTarget(), event.getPlayer()));
    }

    public static void shouldEntityAttackFO(@ThisClass Class<?> clazz, BiFunction<Entity, PlayerEntity, ActionResultType> consumer) {
        AbstractForgeEventBus.observer(AbstractForgeCommonEvents.ENTITY_ATTACK, event -> {
            if (consumer.apply(event.getTarget(), event.getPlayer()) == ActionResultType.FAIL) {
                event.setCanceled(true);
            }
        });
    }

    public static void willEntityDeathFO(@ThisClass Class<?> clazz, Consumer<Entity> consumer) {
        AbstractForgeEventBus.observer(AbstractForgeCommonEvents.ENTITY_DROPS, event -> consumer.accept(event.getEntity()));
    }

    public static void didEntityJoinFO(@ThisClass Class<?> clazz, Consumer<Entity> consumer) {
        AbstractForgeEventBus.observer(AbstractForgeCommonEvents.ENTITY_JOIN, event -> {
            if (!event.getWorld().func_201670_d()) {
                consumer.accept(event.getEntity());
            }
        });
    }

    public static void willBlockPlaceFO(@ThisClass Class<?> clazz, CommonNativeProvider.BlockSnapshot consumer) {
        AbstractForgeEventBus.observer(AbstractForgeCommonEvents.BLOCK_PLACE, event -> {
            IWorld level = event.getWorld();
            PlayerEntity player = ObjectUtils.safeCast(event.getEntity(), PlayerEntity.class);
            if (player == null) {
                return;
            }
            consumer.snapshot(player, level, event.getPos(), event.getState(), new IBlockSnapshot((BlockEvent.EntityPlaceEvent)event){
                final /* synthetic */ BlockEvent.EntityPlaceEvent val$event;
                {
                    this.val$event = entityPlaceEvent;
                }

                @Override
                public BlockState getState() {
                    return this.val$event.getBlockSnapshot().getReplacedBlock();
                }

                @Override
                public CompoundNBT getTag() {
                    return this.val$event.getBlockSnapshot().getNbt();
                }
            });
        });
    }

    public static void willBlockBreakFO(@ThisClass Class<?> clazz, CommonNativeProvider.BlockSnapshot consumer) {
        AbstractForgeEventBus.observer(AbstractForgeCommonEvents.BLOCK_BREAK, event -> {
            PlayerEntity player = event.getPlayer();
            IWorld level = event.getWorld();
            consumer.snapshot(player, level, event.getPos(), null, new IBlockSnapshot(){
                final /* synthetic */ BlockEvent.BreakEvent val$event;
                final /* synthetic */ IWorld val$level;
                {
                    this.val$event = breakEvent;
                    this.val$level = iWorld;
                }

                @Override
                public BlockState getState() {
                    return this.val$event.getState();
                }

                @Override
                public CompoundNBT getTag() {
                    TileEntity blockEntity = this.val$level.func_175625_s(this.val$event.getPos());
                    if (blockEntity != null) {
                        return DataProvider.saveWithFullMetadata(blockEntity);
                    }
                    return null;
                }
            });
        });
    }

    public static void willConfigReloadFO(@ThisClass Class<?> clazz, Consumer<AbstractForgeConfig.Spec> consumer) {
        AbstractForgeEventBus.observer(AbstractForgeCommonEvents.CONFIG, event -> consumer.accept(new AbstractForgeConfig.Spec(event.getConfig().getSpec())));
    }

    public static void willRegisterEntityAttributesFO(@ThisClass Class<?> clazz, Consumer<CommonNativeProvider.EntityAttributesRegistry> consumer) {
        AbstractForgeEventBus.observer(AbstractForgeCommonEvents.ENTITY_ATTRIBUTE_REGISTRY, consumer, event -> (entity, builder) -> event.put(entity, builder.func_233813_a_()));
    }

    public static void willRegisterCustomDataPackFO(@ThisClass Class<?> clazz, Supplier<IFutureReloadListener> consumer) {
        AbstractForgeEventBus.observer(AbstractForgeCommonEvents.DATA_PACK_REGISTRY, event -> event.addListener((IFutureReloadListener)consumer.get()));
    }

    public static void willRegisterCommandFO(@ThisClass Class<?> clazz, Consumer<CommandDispatcher<CommandSource>> consumer) {
        AbstractForgeEventBus.observer(AbstractForgeCommonEvents.COMMAND_REGISTRY, event -> consumer.accept(event.getDispatcher()));
    }

    public static void willRegisterArgumentFO(@ThisClass Class<?> clazz, Consumer<CommonNativeProvider.ArgumentRegistry> consumer) {
        consumer.accept(AbstractArgumentTypeInfo::register);
    }
}

