/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.armature;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import moe.plushie.armourers_workshop.api.armature.IJoint;
import moe.plushie.armourers_workshop.api.armature.IJointTransform;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.core.armature.Joint;
import moe.plushie.armourers_workshop.core.armature.JointShape;
import org.jetbrains.annotations.Nullable;

public class Armature {
    private final IJoint[] joints;
    private final ISkinPartType[] partTypes;
    private final Map<String, IJoint> namedJoints;
    private final Map<ISkinPartType, IJoint> linkedJoints;
    private final IJoint wildcardJoint;
    private final IJointTransform[] localTransforms;
    private final IJointTransform[] globalTransforms;
    private final JointShape[] shapes;

    public Armature(Map<String, Joint> joints, Map<Joint, IJointTransform> transforms, Map<ISkinPartType, Joint> linkedJoints, @Nullable Joint wildcardJoint, Map<Joint, JointShape> shapes) {
        this.joints = new IJoint[joints.size()];
        this.partTypes = new ISkinPartType[joints.size()];
        this.localTransforms = new IJointTransform[joints.size()];
        this.globalTransforms = new IJointTransform[joints.size()];
        this.namedJoints = new LinkedHashMap<String, Joint>(joints);
        this.linkedJoints = new LinkedHashMap<ISkinPartType, Joint>(linkedJoints);
        this.wildcardJoint = wildcardJoint;
        this.shapes = new JointShape[joints.size()];
        int id = 0;
        for (Joint joint : joints.values()) {
            this.joints[id] = joint;
            this.shapes[id] = shapes.get(joint);
            this.localTransforms[id] = transforms.getOrDefault(joint, IJointTransform.NONE);
            this.globalTransforms[id] = this.calcTransform(joint, transforms);
            joint.setId(id++);
        }
        for (Map.Entry entry : linkedJoints.entrySet()) {
            Joint joint = (Joint)entry.getValue();
            this.partTypes[joint.getId()] = (ISkinPartType)entry.getKey();
        }
    }

    @Nullable
    public IJoint getJoint(String name) {
        return this.namedJoints.get(name);
    }

    public IJoint getJoint(int id) {
        return this.joints[id];
    }

    @Nullable
    public IJoint getJoint(ISkinPartType partType) {
        return this.linkedJoints.getOrDefault(partType, this.wildcardJoint);
    }

    @Nullable
    public ISkinPartType getPartType(IJoint joint) {
        return this.partTypes[joint.getId()];
    }

    public IJointTransform getLocalTransform(int id) {
        return this.localTransforms[id];
    }

    public IJointTransform getGlobalTransform(int id) {
        return this.globalTransforms[id];
    }

    public JointShape getShape(int id) {
        return this.shapes[id];
    }

    public Collection<IJoint> allJoints() {
        return this.namedJoints.values();
    }

    public int size() {
        return this.joints.length;
    }

    private IJointTransform calcTransform(Joint joint, Map<Joint, IJointTransform> transforms) {
        IJointTransform childTransform = transforms.getOrDefault(joint, IJointTransform.NONE);
        if (joint.getParent() == null) {
            return childTransform;
        }
        IJointTransform parentTransform = this.calcTransform(joint.getParent(), transforms);
        if (parentTransform == IJointTransform.NONE) {
            return childTransform;
        }
        if (childTransform == IJointTransform.NONE) {
            return parentTransform;
        }
        return poseStack -> {
            parentTransform.apply(poseStack);
            childTransform.apply(poseStack);
        };
    }
}

