/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.armature;

import java.io.InputStream;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.armature.IJointTransform;
import moe.plushie.armourers_workshop.api.data.IDataPackObject;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.core.armature.Armature;
import moe.plushie.armourers_workshop.core.armature.ArmatureSerializers;
import moe.plushie.armourers_workshop.core.armature.Joint;
import moe.plushie.armourers_workshop.core.armature.JointShape;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.init.ModConstants;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.utils.StreamUtils;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class Armatures {
    private static final LinkedHashMap<ISkinType, Armature> LINKED_ARMATURES = new LinkedHashMap();
    private static final LinkedHashMap<ResourceLocation, Armature> NAMED_ARMATURES = new LinkedHashMap();
    public static final Armature HUMANOID = Builder.access$000("humanoid");
    public static final Armature HORSE = Builder.access$000("horse");
    public static final Armature BOAT = Builder.access$000("boat");
    public static final Armature MINECART = Builder.access$000("minecart");
    public static final Armature ANY = Builder.access$000("any");
    public static final Armature HAND = Builder.access$000("hand");

    @Nullable
    public static Armature byName(ResourceLocation registryName) {
        return NAMED_ARMATURES.get(registryName);
    }

    public static Armature byType(ISkinType skinType) {
        return LINKED_ARMATURES.getOrDefault(skinType, ANY);
    }

    public static void init() {
    }

    private static class Builder {
        private Joint wildcardJoint;
        private final HashSet<ISkinType> skinTypes = new HashSet();
        private final LinkedHashMap<String, Joint> namedJoints = new LinkedHashMap();
        private final LinkedHashMap<ISkinPartType, Joint> linkedJoints = new LinkedHashMap();
        private final LinkedHashMap<Joint, JointShape> jointShapes = new LinkedHashMap();
        private final LinkedHashMap<Joint, IJointTransform> jointTransforms = new LinkedHashMap();
        private final LinkedHashMap<Joint, String> jointParents = new LinkedHashMap();

        private Builder(String path) {
            ClassLoader loader = this.getClass().getClassLoader();
            InputStream inputStream = loader.getResourceAsStream(path);
            IDataPackObject object = StreamUtils.fromPackObject(inputStream);
            if (object != null) {
                this.load(object);
            }
        }

        private static Armature named(String name) {
            Builder loader = new Builder("data/armourers_workshop/skin/armatures/" + name + ".json");
            return loader.build(name);
        }

        private void load(IDataPackObject object) {
            object.get("joint").entrySet().forEach(it -> {
                IDataPackObject value = (IDataPackObject)it.getValue();
                Joint joint = new Joint((String)it.getKey());
                this.namedJoints.put(joint.getName(), joint);
                this.loadType(value.get("id"), SkinPartTypes::byName, partType -> {
                    if (partType != null) {
                        this.linkedJoints.put((ISkinPartType)partType, joint);
                    } else {
                        this.wildcardJoint = joint;
                    }
                });
                this.jointShapes.put(joint, ArmatureSerializers.readShape(value.get("cube")));
                this.jointTransforms.put(joint, ArmatureSerializers.readTransform(value.get("transform"))::apply);
                this.jointParents.put(joint, value.get("parent").stringValue());
            });
            this.loadType(object.get("type"), SkinTypes::byName, this.skinTypes::add);
        }

        private <T> void loadType(IDataPackObject object, Function<String, T> transformer, Consumer<T> consumer) {
            switch (object.type()) {
                case ARRAY: {
                    object.allValues().forEach(it -> this.loadType((IDataPackObject)it, (Function)transformer, consumer));
                    return;
                }
                case STRING: {
                    String value = object.stringValue();
                    if (value.isEmpty() || value.equals("*")) {
                        consumer.accept(null);
                        return;
                    }
                    T type = transformer.apply(value);
                    if (type != null) {
                        consumer.accept(type);
                    }
                    return;
                }
            }
        }

        private Armature build(String name) {
            this.jointParents.forEach((child, parentName) -> child.setParent(this.namedJoints.get(parentName)));
            Armature armature = new Armature(this.namedJoints, this.jointTransforms, this.linkedJoints, this.wildcardJoint, this.jointShapes);
            ResourceLocation registryName = ModConstants.key(name);
            ModLog.debug("Registering Armature '{}'", registryName);
            NAMED_ARMATURES.put(registryName, armature);
            this.skinTypes.forEach(it -> LINKED_ARMATURES.put(it, armature));
            return armature;
        }

        static /* synthetic */ Armature access$000(String x0) {
            return Builder.named(x0);
        }
    }
}

