/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.capability;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Objects;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.data.slot.SkinSlotType;
import moe.plushie.armourers_workshop.utils.DataFixerUtils;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.ShortNBT;
import net.minecraft.util.NonNullList;

public class SkinWardrobeStorage {
    public static void saveDataFixer(SkinWardrobe wardrobe, CompoundNBT nbt) {
        nbt.func_74774_a("DataVersion", (byte)1);
    }

    public static void loadDataFixer(SkinWardrobe wardrobe, CompoundNBT nbt) {
        byte version = nbt.func_74771_c("DataVersion");
        if (version <= 0) {
            IInventory inventory = wardrobe.getInventory();
            DataFixerUtils.move(inventory, 67, SkinSlotType.DYE.getIndex(), 16, "align dye slots storage");
            DataFixerUtils.move(inventory, 57, SkinSlotType.OUTFIT.getIndex(), 10, "align outfit slots storage");
        }
    }

    public static void saveInventoryItems(IInventory inventory, CompoundNBT nbt) {
        NonNullList itemStacks = NonNullList.func_191197_a((int)inventory.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < itemStacks.size(); ++i) {
            itemStacks.set(i, (Object)inventory.func_70301_a(i));
        }
        ItemStackHelper.func_191282_a((CompoundNBT)nbt, (NonNullList)itemStacks);
    }

    public static void loadInventoryItems(IInventory inventory, CompoundNBT nbt) {
        NonNullList itemStacks = NonNullList.func_191197_a((int)inventory.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)nbt, (NonNullList)itemStacks);
        for (int i = 0; i < itemStacks.size(); ++i) {
            ItemStack oldItemStack;
            ItemStack newItemStack = (ItemStack)itemStacks.get(i);
            if (Objects.equals(newItemStack, oldItemStack = inventory.func_70301_a(i))) continue;
            inventory.func_70299_a(i, newItemStack);
        }
    }

    public static void saveFlags(BitSet flags, CompoundNBT nbt) {
        int value = 0;
        for (int i = 0; i < 32; ++i) {
            if (!flags.get(i)) continue;
            value |= 1 << i;
        }
        if (value != 0) {
            nbt.func_74768_a("Visibility", value);
        }
    }

    public static void loadFlags(BitSet flags, CompoundNBT nbt) {
        int value = nbt.func_74762_e("Visibility");
        flags.clear();
        for (int i = 0; i < 32; ++i) {
            int mask = 1 << i;
            if ((value & mask) == 0) continue;
            flags.set(i);
        }
    }

    public static void saveSkinSlots(HashMap<SkinSlotType, Integer> slots, CompoundNBT nbt) {
        if (slots.isEmpty()) {
            return;
        }
        ListNBT value = new ListNBT();
        slots.forEach((slotType, count) -> {
            int index = slotType.getId() & 0xFF;
            int encoded = index << 8 | count & 0xFF;
            value.add((Object)ShortNBT.func_229701_a_((short)((short)encoded)));
        });
        if (!value.isEmpty()) {
            nbt.func_218657_a("Slots", (INBT)value);
        }
    }

    public static void loadSkinSlots(HashMap<SkinSlotType, Integer> slots, CompoundNBT nbt) {
        ListNBT value = nbt.func_150295_c("Slots", 2);
        if (value.isEmpty()) {
            return;
        }
        for (int i = 0; i < value.size(); ++i) {
            short encoded = value.func_202170_f(i);
            SkinSlotType slotType = SkinSlotType.byId(encoded >> 8 & 0xFF);
            if (slotType == null) continue;
            slots.put(slotType, encoded & 0xFF);
        }
    }
}

