/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.bake;

import java.util.Collection;
import moe.plushie.armourers_workshop.api.client.IVertexConsumer;
import moe.plushie.armourers_workshop.api.common.ITextureKey;
import moe.plushie.armourers_workshop.api.common.ITextureOptions;
import moe.plushie.armourers_workshop.api.math.IPoseStack;
import moe.plushie.armourers_workshop.api.math.IRectangle3f;
import moe.plushie.armourers_workshop.api.math.ITransformf;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.api.skin.ISkinPaintType;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkinPart;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderType;
import moe.plushie.armourers_workshop.core.client.other.SkinTextureManager;
import moe.plushie.armourers_workshop.core.data.color.ColorDescriptor;
import moe.plushie.armourers_workshop.core.data.color.ColorScheme;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import moe.plushie.armourers_workshop.core.data.transform.SkinTransform;
import moe.plushie.armourers_workshop.core.skin.face.SkinCubeFace;
import moe.plushie.armourers_workshop.core.skin.painting.SkinPaintTypes;
import moe.plushie.armourers_workshop.core.texture.BakedEntityTexture;
import moe.plushie.armourers_workshop.core.texture.PlayerTextureLoader;
import moe.plushie.armourers_workshop.utils.ColorUtils;
import moe.plushie.armourers_workshop.utils.MathUtils;
import moe.plushie.armourers_workshop.utils.SkinUtils;
import moe.plushie.armourers_workshop.utils.math.OpenRay;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BakedCubeFace {
    private static final PaintColor RAINBOW_TARGET = PaintColor.of(-8421505, SkinPaintTypes.RAINBOW);
    private final IPaintColor paintColor;
    private final int alpha;
    private final Direction direction;
    private final RenderType renderType;
    private final Collection<RenderType> renderTypeVariants;
    private final IRectangle3f shape;
    private final ITransformf transform;
    private final ITextureKey texture;

    public BakedCubeFace(SkinCubeFace face) {
        this.renderType = this.resolveRenderType(face);
        this.renderTypeVariants = this.resolveRenderTypeVariants(face);
        this.direction = face.getDirection();
        this.shape = face.getShape();
        this.transform = face.getTransform();
        this.paintColor = face.getColor();
        this.alpha = face.getAlpha();
        this.texture = face.getTexture();
    }

    public void render(BakedSkinPart part, ColorScheme scheme, int lightmap, int overlay, IPoseStack poseStack, IVertexConsumer builder) {
        IPaintColor resolvedColor = this.resolveColor(this.paintColor, scheme, part.getColorInfo(), part.getType(), 0);
        if (resolvedColor.getPaintType() == SkinPaintTypes.NONE) {
            return;
        }
        ITextureKey resolvedTexture = this.resolveTexture(resolvedColor);
        if (resolvedTexture == null) {
            return;
        }
        if (this.transform != SkinTransform.IDENTITY) {
            poseStack.pushPose();
            this.transform.apply(poseStack);
        }
        IPoseStack.Pose entry = poseStack.last();
        float x = this.shape.getX();
        float y = this.shape.getY();
        float z = this.shape.getZ();
        float w = this.roundUp(this.shape.getWidth());
        float h = this.roundUp(this.shape.getHeight());
        float d = this.roundUp(this.shape.getDepth());
        float u = resolvedTexture.getU();
        float v = resolvedTexture.getV();
        float s = this.roundDown(resolvedTexture.getWidth());
        float t = this.roundDown(resolvedTexture.getHeight());
        float n = resolvedTexture.getTotalWidth();
        float m = resolvedTexture.getTotalHeight();
        int r = resolvedColor.getRed();
        int g = resolvedColor.getGreen();
        int b = resolvedColor.getBlue();
        int a = this.alpha & 0xFF;
        if (overlay != 0) {
            float i = (float)(overlay >> 24 & 0xFF) / 255.0f;
            r = ColorUtils.mix(r, overlay >> 16 & 0xFF, i);
            g = ColorUtils.mix(g, overlay >> 8 & 0xFF, i);
            b = ColorUtils.mix(b, overlay & 0xFF, i);
        }
        float[][] uvs = SkinUtils.getRenderUVs(this.direction, this.resolveTextureRotation(resolvedTexture));
        float[][] vertexes = SkinUtils.getRenderVertexes(this.direction);
        for (int i = 0; i < 4; ++i) {
            builder.vertex(entry, x + w * vertexes[i][0], y + h * vertexes[i][1], z + d * vertexes[i][2]).color(r, g, b, a).uv((u + s * uvs[i][0]) / n, (v + t * uvs[i][1]) / m).overlayCoords(OverlayTexture.field_229196_a_).uv2(lightmap).normal(entry, vertexes[4][0], vertexes[4][1], vertexes[4][2]).endVertex();
        }
        if (this.transform != SkinTransform.IDENTITY) {
            poseStack.popPose();
        }
    }

    private IPaintColor resolveColor(IPaintColor paintColor, ColorScheme scheme, ColorDescriptor descriptor, ISkinPartType partType, int deep) {
        ISkinPaintType paintType = paintColor.getPaintType();
        if (paintType == SkinPaintTypes.NONE) {
            return PaintColor.CLEAR;
        }
        if (paintType == SkinPaintTypes.RAINBOW) {
            return this.dye(paintColor, RAINBOW_TARGET, descriptor.getAverageColor(paintType));
        }
        if (paintType == SkinPaintTypes.TEXTURE) {
            IPaintColor paintColor1 = this.resolveTextureColor(scheme.getTexture(), partType);
            if (paintColor1 != null) {
                return paintColor;
            }
            return paintColor;
        }
        if (paintType.getDyeType() != null && deep < 2) {
            IPaintColor paintColor1 = scheme.getResolvedColor(paintType);
            if (paintColor1 == null) {
                return paintColor;
            }
            paintColor = this.dye(paintColor, paintColor1, descriptor.getAverageColor(paintType));
            return this.resolveColor(paintColor, scheme, descriptor, partType, deep + 1);
        }
        return paintColor;
    }

    private IPaintColor resolveTextureColor(ResourceLocation texture, ISkinPartType partType) {
        BakedEntityTexture bakedTexture = PlayerTextureLoader.getInstance().getTextureModel(texture);
        if (bakedTexture != null) {
            int x = (int)this.shape.getX();
            int y = (int)this.shape.getY();
            int z = (int)this.shape.getZ();
            return bakedTexture.getColor(x, y, z, this.direction, partType);
        }
        return null;
    }

    private ITextureKey resolveTexture(IPaintColor paintColor) {
        if (this.texture != null) {
            return this.texture;
        }
        return paintColor.getPaintType().getTexture();
    }

    private int resolveTextureRotation(ITextureKey key) {
        ITextureOptions options = key.getOptions();
        if (options != null) {
            return options.getRotation();
        }
        return 0;
    }

    private RenderType resolveRenderType(SkinCubeFace face) {
        ITextureKey texture = face.getTexture();
        if (texture != null && texture.getProvider() != null) {
            return SkinTextureManager.getInstance().prepareTexture(texture.getProvider());
        }
        return SkinRenderType.by(face.getType());
    }

    private Collection<RenderType> resolveRenderTypeVariants(SkinCubeFace face) {
        ITextureKey texture = face.getTexture();
        if (texture != null && texture.getProvider() != null) {
            return SkinTextureManager.getInstance().prepareVariantTextures(texture.getProvider());
        }
        return null;
    }

    private IPaintColor dye(IPaintColor source, IPaintColor destination, IPaintColor average) {
        if (destination.getPaintType() == SkinPaintTypes.NONE) {
            return PaintColor.CLEAR;
        }
        if (average == null) {
            return source;
        }
        int src = (source.getRed() + source.getGreen() + source.getBlue()) / 3;
        int avg = (average.getRed() + average.getGreen() + average.getBlue()) / 3;
        int r = MathUtils.clamp(destination.getRed() + src - avg, 0, 255);
        int g = MathUtils.clamp(destination.getGreen() + src - avg, 0, 255);
        int b = MathUtils.clamp(destination.getBlue() + src - avg, 0, 255);
        return PaintColor.of(r, g, b, destination.getPaintType());
    }

    private float roundUp(float edg) {
        if (edg == 0.0f) {
            return 0.002f;
        }
        return edg;
    }

    private float roundDown(float edg) {
        if (edg < 0.0f) {
            return edg + 0.002f;
        }
        return edg - 0.002f;
    }

    public boolean intersects(OpenRay ray) {
        float x0 = this.shape.getMinX();
        float y0 = this.shape.getMinY();
        float z0 = this.shape.getMinZ();
        float x1 = this.shape.getMaxX();
        float y1 = this.shape.getMaxY();
        float z1 = this.shape.getMaxZ();
        return ray.intersects(x0, y0, z0, x1, y1, z1);
    }

    public IRectangle3f getShape() {
        return this.shape;
    }

    public ITransformf getTransform() {
        return this.transform;
    }

    public RenderType getRenderType() {
        return this.renderType;
    }

    public Collection<RenderType> getRenderTypeVariants() {
        return this.renderTypeVariants;
    }

    public Direction getDirection() {
        return this.direction;
    }
}

